<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShopifyStoreOrderItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shopify_store_order_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('personalised_gift_app_user_id')->index('shopify_store_order_items_personalised_gift_app_user_id_foreign');
            $table->unsignedBigInteger('shopify_store_order_id')->index('shopify_store_order_items_shopify_store_order_id_foreign');
            $table->string('shopify_order_id')->nullable();
			$table->string('order_item_id')->nullable();
			$table->string('variant_id')->nullable();
			$table->string('shopify_fulfillment_order_id')->nullable();
			$table->string('shopify_fulfillment_order_item_id')->nullable();
			$table->string('shopify_fulfillemnt_id')->nullable();
			$table->string('shopify_fulfillemnt_status')->nullable();
			$table->text('shopify_fulfillemnt_tracking_info')->nullable();
			$table->string('shipping_address_1')->nullable();
			$table->string('shipping_address_2')->nullable();
			$table->string('shipping_address_customer_name')->nullable();
			$table->string('shipping_address_province')->nullable();
			$table->string('shipping_address_zip')->nullable();
			$table->string('shipping_address_phone')->nullable();
			$table->string('title')->nullable();
			$table->string('quantity')->nullable();
			$table->string('sku')->nullable();
			$table->string('variant_title')->nullable();
			$table->string('vendor_name')->nullable();
			$table->string('fulfillment_service')->nullable();
			$table->string('product_id')->constrained();
			$table->string('requires_shipping')->nullable();
			$table->string('taxable')->nullable();
			$table->string('gift_card')->nullable();
			$table->string('name')->nullable();
			$table->string('variant_inventory_management')->nullable();
			$table->text('properties')->nullable();
			$table->string('product_exists')->nullable();
			$table->string('fulfillable_quantity')->nullable();
			$table->string('grams')->nullable();
			$table->string('price')->nullable();
			$table->string('total_discount')->nullable();
			$table->string('fulfillment_status')->nullable();
			$table->text('price_set')->nullable();
			$table->text('total_discount_set')->nullable();
			$table->text('discount_allocations')->nullable();
			$table->text('duties')->nullable();
			$table->string('admin_graphql_api_id')->nullable();
			$table->text('tax_lines')->nullable();
			$table->text('origin_location')->nullable();
			$table->tinyInteger('is_pgs_order_item')->default(0);
			$table->tinyInteger('is_order_shipping_value')->default(0);
			$table->integer('is_pgs_store_order_id')->nullable();
			$table->integer('send_pgs_order_id')->nullable();
			$table->string('pgs_order_status')->nullable();
			$table->string('pgs_order_tracking_id')->nullable();
			$table->text('pgs_order_processed_time')->nullable();
			$table->text('pgs_order_shipping_service')->nullable();
			$table->longText('pgs_order_request')->nullable();
			$table->longText('pgs_order_response')->nullable();
			$table->longText('shopify_order_fulfillment_request')->nullable();
			$table->longText('shopify_order_fulfillment_response')->nullable();
			$table->tinyInteger('is_order_fulfilled')->default(0);
			$table->string('order_type')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shopify_store_order_items');
    }
}
