<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShopifyStoreOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shopify_store_orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('personalised_gift_app_user_id')->index('shopify_store_orders_personalised_gift_app_user_id_foreign');
            $table->unsignedBigInteger('shopify_store_customer_id')->index('shopify_store_orders_shopify_store_customer_id_foreign');
            $table->string('shopify_customer_id')->constrained();
			$table->string('orderId')->nullable();
			$table->string('shopify_fulfillment_order_id')->nullable();
			$table->string('email')->nullable();
			$table->string('order_closed_at')->nullable();
			$table->string('order_created_at')->nullable();
			$table->string('order_updated_at')->nullable();
			$table->string('number')->nullable();
			$table->text('note')->nullable();
			$table->string('token')->nullable();
			$table->string('gateway')->nullable();
			$table->string('test')->nullable();
			$table->string('total_price')->nullable();
			$table->string('subtotal_price')->nullable();
			$table->string('total_weight')->nullable();
			$table->string('total_tax')->nullable();
			$table->string('taxes_included')->nullable();
			$table->string('currency')->nullable();
			$table->string('financial_status')->nullable();
			$table->string('confirmed')->nullable();
			$table->string('total_discounts')->nullable();
			$table->string('total_line_items_price')->nullable();
			$table->string('cart_token')->nullable();
			$table->string('buyer_accepts_marketing')->nullable();
			$table->string('name')->nullable();
			$table->string('referring_site')->nullable();
			$table->text('landing_site')->nullable();
			$table->string('cancelled_at')->nullable();
			$table->string('cancel_reason')->nullable();
			$table->string('checkout_token')->nullable();
			$table->string('reference')->nullable();
			$table->string('location_id')->nullable();
			$table->string('source_identifier')->nullable();
			$table->string('source_url')->nullable();
			$table->string('processed_at')->nullable();
			$table->string('device_id')->nullable();
			$table->string('phone')->nullable();
            $table->string('billing_phone')->nullable();
            $table->string('shipping_phone')->nullable();
			$table->string('customer_locale')->nullable();
			$table->string('app_id')->nullable();
			$table->string('browser_ip')->nullable();
			$table->string('landing_site_ref')->nullable();
			$table->string('order_number')->nullable();
			$table->text('discount_applications')->nullable();
			$table->text('discount_codes')->nullable();
			$table->text('note_attributes')->nullable();
			$table->text('payment_gateway_names')->nullable();
			$table->string('processing_method')->nullable();
			$table->string('checkout_id')->nullable();
			$table->string('source_name')->nullable();
			$table->string('fulfillment_status')->nullable();
			$table->text('tax_lines')->nullable();
			$table->string('tags')->nullable();
			$table->string('contact_email')->nullable();
			$table->string('order_status_url')->nullable();
			$table->string('presentment_currency')->nullable();
			$table->text('total_line_items_price_set')->nullable();
			$table->text('total_discounts_set')->nullable();
			$table->text('total_shipping_price_set')->nullable();
			$table->text('subtotal_price_set')->nullable();
			$table->text('total_price_set')->nullable();
			$table->text('total_tax_set')->nullable();
			$table->text('line_items')->nullable();
			$table->text('fulfillments')->nullable();
			$table->text('refunds')->nullable();
			$table->string('total_tip_received')->nullable();
			$table->string('original_total_duties_set')->nullable();
			$table->string('current_total_duties_set')->nullable();
			$table->string('admin_graphql_api_id')->nullable();
			$table->text('shipping_lines')->nullable();
			$table->text('billing_address')->nullable();
			$table->text('shipping_address')->nullable();
			$table->text('client_details')->nullable();
			$table->text('payment_details')->nullable();
			$table->tinyInteger('is_error')->default(0);
			$table->text('delivery_date')->nullable();
			$table->integer('is_pgs_order')->default(0);
			$table->string('order_type')->nullable();
			$table->text('original_fulfillment_order')->nullable();
			$table->text('submitted_fulfillment_order')->nullable();
			$table->text('unsubmitted_fulfillment_order')->nullable();
			$table->text('accept_fulfillment_request_order_response')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shopify_store_orders');
    }
}
