<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShopifyStoreCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shopify_store_customers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('personalised_gift_app_user_id')->index('shopify_store_customers_personalised_gift_app_user_id_foreign');
            $table->string('customer_id')->constrained();
			$table->string('email')->nullable();
			$table->string('accepts_marketing')->nullable();
			$table->string('customer_created_at')->nullable();
			$table->string('customer_updated_at')->nullable();
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('state')->nullable();
			$table->text('note')->nullable();
			$table->string('verified_email')->nullable();
			$table->string('multipass_identifier')->nullable();
			$table->string('tax_exempt')->nullable();
			$table->string('phone')->nullable();
			$table->string('tags')->nullable();
			$table->string('currency')->nullable();
			$table->string('accepts_marketing_updated_at')->nullable();
			$table->string('marketing_opt_in_level')->nullable();
			$table->string('admin_graphql_api_id')->nullable();
			$table->text('default_address')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shopify_store_customers');
    }
}
