<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHookProductInventoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hook_product_inventories', function (Blueprint $table) {
            $table->id();
            $table->string('shop_domain')->nullable();
            $table->string('inventory_item_id')->nullable();
			$table->longText('data')->nullable();
			$table->tinyInteger('is_updated')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hook_product_inventories');
    }
}
