<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHookOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hook_orders', function (Blueprint $table) {
            $table->id();
            $table->string('shop_domain')->nullable();
            $table->string('order_id')->nullable();
			$table->longText('data')->nullable();
			$table->tinyInteger('is_updated')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hook_orders');
    }
}
