<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShopifyMetafieldsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shopify_metafields', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('personalised_gift_app_user_id')->index('shopify_metafields_personalised_gift_app_user_id_foreign');
            $table->bigInteger('resource_id')->nullable();
            $table->string('resource_type')->nullable();
            $table->string('metafield_id')->nullable();
            $table->string('metafield_namespace')->nullable();
            $table->string('metafield_key')->nullable();
            $table->string('metafield_type')->nullable();
            $table->longText('metafield_value')->nullable();
            $table->string('owner_id')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shopify_metafields');
    }
}
