<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePersonalisedGiftAppCategoryProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('personalised_gift_app_category_products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('personalised_gift_app_category_id')->index('personalised_gift_app_category_id_foreign');
            $table->unsignedBigInteger('personalised_gift_app_product_id')->index('personalised_gift_app_product_id_foreign');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('personalised_gift_app_category_products');
    }
}
