<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePersonalisedGiftAppCategoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('personalised_gift_app_categories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('personalised_gift_app_user_id')->index('personalised_gift_app_user_id_foreign');
            $table->string('shopify_collection_id')->nullable();
            $table->string('shopify_graph_ql_id')->nullable();
            $table->string('shopify_category_handle')->nullable();     
            $table->string('shop_domain')->nullable();
            $table->integer('term_id')->nullable();
            $table->string('name')->nullable();
            $table->string('slug')->nullable();
            $table->string('term_group')->nullable();
            $table->string('term_taxonomy_id')->nullable();
            $table->string('taxonomy')->nullable();
            $table->text('description')->nullable();
            $table->string('parent')->nullable();
            $table->string('count')->nullable();
            $table->string('filter')->nullable();
            $table->text('background_image')->nullable();       
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('personalised_gift_app_categories');
    }
}
