<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePersonalisedGiftAppProductMetasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('personalised_gift_app_product_metas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('personalised_gift_app_product_id')->index('personalised_gift_app_product_id_foreign');
            $table->float('product_rrp_price', 8, 2)->default(0);
            $table->float('pgs_product_price', 8, 2)->default(0);
            $table->string('bigcommerce_importer_version')->nullable();
            $table->integer('bigcommerce_id')->nullable();
            $table->string('bigcommerce_sku')->nullable();
            $table->string('bigcommerce_sku_normalized')->nullable();
            $table->float('bigcommerce_rating', 8, 2)->default(0);
            $table->integer('bigcommerce_review_count')->nullable();
            $table->float('bigcommerce_review_rating_sum', 8, 2)->default(0);
            $table->string('bigcommerce_sales')->nullable();
            $table->float('bigcommerce_calculated_price', 8, 2)->default(0);
            $table->string('bigcommerce_inventory_level')->nullable();
            $table->integer('product_quantity')->default(0);
            $table->longText('bigcommerce_price_range')->nullable();
            $table->string('bigcommerce_data_hash')->nullable();
            $table->date('wp_old_date')->nullable();
            $table->longText('bigcommerce_source_data')->nullable();
            $table->longText('bigcommerce_listing_data')->nullable();
            $table->longText('bigcommerce_modifier_data')->nullable();
            $table->longText('bigcommerce_options_data')->nullable();
            $table->longText('bigcommerce_custom_fields')->nullable();
            $table->integer('thumbnail_id')->nullable();
            $table->text('bigcommerce_gallery')->nullable();
            $table->text('bigcommerce_variant_images')->nullable();
            $table->text('bigcommerce_reviews')->nullable();
            $table->integer('bigcommerce_approved_review_count')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('personalised_gift_app_product_metas');
    }
}
