<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePersonalisedGiftAppProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('personalised_gift_app_products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('personalised_gift_app_user_id')->index('personalised_gift_app_user_id_foreign');
            $table->string('shop_domain')->nullable();
            $table->string('shopify_product_id')->nullable();
            $table->string('shopify_graph_ql_id')->nullable();
            $table->string('shopify_product_handle')->nullable();     
            $table->string('shopify_product_variant_id')->nullable();
            $table->string('shopify_product_inventory_item_id')->nullable();
            $table->integer('post_id')->nullable();
            $table->integer('post_author')->default(0);
            $table->dateTime('post_date')->nullable();
            $table->dateTime('post_date_gmt')->nullable();
            $table->text('post_content')->nullable();
            $table->longText('post_title')->nullable();
            $table->string('post_excerpt')->nullable();
            $table->string('post_status')->nullable();
            $table->string('comment_status')->nullable();
            $table->string('ping_status')->nullable();
            $table->string('post_password')->nullable();
            $table->text('post_name')->nullable();
            $table->string('to_ping')->nullable();
            $table->string('pinged')->nullable();
            $table->dateTime('post_modified')->nullable();
            $table->dateTime('post_modified_gmt')->nullable();
            $table->text('post_content_filtered')->nullable();
            $table->string('post_parent')->nullable();
            $table->string('guid')->nullable();
            $table->string('menu_order')->nullable();
            $table->string('post_type')->nullable();
            $table->string('post_mime_type')->nullable();
            $table->integer('comment_count')->nullable();
            $table->string('filter')->nullable();
            $table->text('pgs_link')->nullable();
            $table->text('shopify_edit_product_link')->nullable();
            $table->text('shopify_preview_product_link')->nullable();
            $table->longText('customiser_data')->nullable();
            $table->longText('reseller_pricing')->nullable();
            $table->text('extra_images')->nullable();
            $table->text('atp_images')->nullable();
            $table->text('thumbnail_image')->nullable();
            $table->tinyInteger('is_update_product_price')->default(0);
            $table->integer('shopify_category_taxonomy_id')->nullable();
            $table->string('listing_type')->nullable();
            $table->string('product_created_by')->nullable();
            $table->string('shopify_product_status')->nullable();
            $table->tinyInteger('is_shopify_product')->default(0);
            $table->tinyInteger('is_publish_shopify_product')->default(0);
            $table->tinyInteger('is_update_cost_price')->default(0);
            $table->tinyInteger('is_job_process')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('personalised_gift_app_products');
    }
}
