<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePersonalisedGiftAppClipartsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('personalised_gift_app_cliparts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('personalised_gift_app_user_id')->index('personalised_gift_app_user_id_foreign');
            $table->string('name')->nullable();
            $table->string('internal_name')->nullable();
            $table->text('image_url')->nullable();
            $table->string('height')->nullable();
            $table->string('width')->nullable();
            $table->string('store_image_name')->nullable();
            $table->string('shopify_file_id')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('personalised_gift_app_cliparts');
    }
}
