<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePersonalisedGiftAppFontsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('personalised_gift_app_fonts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('personalised_gift_app_user_id')->index('personalised_gift_app_user_id_foreign');
            $table->string('name_of_font')->nullable();
            $table->text('font_file')->nullable();
            $table->string('font_type')->nullable();
            $table->string('shopify_file_id')->nullable();
            $table->string('store_font_file_name')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('personalised_gift_app_fonts');
    }
}
