<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePersonalisedGiftAppUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('personalised_gift_app_users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('shopify_auth_session_id')->index('personalised_gift_app_users_shopify_auth_session_id_foreign');
            $table->string('shop_domain')->nullable();
            $table->string('shopify_auth_token')->nullable();
            $table->string('username')->nullable();
            $table->text('api_key')->nullable();
            $table->integer('last_sync_page')->default(0);
            $table->tinyInteger('personalised_app_user_status')->default(0);
            $table->string('shopify_store_id')->nullable();
            $table->string('store_location_id')->nullable();
            $table->string('store_sales_channel_id')->nullable();
            $table->string('shopify_store_active_theme_id')->nullable();
            $table->integer('total_pgs_products')->default(0);
            $table->integer('total_pgs_product_page_limit')->default(0);
            $table->integer('total_sync_products')->default(0);
            $table->integer('total_pgs_fonts')->default(0);
            $table->integer('total_send_shopify_files_pgs_fonts')->default(0);
            $table->integer('total_pgs_cliparts')->default(0);
            $table->integer('total_send_shopify_files_pgs_cliparts')->default(0);
            $table->string('next_day_shipping_type_value')->nullable();
            $table->tinyInteger('automatically_process_order')->default(0);
            $table->tinyInteger('process_shared_order')->default(0);
            $table->tinyInteger('import_category')->default(0);
            $table->tinyInteger('import_all')->default(0);
            $table->tinyInteger('set_personalised_button_position')->default(0);
            $table->string('set_personalised_button_selector')->nullable();
            $table->string('pricing_options')->nullable();
            $table->integer('margin_change')->default(0);
            $table->float('deduct_price_change')->default('0.00');
            $table->string('price_range_values')->nullable();
            $table->string('upload_product_status')->nullable();
            $table->text('fulfillment_service_response')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('personalised_gift_app_users');
    }
}
