<?php

use Monolog\Handler\NullHandler;
use Monolog\Handler\StreamHandler;
use Monolog\Handler\SyslogUdpHandler;

return [

    /*
    |--------------------------------------------------------------------------
    | Default Log Channel
    |--------------------------------------------------------------------------
    |
    | This option defines the default log channel that gets used when writing
    | messages to the logs. The name specified in this option should match
    | one of the channels defined in the "channels" configuration array.
    |
    */

    'default' => env('LOG_CHANNEL', 'stack'),

    /*
    |--------------------------------------------------------------------------
    | Log Channels
    |--------------------------------------------------------------------------
    |
    | Here you may configure the log channels for your application. Out of
    | the box, Laravel uses the Monolog PHP logging library. This gives
    | you a variety of powerful log handlers / formatters to utilize.
    |
    | Available Drivers: "single", "daily", "slack", "syslog",
    |                    "errorlog", "monolog",
    |                    "custom", "stack"
    |
    */

    'channels' => [
        'stack' => [
            'driver' => 'stack',
            'channels' => ['single'],
            'ignore_exceptions' => false,
        ],

        'single' => [
            'driver' => 'single',
            'path' => storage_path('logs/laravel.log'),
            'level' => env('LOG_LEVEL', 'debug'),
        ],

        'daily' => [
            'driver' => 'daily',
            'path' => storage_path('logs/laravel.log'),
            'level' => env('LOG_LEVEL', 'debug'),
            'days' => 14,
        ],

        'slack' => [
            'driver' => 'slack',
            'url' => env('LOG_SLACK_WEBHOOK_URL'),
            'username' => 'Laravel Log',
            'emoji' => ':boom:',
            'level' => env('LOG_LEVEL', 'critical'),
        ],

        'papertrail' => [
            'driver' => 'monolog',
            'level' => env('LOG_LEVEL', 'debug'),
            'handler' => SyslogUdpHandler::class,
            'handler_with' => [
                'host' => env('PAPERTRAIL_URL'),
                'port' => env('PAPERTRAIL_PORT'),
            ],
        ],

        'stderr' => [
            'driver' => 'monolog',
            'level' => env('LOG_LEVEL', 'debug'),
            'handler' => StreamHandler::class,
            'formatter' => env('LOG_STDERR_FORMATTER'),
            'with' => [
                'stream' => 'php://stderr',
            ],
        ],

        'syslog' => [
            'driver' => 'syslog',
            'level' => env('LOG_LEVEL', 'debug'),
        ],

        'errorlog' => [
            'driver' => 'errorlog',
            'level' => env('LOG_LEVEL', 'debug'),
        ],

        'null' => [
            'driver' => 'monolog',
            'handler' => NullHandler::class,
        ],

        'emergency' => [
            'path' => storage_path('logs/laravel.log'),
        ],

        'shopify-product' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-product.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'shopify-category' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-category.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'shopify-files' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-files.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'shopify-orders' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-orders.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'parsing-orders' => [
            'driver' => 'daily',
            'path' => storage_path('logs/parsing-orders.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'pgs-orders' => [
            'driver' => 'daily',
            'path' => storage_path('logs/pgs-orders.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'pgs-order-status' => [
            'driver' => 'daily',
            'path' => storage_path('logs/pgs-order-status.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'shopify-product-inventory' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-product-inventory.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'get-order-fulfillment-job' => [
            'driver' => 'daily',
            'path' => storage_path('logs/get-order-fulfillment-job.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'create-order-fulfillment-job' => [
            'driver' => 'daily',
            'path' => storage_path('logs/create-order-fulfillment-job.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'pgs-app-status' => [
            'driver' => 'daily',
            'path' => storage_path('logs/pgs-app-status.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'uninstall-pgs-app-webhook-status' => [
            'driver' => 'daily',
            'path' => storage_path('logs/uninstall-pgs-app-webhook-status.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'shopify-customer-request-webhook' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-customer-request-webhook.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'shopify-customer-request-webhook-request' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-customer-request-webhook-request.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'shopify-customer-redact-webhook-request' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-customer-redact-webhook-request.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'shopify-shop-redact-webhook-request' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-shop-redact-webhook-request.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'syncing-sku-product-quantity' => [
            'driver' => 'daily',
            'path' => storage_path('logs/syncing-sku-product-quantity.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'automatic-publish-shopify-product-job' => [
            'driver' => 'daily',
            'path' => storage_path('logs/automatic-publish-shopify-product-job.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'create-automated-shopify-products' => [
            'driver' => 'daily',
            'path' => storage_path('logs/create-automated-shopify-products.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'pgs-product-hook-request' => [
            'driver' => 'daily',
            'path' => storage_path('logs/pgs-product-hook-request.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'delete-pgs-product-hook-request' => [
            'driver' => 'daily',
            'path' => storage_path('logs/delete-pgs-product-hook-request.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'automatic-update-shopify-product-price' => [
            'driver' => 'daily',
            'path' => storage_path('logs/automatic-update-shopify-product-price.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'update-shopify-product-price' => [
            'driver' => 'daily',
            'path' => storage_path('logs/update-shopify-product-price.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'automatic-sync-pgs-product-job' => [
            'driver' => 'daily',
            'path' => storage_path('logs/automatic-sync-pgs-product-job.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'deleted-products' => [
            'driver' => 'daily',
            'path' => storage_path('logs/deleted-products.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'updated-shopify-products' => [
            'driver' => 'daily',
            'path' => storage_path('logs/updated-shopify-products.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'personalised-button-positions' => [
            'driver' => 'daily',
            'path' => storage_path('logs/personalised-button-positions.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'automatic-update-active-product-status' => [
            'driver' => 'daily',
            'path' => storage_path('logs/automatic-update-active-product-status.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'automatic-update-archived-product-status' => [
            'driver' => 'daily',
            'path' => storage_path('logs/automatic-update-archived-product-status.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'store-pgs-products' => [
            'driver' => 'daily',
            'path' => storage_path('logs/store-pgs-products.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'pgs-app-delete-products' => [
            'driver' => 'daily',
            'path' => storage_path('logs/pgs-app-delete-products.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'pgs-app-update-products' => [
            'driver' => 'daily',
            'path' => storage_path('logs/pgs-app-update-products.log'),
            'level' => 'info',
            'permission' => 0777,
        ],
        
        'check-cron-products' => [
            'driver' => 'daily',
            'path' => storage_path('logs/check-cron-products.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'shopify-update-product' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-update-product.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'automatic-update-shopify-inventory-cost-price' => [
            'driver' => 'daily',
            'path' => storage_path('logs/automatic-update-shopify-inventory-cost-price.log'),
            'level' => 'info',
            'permission' => 0777,
        ],

        'shopify-fulfillment-service' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-fulfillment-service.log'),
            'level' => 'info',
            'permission' => 0777,
        ], 

        'shopify-fulfillment-request' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-fulfillment-request.log'),
            'level' => 'info',
            'permission' => 0777,
        ], 

        'accept-fulfillment-request' => [
            'driver' => 'daily',
            'path' => storage_path('logs/accept-fulfillment-request.log'),
            'level' => 'info',
            'permission' => 0777,
        ], 

        'shopify-order-fulfillment-request' => [
            'driver' => 'daily',
            'path' => storage_path('logs/shopify-order-fulfillment-request.log'),
            'level' => 'info',
            'permission' => 0777,
        ], 

    ],

];
