<?php

namespace App\Traits;
use Illuminate\Http\Request;

trait PersonalisedAppTrait {

    /**
     * Does very basic image validity checking and stores it. Redirects back if somethings wrong.
     * @Notice: This is not an alternative to the model validation for this field.
     *
     * @param Request $request
     * @return $this|false|string
     */
    public static function callPersonalisedAppAPI($ApiUrl, $method, $apiKey, $username, $postData = null)
    {
        $headers = array(
            "Content-type: application/json",
            "token: $apiKey",
            "username: $username"
        );

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $ApiUrl);
        
        curl_setopt($curl, CURLOPT_HTTPHEADER,$headers);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_VERBOSE, 0);
        // curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        if($method != "GET"){
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($postData));
        }
        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);     

        $response = curl_exec ($curl);
        curl_close ($curl);
        
        return $response;

    }

    public static function callCurlShopifyRestAPI($ApiUrl, $method, $postData = null, $password)
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $ApiUrl);
         $headers = array(
            "X-Shopify-Access-Token: " . $password,
            "Content-Type: application/json",
            "charset: utf-8",
        );
    
        curl_setopt($curl, CURLOPT_HTTPHEADER,$headers);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_VERBOSE, 0);
        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        if($method != "GET"){
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($postData));
        }        
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);

        $response = curl_exec ($curl);
        curl_close ($curl);

        return $response;
    }
    
}
