<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShopifyStoreWebhook extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'personalised_gift_app_user_id',
        'webhook_id',
        'topic',
        'format',
        'api_version',
        'address',
    ];
    
    public function personalisedGiftAppUser() {
		return $this->belongsTo('App\Models\PersonalisedGiftAppUser', 'personalised_gift_app_user_id');
	}

}
