<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShopifyStoreOrderItem extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'personalised_gift_app_user_id',
        'shopify_store_order_id',
        'shopify_order_id',
        'order_item_id',
        'variant_id',
        'shopify_fulfillment_order_id',
        'shopify_fulfillment_order_item_id',
        'shopify_fulfillemnt_id',
        'shopify_fulfillemnt_status',
        'shopify_fulfillemnt_tracking_info',
        'shipping_address_1',
        'shipping_address_2',
        'shipping_address_customer_name',
        'shipping_address_province',
        'shipping_address_zip',
        'shipping_address_phone',
        'title',
        'quantity',
        'sku',
        'variant_title',
        'vendor_name',
        'fulfillment_service',
        'product_id',
        'requires_shipping',
        'taxable',
        'gift_card',
        'name',
        'variant_inventory_management',
        'properties',
        'product_exists',
        'fulfillable_quantity',
        'grams',
        'price',
        'total_discount',
        'fulfillment_status',
        'price_set',
        'total_discount_set',
        'discount_allocations',
        'duties',
        'admin_graphql_api_id',
        'tax_lines',
        'origin_location',
        'is_pgs_order_item',
        'is_order_shipping_value',
        'is_pgs_store_order_id',
        'send_pgs_order_id',
        'pgs_order_status',
        'pgs_order_tracking_id',
        'pgs_order_processed_time',
        'pgs_order_shipping_service',
        'pgs_order_request',
        'pgs_order_response',
        'shopify_order_fulfillment_request',
        'shopify_order_fulfillment_response',
        'is_order_fulfilled',
        'order_type'
    ];

    public function shopifyStoreOrder() {
		return $this->belongsTo('App\Models\ShopifyStoreOrder');
	}
	
	public function personalisedGiftAppUser() {
		return $this->belongsTo('App\Models\PersonalisedGiftAppUser', 'personalised_gift_app_user_id');
	}

}
