<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShopifyStoreOrder extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'personalised_gift_app_user_id',
        'shopify_store_customer_id',
        'shopify_customer_id',
        'orderId',
        'shopify_fulfillment_order_id',
        'email',
        'order_closed_at',
        'order_created_at',
        'order_updated_at',
        'number',
        'note',
        'token',
        'gateway',
        'test',
        'total_price',
        'subtotal_price',
        'total_weight',
        'total_tax',
        'taxes_included',
        'currency',
        'financial_status',
        'confirmed',
        'total_discounts',
        'total_line_items_price',
        'cart_token',
        'buyer_accepts_marketing',
        'name',
        'referring_site',
        'landing_site',
        'cancelled_at',
        'cancel_reason',
        'checkout_token',
        'reference',
        'location_id',
        'source_identifier',
        'source_url',
        'processed_at',
        'device_id',
        'phone',
        'billing_phone',
        'shipping_phone',
        'customer_locale',
        'app_id',
        'browser_ip',
        'landing_site_ref',
        'order_number',
        'discount_applications',
        'discount_codes',
        'note_attributes',
        'payment_gateway_names',
        'processing_method',
        'checkout_id',
        'source_name',
        'fulfillment_status',
        'tax_lines',
        'tags',
        'contact_email',
        'order_status_url',
        'presentment_currency',
        'total_line_items_price_set',
        'total_discounts_set',
        'total_shipping_price_set',
        'subtotal_price_set',
        'total_price_set',
        'total_tax_set',
        'line_items',
        'fulfillments',
        'refunds',
        'total_tip_received',
        'original_total_duties_set',
        'current_total_duties_set',
        'admin_graphql_api_id',
        'shipping_lines',
        'billing_address',
        'shipping_address',
        'client_details',
        'payment_details',
        'delivery_date',
        'is_pgs_order',
        'order_type',
        'original_fulfillment_order',
        'submitted_fulfillment_order',
        'unsubmitted_fulfillment_order',
        'accept_fulfillment_request_order_response'
    ];

    public function shopifyStoreCustomer() {
		return $this->belongsTo('App\Models\ShopifyStoreCustomer');
	}

    public function shopifyStoreOrderItem() {
        return $this->hasMany('App\Models\ShopifyStoreOrderItem');
    }

    public function totalPgsShopifyStoreOrderItem() {
        return $this->hasMany('App\Models\ShopifyStoreOrderItem')->where('is_pgs_order_item', 1)->whereNotNull('is_pgs_store_order_id');
    }

    public function getPgsShopifyStoreOrderItem() {
        return $this->hasMany('App\Models\ShopifyStoreOrderItem')->where('is_pgs_order_item', 1);
    }

    public function personalisedGiftAppUser() {
		return $this->belongsTo('App\Models\PersonalisedGiftAppUser', 'personalised_gift_app_user_id');
	}
    
}
