<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShopifyStoreCustomer extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'personalised_gift_app_user_id',
        'customer_id',
        'email',
        'accepts_marketing',
        'customer_created_at',
        'customer_updated_at',
        'first_name',
        'last_name',
        'state',
        'note',
        'verified_email',
        'multipass_identifier',
        'tax_exempt',
        'phone',
        'tags',
        'currency',
        'accepts_marketing_updated_at',
        'marketing_opt_in_level',
        'admin_graphql_api_id',
        'default_address'
    ];

    public function shopifyStoreOrder() {
		return $this->hasMany('App\Models\ShopifyStoreOrder');
	}
	
	public function personalisedGiftAppUser() {
		return $this->belongsTo('App\Models\PersonalisedGiftAppUser', 'personalised_gift_app_user_id');
	}
	
}
