<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PersonalisedGiftAppUser extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'shopify_auth_session_id',
        'shop_domain',
        'shopify_auth_token',
        'username',
        'api_key',
        'last_sync_page',
        'personalised_app_user_status',
        'shopify_store_id',
        'store_location_id',
        'store_sales_channel_id',
        'shopify_store_active_theme_id',
        'total_pgs_products',
        'total_pgs_product_page_limit',
        'total_sync_products',
        'total_pgs_fonts',
        'total_send_shopify_files_pgs_fonts',
        'total_pgs_cliparts',
        'total_send_shopify_files_pgs_cliparts',
        'next_day_shipping_type_value',
        'automatically_process_order',
        'process_shared_order',
        'import_category',
        'import_all',
        'set_personalised_button_position',
        'set_personalised_button_selector',
        'pricing_options',
        'margin_change',
        'deduct_price_change',
        'price_range_values',
        'upload_product_status',
        'fulfillment_service_response'
    ];

    public function session() {
		return $this->belongsTo('App\Models\Session', 'shopify_auth_session_id');
	}
	
	public function personalisedGiftAppUserProductRanges() {
		return $this->hasMany('App\Models\PersonalisedGiftAppUserProductRanges');
	}
	
	public function personalisedGiftAppCategory() {
		return $this->hasMany('App\Models\PersonalisedGiftAppCategory');
	}
	
	public function personalisedGiftAppClipart() {
		return $this->hasMany('App\Models\PersonalisedGiftAppClipart');
	}
	
	public function personalisedGiftAppFont() {
		return $this->hasMany('App\Models\PersonalisedGiftAppFont');
	}
	
	public function personalisedGiftAppProduct() {
		return $this->hasMany('App\Models\PersonalisedGiftAppProduct');
	}
	
	public function shopifyMetafield() {
		return $this->hasMany('App\Models\ShopifyMetafield');
	}
	
	public function shopifyStoreCustomer() {
		return $this->hasMany('App\Models\ShopifyStoreCustomer');
	}
	
	public function shopifyStoreOrder() {
		return $this->hasMany('App\Models\ShopifyStoreOrder');
	}
	
	public function shopifyStoreOrderItem() {
		return $this->hasMany('App\Models\ShopifyStoreOrderItem');
	}
	
	public function shopifyStoreWebhook() {
		return $this->hasMany('App\Models\ShopifyStoreWebhook');
	}
	

}
