<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PersonalisedGiftAppProductMeta extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'personalised_gift_app_product_id',
        'bigcommerce_importer_version',
        'bigcommerce_id',
        'bigcommerce_sku',
        'bigcommerce_sku_normalized',
        'bigcommerce_rating',
        'bigcommerce_review_count',
        'bigcommerce_review_rating_sum',
        'bigcommerce_sales',
        'bigcommerce_calculated_price',
        'product_rrp_price',
        'pgs_product_price',
        'bigcommerce_inventory_level',
        'product_quantity',
        'bigcommerce_price_range',
        'bigcommerce_data_hash',
        'wp_old_date',
        'bigcommerce_source_data',
        'bigcommerce_listing_data',
        'bigcommerce_modifier_data',
        'bigcommerce_options_data',
        'bigcommerce_custom_fields',
        'thumbnail_id',
        'bigcommerce_gallery',
        'bigcommerce_variant_images',
        'bigcommerce_reviews',
        'bigcommerce_approved_review_count',
    ];

    public function personalisedGiftAppProduct() {
		return $this->belongsTo('App\Models\PersonalisedGiftAppProduct', 'personalised_gift_app_product_id');
	}

}
