<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PersonalisedGiftAppProduct extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'personalised_gift_app_user_id',
        'shopify_product_id',
        'shopify_graph_ql_id',
        'shopify_product_variant_id',
        'shopify_product_inventory_item_id',
        'shop_domain',
        'post_id',
        'post_author',
        'post_date',
        'post_date_gmt',
        'post_content',
        'post_title',
        'post_excerpt',
        'post_status',
        'comment_status',
        'ping_status',
        'post_password',
        'post_name',
        'to_ping',
        'pinged',
        'post_modified',
        'post_modified_gmt',
        'post_content_filtered',
        'post_parent',
        'guid',
        'menu_order',
        'post_type',
        'post_mime_type',
        'comment_count',
        'filter',
        'pgs_link',
        'shopify_edit_product_link',
        'shopify_preview_product_link',
        'shopify_product_handle',
        'customiser_data',
        'reseller_pricing',
        'extra_images',
        'atp_images',
        'thumbnail_image',
        'is_update_product_price',
        'shopify_category_taxonomy_id',
        'listing_type',
        'shopify_product_status',
        'is_shopify_product',
        'is_publish_shopify_product',
        'product_created_by',
        'is_job_process',
        'is_update_cost_price'
    ];

    public function personalisedGiftAppProductMeta() {
		return $this->hasOne('App\Models\PersonalisedGiftAppProductMeta');
	}

    public function personalisedGiftAppCategoryProduct() {
		return $this->hasOne('App\Models\PersonalisedGiftAppCategoryProduct');
	}
	
	public function personalisedGiftAppUser() {
		return $this->belongsTo('App\Models\PersonalisedGiftAppUser', 'personalised_gift_app_user_id');
	}

}
