<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PersonalisedGiftAppClipart extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'personalised_gift_app_user_id',
        'name',
        'internal_name',
        'image_url',
        'height',
        'width',
        'store_image_name',
        'shopify_file_id',
    ];
    
    public function personalisedGiftAppUser() {
		return $this->belongsTo('App\Models\PersonalisedGiftAppUser', 'personalised_gift_app_user_id');
	}

}
