<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PersonalisedGiftAppCategoryProduct extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'personalised_gift_app_category_id',
        'personalised_gift_app_product_id',
    ];

    public function personalisedGiftAppCategory() {
		return $this->belongsTo('App\Models\PersonalisedGiftAppCategory', 'personalised_gift_app_category_id');
	}

    public function personalisedGiftAppProduct() {
		return $this->belongsTo('App\Models\PersonalisedGiftAppProduct', 'personalised_gift_app_product_id');
	}
	
	public function getCategoryProductCount($categoryId){
	     $records = PersonalisedGiftAppCategoryProduct::where('personalised_gift_app_category_id', $categoryId)->count();
	     return $records;
	}

}
