<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendAccountVerifyEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * The data instance.
     *
     */
     public $data;
    
    /**
     * Create a new message instance.
     *
     * @return void
     */
     public function __construct($data)
     {
         $this->data = $data;
     }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.send-email-verify')        
                ->from(env('API_EMAIL_FROM', 'testdev55@gmail.com'),env('APP_NAME'))
                ->subject('Email Verify Link');
    }
    
}
