<?php

declare(strict_types=1);

namespace App\Lib\Handlers\Gdpr;

use Illuminate\Support\Facades\Log;
use Shopify\Webhooks\Handler;
use App\Models\MandatoryShopifyWebhook;

/**
 * 48 hours after a store owner uninstalls your app, Shopify invokes this
 * webhook.
 *
 * https://shopify.dev/docs/apps/webhooks/configuration/mandatory-webhooks#shop-redact
 */
class ShopRedact implements Handler
{
    public function handle(string $topic, string $shop, array $body): void
    {
        Log::channel('shopify-shop-redact-webhook-request')->info("Gdpr Handling GDPR customer data request for $shop");
        Log::channel('shopify-shop-redact-webhook-request')->info("Gdpr Handling GDPR customer data request topic $topic");
        Log::channel('shopify-shop-redact-webhook-request')->info("Gdpr Customer Request Hook Call for data - ".json_encode($body));
        // Payload has the following shape:
        // {
        //   "shop_id": 954889,
        //   "shop_domain": "{shop}.myshopify.com"
        // }
    }
}
