<?php

declare(strict_types=1);

namespace App\Lib\Handlers\Gdpr;

use Illuminate\Support\Facades\Log;
use Shopify\Webhooks\Handler;
use App\Models\MandatoryShopifyWebhook;

/**
 * Store owners can request that data is deleted on behalf of a customer. When
 * this happens, Shopify invokes this webhook.
 *
 * https://shopify.dev/docs/apps/webhooks/configuration/mandatory-webhooks#customers-redact
 */
class CustomersRedact implements Handler
{
    public function handle(string $topic, string $shop, array $body): void
    {
        Log::channel('shopify-customer-redact-webhook-request')->info("Gdpr Handling GDPR customer data request for $shop");
        Log::channel('shopify-customer-redact-webhook-request')->info("Gdpr Handling GDPR customer data request topic $topic");
        Log::channel('shopify-customer-redact-webhook-request')->info("Gdpr Customer Request Hook Call for data - ".json_encode($body));
        // Payload has the following shape:
        // {
        //   "shop_id": 954889,
        //   "shop_domain": "{shop}.myshopify.com",
        //   "customer": {
        //     "id": 191167,
        //     "email": "john@example.com",
        //     "phone": "555-625-1199"
        //   },
        //   "orders_to_redact": [
        //     299938,
        //     280263,
        //     220458
        //   ]
        // }
    }
}
