<?php

declare(strict_types=1);

namespace App\Lib\Handlers;

use Illuminate\Support\Facades\Log;
use Shopify\Webhooks\Handler;
use App\Models\Session;
use App\Models\ShopifyStoreWebhook;
use App\Models\PgsAppStoreStatus;
use App\Models\PersonalisedGiftAppUser;
use App\Models\PersonalisedGiftAppCategory;
use App\Models\PersonalisedGiftAppCategoryProduct;
use App\Models\PersonalisedGiftAppProduct;
use App\Models\PersonalisedGiftAppProductMeta;
use App\Models\MandatoryShopifyWebhook;
use App\Models\ShopifyMetafield;
use App\Models\PersonalisedGiftAppFont;
use App\Models\PersonalisedGiftAppClipart;
use App\Models\ShopifyStoreCustomer;
use App\Models\ShopifyStoreOrder;
use App\Models\ShopifyStoreOrderItem;
use App\Models\HookOrder;
use App\Models\DeletedHookProduct;
use App\Models\HookProductInventory;
use App\Models\PersonalisedGiftAppUserProductRanges;
use App\Lib\ProductCreator;

class AppUninstalled implements Handler
{
    public function handle(string $topic, string $shop, array $body): void
    {
        Log::channel('pgs-app-status')->info('Uninstall PGS app from shopify store - '.$shop.' removing all sessions on : '.date("Y-m-d H:i:s"));
        $checkSession = Session::where('shop', $shop)->first();
        if(!empty($checkSession)){

            $shopName = $checkSession->shop;
            $shopAccessToken = $checkSession->access_token;
            $shopifyAuthSessionID = $checkSession->id;

            $storeData = [
                'shopify_store_name' => $shopName,
                'access_token' => $shopAccessToken,
                'session_id' => $checkSession->session_id
            ];

            $checkAppStatus = PgsAppStoreStatus::where('shopify_store_name', $shopName)->where('access_token', $shopAccessToken)->first();
            if(!empty($checkAppStatus)){
                $checkAppStatus->update($storeData);
            }else{
                PgsAppStoreStatus::create($storeData);
            }

            // delete shopify mandatory webhook request
            $mandatoryWebhookRequest = MandatoryShopifyWebhook::where('shop_domain', $shopName)->first();
            if(!empty($mandatoryWebhookRequest)){
                MandatoryShopifyWebhook::where('shop_domain', $shopName)->delete();
            }
            
            $userInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopifyAuthSessionID)->first();
            
            if(!empty($userInfo)){
                
                $pgsUserId = $userInfo->id;
                
                // delete PGS App Fonts
                PersonalisedGiftAppFont::where('personalised_gift_app_user_id', $pgsUserId)->delete();
    
                // delete PGS App Cliarts
                PersonalisedGiftAppClipart::where('personalised_gift_app_user_id', $pgsUserId)->delete();
    
                // delete shopify store metafields
                ShopifyMetafield::where('personalised_gift_app_user_id', $pgsUserId)->delete();

                // delete shopify hook orders
                HookOrder::where('shop_domain', $shopName)->delete();

                // delete shopify hook products
                DeletedHookProduct::where('shop_domain', $shopName)->delete();

                // delete shopify hook product inventory
                HookProductInventory::where('shop_domain', $shopName)->delete();

                // delete PGS user product ranges
                PersonalisedGiftAppUserProductRanges::where('personalised_gift_app_user_id', $pgsUserId)->delete();
    
                // delete shopify products
                $storeProducts = PersonalisedGiftAppProduct::where('personalised_gift_app_user_id', $pgsUserId)->get();
                if(!empty($storeProducts) && $storeProducts->count() > 0){
                    foreach($storeProducts as $storeProduct){
    
                        PersonalisedGiftAppProductMeta::where('personalised_gift_app_product_id', $storeProduct->id)->delete();
                        $storeProduct->delete();
                    }
                }
    
                // delete shopify collections
                $storeCollections = PersonalisedGiftAppCategory::where('personalised_gift_app_user_id', $pgsUserId)->get();
                if(!empty($storeCollections) && $storeCollections->count() > 0){
                    foreach($storeCollections as $storeCollection){
    
                        PersonalisedGiftAppCategoryProduct::where('personalised_gift_app_category_id', $storeCollection->id)->delete();
                        $storeCollection->delete();
                    }
                }
    
                // delete store webhooks
                ShopifyStoreWebhook::where('personalised_gift_app_user_id', $pgsUserId)->delete();
    
                // delete Shopify Order & Order Items
                $storeOrders = ShopifyStoreOrder::where('personalised_gift_app_user_id', $pgsUserId)->get();
                if(!empty($storeOrders) && $storeOrders->count() > 0){
    
                    Log::channel('pgs-app-status')->info('delete shopify orders for - '.$shop.' removing all sessions on : '.date("Y-m-d H:i:s"));
    
                    foreach($storeOrders as $storeOrder){
    
                        ShopifyStoreOrderItem::where('personalised_gift_app_user_id', $pgsUserId)->where('shopify_store_order_id', $storeOrder->id)->delete();
    
                        $storeOrder->delete();
                    }
                }
    
                // delete Shopify Customer
                ShopifyStoreCustomer::where('personalised_gift_app_user_id', $pgsUserId)->delete();
            }
            
            PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopifyAuthSessionID)->delete();

            $checkSession->delete();

        }
    }
}
