<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Lib\ProductCreator;
use CustomHelper,Log;
use App\Models\PersonalisedGiftAppProduct;
use App\Models\Job;

class AutomaticUpdateProductPriceJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $details;

    /**
     * The number of seconds the job can run before timing out.
     *
     * @var int
     */
    public $timeout = 1200;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($details)
    {
        //
        $this->details = $details;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $shopName = $this->details['shop_name'];
        $shopAccessToken = $this->details['access_token'];
        $rangeType = $this->details['range_type'];
        $marginPrice = $this->details['margin_price'];
        $deductPrice = $this->details['deduct_price'];
        $persolaisedProduct = $this->details['personalised_product_data'];
        $productId = $this->details['db_product_id'];
        
        if(!empty($this->job->getJobId())){
            $job = Job::find($this->job->getJobId());
            // Update the value of the new_field
            $job->shop_domain = $shopName;
            $job->save();
        }
        
        Log::channel('automatic-update-shopify-product-price')->info("AutomaticUpdateProductPriceJob Called for shop name - ".$shopName);

        $skuData = (!empty($persolaisedProduct->reseller_pricing)) ? json_decode($persolaisedProduct->reseller_pricing) : '';
        $productPrice = CustomHelper::getProductRegularPrice($skuData, $rangeType, $marginPrice, $deductPrice);
        
        CustomHelper::updateShopifyProductPrice($shopName, $shopAccessToken, $productId, $productPrice);  
        
        PersonalisedGiftAppProduct::where('id', $productId)->update(['is_update_product_price' => 0]);
        
        usleep(500000);

        Log::channel('automatic-update-shopify-product-price')->info("AutomaticUpdateProductPriceJob Stop for shop name - ".$shopName);
        return "Records Processed!";
    }
}
