<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Lib\ProductCreator;
use CustomHelper,Log;
use App\Models\PersonalisedGiftAppProduct;
use App\Models\Job;

class AutomaticUpdateProductArchivedStatusJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $details;

    /**
     * The number of seconds the job can run before timing out.
     *
     * @var int
     */
    public $timeout = 1200;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($details)
    {
        //
        $this->details = $details;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $dbProductId = $this->details['db_product_id'];
        $shopName = $this->details['shop_name'];
        $shopAccessToken = $this->details['access_token'];
        $updateStatus = $this->details['status'];
        
        if(!empty($this->job->getJobId())){
            $job = Job::find($this->job->getJobId());
            // Update the value of the new_field
            $job->shop_domain = $shopName;
            $job->save();
        }
        
        Log::channel('automatic-update-archived-product-status')->info("AutomaticUpdateProductArchivedStatusJob Called for shop name - ".$shopName);

        CustomHelper::updateShopifyProductStatusChange($shopName, $shopAccessToken, $dbProductId, $updateStatus);  

        usleep(500000);

        Log::channel('automatic-update-archived-product-status')->info("AutomaticUpdateProductArchivedStatusJob Stop for shop name - ".$shopName);
        return "Records Processed!";
    }
}
