<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use CustomHelper,Log;
use App\Models\PersonalisedGiftAppProduct;
use App\Models\PersonalisedGiftAppUser;
use App\Models\Job;

class AutomaticSyncPgsProductJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $details;

    /**
     * The number of seconds the job can run before timing out.
     *
     * @var int
     */
    public $timeout = 1200;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($details)
    {
        //
        $this->details = $details;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        Log::channel('check-cron-products')->info('Start cron job call start time: '.date("H:i:s"));
        
        $shopify_auth_session_id = $this->details['shopify_auth_session_id'];
        $shop_domain = $this->details['shop_domain'];
        $apikey = $this->details['apikey'];
        $username = $this->details['username'];
        $lastPage = $this->details['lastpage'];
        $syncingLimit = $this->details['sync_limit'];
        $totalpage = $this->details['totalpage'];
        $price_range_values = $this->details['price_range_values'];
        $sync_count =  $this->details['sync_count'];
        $total_sync_count =  $this->details['total_sync_count'];
        
        Log::channel('automatic-sync-pgs-product-job')->info("AutomaticSyncPgsProductJob Called for shop name - ".$shop_domain);
        
        if(!empty($this->job->getJobId())){
            
            $job = Job::find($this->job->getJobId());
            // Update the value of the new_field
            $job->shop_domain = $shop_domain;
            $job->save();
        }

        for ($i = $lastPage; $i <= $syncingLimit; $i++) {
            
            Log::channel('automatic-sync-pgs-product-job')->info("AutomaticSyncPgsProductJob page called limit - ".$i." and syncing limit - ".$syncingLimit." for shop name - ".$shop_domain);
             
            CustomHelper::storePgsProducts($i, $apikey, $username, $price_range_values);
            PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopify_auth_session_id)->update(['last_sync_page' => $i]);
        }
        
        CustomHelper::updateTotalSyncProductCount($shopify_auth_session_id);
        
        if($sync_count == $total_sync_count){
            CustomHelper::runShopifyPublishingProduct($shopify_auth_session_id);
        }
        
        Log::channel('check-cron-products')->info('End cron job call start time: '.date("H:i:s"));
        
        Log::channel('automatic-sync-pgs-product-job')->info("AutomaticSyncPgsProductJob Stop for shop name - ".$shop_domain);
    
        return "Records Processed!";
        
    }
}
