<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use CustomHelper,Log;
use App\Models\PersonalisedGiftAppProduct;
use App\Models\Job;

class AutomaticPublishShopifyProductJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $details;

    /**
     * The number of seconds the job can run before timing out.
     *
     * @var int
     */
    public $timeout = 1200;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($details)
    {
        //
        $this->details = $details;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $shopName = $this->details['shop_name'];
        $userId = $this->details['user_id'];
        $shopAccessToken = $this->details['access_token'];
        $shopifySalesChannelId = $this->details['sales_channel_id'];
        $shopifyLocationId = $this->details['shopify_location_id'];
        $shopifyAuthSessionId = $this->details['auth_session_id'];
        
        $rangeType = $this->details['range_type'];
        $marginPrice = $this->details['margin_price'];
        $deductPrice = $this->details['deduct_price'];
        $productId = $this->details['db_product_id'];
        $importCategoryStatus = $this->details['import_category_status'];
        $shopifyCollectionIds = [];
        
        Log::channel('automatic-publish-shopify-product-job')->info("AutomaticPublishShopifyProductJob Called for shop name - ".$shopName." and job id - ".$this->job->getJobId());
        
        Log::channel('automatic-publish-shopify-product-job')->info("Publish product id -".$productId." for shop name - ".$shopName);
        
        if(!empty($this->job->getJobId())){
            $job = Job::find($this->job->getJobId());
            // Update the value of the new_field
            $job->shop_domain = $shopName;
            $job->save();
        }
        
        if($importCategoryStatus == 1){
            // create category on the shopify store
            $shopifyCollectionIds = CustomHelper::createShopifyCollectionRequest($shopName, $shopAccessToken, $productId, $shopifySalesChannelId);  
        }

        // create product on the shopify store
        CustomHelper::createShopifyProductRequest($shopName, $shopAccessToken, $productId, $shopifyLocationId, $shopifySalesChannelId, $shopifyAuthSessionId, $shopifyCollectionIds, $rangeType, $marginPrice, $deductPrice, $importCategoryStatus, $userId); 

        Log::channel('automatic-publish-shopify-product-job')->info("AutomaticPublishShopifyProductJob Stop for shop name - ".$shopName);
        sleep(1);
        return "Records Processed!";
    }
    
}
