<?php

namespace App\Http\Helpers;

use Illuminate\Support\Facades\Log;
use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use CustomHelper;
use Carbon\Carbon;
use App\Models\PersonalisedGiftAppUser;
use App\Models\ShopifyStoreCustomer;
use App\Models\ShopifyStoreOrder;
use App\Models\ShopifyStoreOrderItem;
use App\Models\ShopifyStoreWebhook;
use App\Models\ShopifyMetafield;
use App\Models\PersonalisedGiftAppProduct;
use App\Models\PersonalisedGiftAppCategory;
use App\Models\PersonalisedGiftAppFont;
use App\Models\PersonalisedGiftAppClipart;
use App\Models\PersonalisedGiftAppCategoryProduct;
use App\Models\MandatoryShopifyWebhook;
use App\Traits\PersonalisedAppTrait;
use App\Lib\ProductCreator;
use App\Models\Session;
use App\Models\DeletedHookProduct;
use App\Models\HookOrder;
use App\Models\Job;
use App\Models\PersonalisedGiftAppProductMeta;
use App\Models\PersonalisedGiftAppUserProductRanges;
use App\Jobs\AutomaticUpdateProductPriceJob;
use App\Jobs\AutomaticPublishShopifyProductJob;
use App\Jobs\AutomaticSyncPgsProductJob;
use App\Jobs\AutomaticUpdateProductActiveStatusJob;
use App\Jobs\AutomaticUpdateProductArchivedStatusJob;

class CustomHelpers {

    use PersonalisedAppTrait;

    public static function storePgsProducts($page, $apikey, $username, $range_type)
    {
        $maxrrp = $_ENV['PERSONALISED_PRODUCT_MAX_RRP'];
        $pgs_third_party_product_api_url = $_ENV['PERSONALISED_GIFT_APP_PRODUCT_API_URL'];
        $pgs_product_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_product_api_url."all_products/?page=$page&size=10&range_type=$range_type&max_rrp=$maxrrp", "GET", $apikey, $username, "");

        $decodedPgsProducts = json_decode($pgs_product_response);

        $shopInfo = PersonalisedGiftAppUser::where('username', $username)->where('api_key', $apikey)->first();
        $shop_domain_name = NULL;
        $shop_db_id = NULL;
        $rangeType = $shopInfo->pricing_options;
        $marginPrice = $shopInfo->margin_change;
        $deductPrice = $shopInfo->deduct_price_change;

        if(!empty($shopInfo) && $shopInfo->personalised_app_user_status == 1){
            $shop_domain_name = (isset($shopInfo->session) && !empty($shopInfo->session)) ? $shopInfo->session->shop : NULL;
            $shop_db_id = $shopInfo->id;
        }
        
        Log::channel('store-pgs-products')->info("store product page start limit - ".$page." for store name - ".$shop_domain_name);

        if(!empty($decodedPgsProducts) && $decodedPgsProducts->statusCode == 200 && $decodedPgsProducts->success == 'true' && !empty($decodedPgsProducts->data)){

            $productData = $decodedPgsProducts->data->product;
            // store products data
            $store_pgs_product_data = CustomHelpers::createPgsProductData($productData, $shop_domain_name, $shop_db_id, $rangeType, $marginPrice, $deductPrice, $shopInfo->price_range_values);    
        }   

        return true;
        
    }

    public static function updateTotalSyncProductCount($shopify_auth_session_id)
    {
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopify_auth_session_id)->first();
        if(!empty($shopInfo)){
            $totalProduct = PersonalisedGiftAppProduct::where('personalised_gift_app_user_id', $shopInfo->id)->count();
            if(!empty($totalProduct)){
                $shopInfo->update(['total_sync_products' => $totalProduct]);
            }   
        }
        return $shopify_auth_session_id;
    }

    public static function UpdateShopifyFontClipartFile($shopify_auth_session_id, $type)
    {
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopify_auth_session_id)->first();
        if(!empty($shopInfo)){
            if($type == 'fonts'){
                $totalSendFont = PersonalisedGiftAppFont::where('personalised_gift_app_user_id', $shopInfo->id)->whereNotNull('shopify_file_id')->count();
                if(!empty($totalSendFont)){
                    $shopInfo->update(['total_send_shopify_files_pgs_fonts' => $totalSendFont]);
                }  
            }else{
                $totalSendClipart = PersonalisedGiftAppClipart::where('personalised_gift_app_user_id', $shopInfo->id)->whereNotNull('shopify_file_id')->count();
                if(!empty($totalSendClipart)){
                    $shopInfo->update(['total_send_shopify_files_pgs_cliparts' => $totalSendClipart]);
                }  
            }
        }
        return $shopify_auth_session_id;
    }

    public static function storePgsClipartData($apiKey, $username, $shopifyAuthSessionId)
    {
        $pgs_third_party_api_url = $_ENV['PERSONALISED_GIFT_APP_API_URL'];

        $clipart_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_api_url."content/clipart", "GET", $apiKey, $username, "");
        
        $pgsDecodedCliparts = json_decode($clipart_response);

        if(!empty($pgsDecodedCliparts) && $pgsDecodedCliparts->statusCode == 200 && $pgsDecodedCliparts->success == 'true' && !empty($pgsDecodedCliparts->data)){
            foreach($pgsDecodedCliparts->data as $clipart){

                $destinationPath = public_path('/pgs-app/cliparts');
                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0777, true);
                }

                $clipImageName = NULL;
                if(!empty($clipart->image)){

                    $imageUrl = $clipart->image;
                    $parts = explode("/", $imageUrl);
                    $clipImageName = end($parts);

                    $imageDestinationPath = public_path('/pgs-app/cliparts/'.$clipImageName);
                    if (!file_exists($imageDestinationPath)) {
                        copy($imageUrl, $imageDestinationPath); // copy original image
                    }						            
                }

                $saveClipartData = [
                    'personalised_gift_app_user_id' => $shopifyAuthSessionId,
                    'name' => $clipart->name,
                    'internal_name' => $clipart->internal_name,
                    'image_url' => $clipart->image,
                    'height' => $clipart->height,
                    'width' => $clipart->width,
                    'store_image_name' => $clipImageName
                ];

                PersonalisedGiftAppClipart::updateOrCreate(['personalised_gift_app_user_id' => $shopifyAuthSessionId, 'name' => $clipart->name, 'internal_name' => $clipart->internal_name, 'height' => $clipart->height, 'width' => $clipart->width], $saveClipartData);
            }
        }
        return true;
    }

    public static function storePgsFontData($apiKey, $username, $pgsUserId)
    {
        $pgs_third_party_api_url = $_ENV['PERSONALISED_GIFT_APP_API_URL'];
        $pgs_font_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_api_url."content/fonts", "GET", $apiKey, $username, "");
        
        $pgsDecodedFonts = json_decode($pgs_font_response);
        if(!empty($pgsDecodedFonts) && $pgsDecodedFonts->statusCode == 200 && $pgsDecodedFonts->success == 'true' && !empty($pgsDecodedFonts->data)){
            
            if(!empty($pgsDecodedFonts->data->option_fonts)){

                $getFont = PersonalisedGiftAppFont::where('font_type', 'option_fonts')->first();
                if(empty($getFont)){
                    $optionFontDestinationPath = public_path('/pgs-app/option-fonts');
                    if (!file_exists($optionFontDestinationPath)) {
                        mkdir($optionFontDestinationPath, 0777, true);
                    }
                }

                foreach($pgsDecodedFonts->data->option_fonts as $option_font){

                    $replacableFont = str_replace(' ', '', $option_font->name_of_font);
                    
                    $checkPgsFont = PersonalisedGiftAppFont::where([
                        'personalised_gift_app_user_id' => $pgsUserId,
                        'name_of_font' => $replacableFont,
                        'font_file' => $option_font->font_file,
                        'font_type' => 'option_fonts',
                    ])->first();

                    $optionFontFileName = NULL;
                    if(empty($checkPgsFont)){
                        
                        if(!empty($option_font->font_file)){

                            $fontUrl = $option_font->font_file;

                            $checkUrlArray = get_headers($fontUrl);
                            $urlstring = $checkUrlArray[0];
                            if(strpos($urlstring,"200"))
                            {
                                $optfontparts = explode("/", $fontUrl);
                                $optionFontFileName = end($optfontparts); // Replace with the name you want to give the font file

                                // Download the font file from the URL
                                $optFontData = file_get_contents($fontUrl);

                                // Save the font file to your local server folder
                                $optDestinationPath = public_path('/pgs-app/option-fonts/'.$optionFontFileName);
                                if (!file_exists($optDestinationPath)) {
                                    file_put_contents($optDestinationPath, $optFontData);
                                }	
                            }					            
                        }

                        $saveOptionFontData = [
                            'personalised_gift_app_user_id' => $pgsUserId,
                            'name_of_font' => $replacableFont,
                            'font_file' => $option_font->font_file,
                            'font_type' => 'option_fonts',
                            'store_font_file_name' => $optionFontFileName,
                        ];

                        PersonalisedGiftAppFont::updateOrCreate(['personalised_gift_app_user_id' => $pgsUserId, 'name_of_font' => $replacableFont, 'font_file' => $option_font->font_file, 'font_type' => 'option_fonts'], $saveOptionFontData);

                    }
                }
            }

            if(!empty($pgsDecodedFonts->data->user_fonts)){

                $getUserFont = PersonalisedGiftAppFont::where('font_type', 'user_fonts')->first();
                if(empty($getUserFont)){
                    $userFontDestinationPath = public_path('/pgs-app/user-fonts');
                    if (!file_exists($userFontDestinationPath)) {
                        mkdir($userFontDestinationPath, 0777, true);
                    }
                }

                foreach($pgsDecodedFonts->data->user_fonts as $user_font){

                    $replacableUserFont = str_replace(' ', '', $user_font->name_of_font);
                    
                    $checkPgsFont = PersonalisedGiftAppFont::where([
                        'personalised_gift_app_user_id' => $pgsUserId,
                        'name_of_font' => $replacableFont,
                        'font_file' => $user_font->font_file,
                        'font_type' => 'user_fonts',
                    ])->first();

                    $userFontFileName = NULL;
                    if(empty($checkPgsFont)){
                        
                        if(!empty($user_font->font_file)){

                            $userFontUrl = $user_font->font_file;

                            $checkUrlArray = get_headers($userFontUrl);
                            $urlstring = $checkUrlArray[0];
                            if(strpos($urlstring,"200"))
                            {
                                $userfontparts = explode("/", $userFontUrl);
                                $userFontFileName = end($userfontparts);

                                // Download the font file from the URL
                                $userFontData = file_get_contents($fontUrl);

                                // Save the font file to your local server folder
                                $userDestinationPath = public_path('/pgs-app/user-fonts/'.$userFontFileName);
                                if (!file_exists($userDestinationPath)) {
                                    file_put_contents($userDestinationPath, $userFontData);
                                }		
                            }                                            				            
                        }

                        $saveUserFontData = [
                            'personalised_gift_app_user_id' => $pgsUserId,
                            'name_of_font' => $replacableUserFont,
                            'font_file' => $user_font->font_file,
                            'font_type' => 'user_fonts',
                            'store_font_file_name' => $userFontFileName,
                        ];

                        PersonalisedGiftAppFont::updateOrCreate(['personalised_gift_app_user_id' => $pgsUserId, 'name_of_font' => $replacableUserFont, 'font_file' => $user_font->font_file, 'font_type' => 'user_fonts'], $saveUserFontData);

                    }
                }
            }
        }

        return true;
    }

    public static function createGraphqlShopiyStoreHooks($shopName, $shopAccessToken, $webhookUrl, $webhook_topic, $shopifyAuthSessionId)
    {        
        $webhookData = [
            "topic" => $webhook_topic,
            "webhookSubscription" => [
                "callbackUrl" => $webhookUrl,
                "format" => "JSON"
            ]
        ];

        $webhookResponse = ProductCreator::createShopifyStoreWebhooks($shopName, $shopAccessToken, $webhookData);
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopifyAuthSessionId)->first();
        
        if(!empty($webhookResponse->data)){
            $webhookResponse = $webhookResponse->data->webhookSubscriptionCreate->webhookSubscription;
            $storeData = [
                'personalised_gift_app_user_id' => (!empty($shopInfo)) ? $shopInfo->id: NULL,
                'webhook_id' => $webhookResponse->id,
                'format' => $webhookResponse->format,
                'topic' => $webhookResponse->topic,
            ];

            ShopifyStoreWebhook::create($storeData);
        }

        return true;
    }

    public static function createRestShopiyStoreHooks($SHOPIFY_WEBHOOK_API, $webhookUrl, $webhook_topic, $pgsUserId, $shopAccessToken)
    {
        $webhookData = [
            'webhook' => [
                'address' => $webhookUrl,
                'topic' => $webhook_topic,
                'format' => 'json'
            ]
        ];

        Log::channel('shopify-orders')->info('Webhook Request Data - '.json_encode($webhookData).' for user ID - '.$pgsUserId);

        $webhook_response = PersonalisedAppTrait::callCurlShopifyRestAPI($SHOPIFY_WEBHOOK_API, "POST", $webhookData, $shopAccessToken);
        $decoded_webhook_response = json_decode($webhook_response);

        Log::channel('shopify-orders')->info('Webhook Response Data - '.json_encode($decoded_webhook_response).' for user ID - '.$pgsUserId);
        
        if(isset($decoded_webhook_response->webhook) && !empty($decoded_webhook_response->webhook)){
            
            $webhookResponse = $decoded_webhook_response->webhook;
            $storeData = [
                'personalised_gift_app_user_id' => $pgsUserId,
                'webhook_id' => $webhookResponse->id,
                'format' => $webhookResponse->format,
                'topic' => $webhookResponse->topic,
                'api_version' => $webhookResponse->api_version,
                'address' => $webhookResponse->address,
            ];

            ShopifyStoreWebhook::create($storeData);

        }

        return true;
    }

    public static function createShopifyStoreLocation($shopName, $shopAccessToken, $shopId)
    {
        // create location on the shopify store
        $sendLocationdata = [
            'name' => 'Personalised Gift App',
            'fulfillsOnlineOrders' => true,
            'address' => [
                'address1' => 'CNC Group Ltd, 6 Barnes Close',
                'address2' => 'Brandon',
                'city' => 'England',
                'countryCode' => 'US',
                'phone' => '+44 800 069 9414',
                'provinceCode' => 'NY',
                'zip' => 'IP27 0NY',
            ]
        ];

        Log::channel('shopify-product')->info("Create Location Request Data -".json_encode($sendLocationdata));

        $locationResponse = ProductCreator::createStoreLocation($shopName, $shopAccessToken, $sendLocationdata);

        Log::channel('shopify-product')->info("Create Location Response Data -".json_encode($locationResponse));

        if(!empty($locationResponse)){
            if(!empty($locationResponse->data)){
                $shopifyGraphQlLocationId = $locationResponse->data->locationAdd->location->id;
            }

            PersonalisedGiftAppUser::where('id', $shopId)->update(['store_location_id' => $shopifyGraphQlLocationId]);
        }  
        return true;
    }

    public static function createShopifyStoreFulfillmentService($shopName, $shopAccessToken, $shopId)
    {
        // create location on the shopify store
        $serviceName = 'Personalised Gift App Fulfillment Service';
        $callbackUrl = url('order-fullfillment-request');
        $SHOPIFY_VERSION = $_ENV['SHOPIFY_VERSION'];
        $fulfillmentServiceData = [
                            "fulfillment_service" => [
                                "name" => $serviceName,
                                "callback_url" => $callbackUrl,
                                "inventory_management" => true,
                                "tracking_support" => true,
                                "requires_shipping_method" => true,
                                "permits_sku_sharing" => true,
                                "fulfillment_orders_opt_in" => true,
                                "format" => "json"
                            ]
                        ];

        $SHOPIFY_FULFILLMENT_SERVICE_API = "https://$shopName/admin/api/$SHOPIFY_VERSION/fulfillment_services.json";
                   
        $service_response = PersonalisedAppTrait::callCurlShopifyRestAPI($SHOPIFY_FULFILLMENT_SERVICE_API, "POST", $fulfillmentServiceData, $shopAccessToken);

        $serviceResponse = json_decode($service_response);

        /* $serviceResponse = ProductCreator::fulfillmentServiceCreate($shopName, $shopAccessToken, $serviceName, $callbackUrl); */

        Log::channel('shopify-fulfillment-service')->info("Create Fulfillment Service Request Data -".json_encode($fulfillmentServiceData));

        if(!empty($serviceResponse)){
            /* if(!empty($serviceResponse->data->fulfillmentServiceCreate)){
                $shopifyGraphQlServiceLocationId = $serviceResponse->data->fulfillmentServiceCreate->fulfillmentService->id;

                $explodelodeId = explode("?", $shopifyGraphQlServiceLocationId);
                $fulfillmentServiceId = $explodelodeId[0];

                PersonalisedGiftAppUser::where('id', $shopId)->update(['store_location_id' => $fulfillmentServiceId, 'fulfillment_service_response' => json_encode($serviceResponse->data->fulfillmentServiceCreate->fulfillmentService)]);
            } */

            if (!empty($serviceResponse) && !empty($serviceResponse->errors)) {

                Log::channel('shopify-fulfillment-service')->info("Create Fulfillment Service Error Response Data -".json_encode($serviceResponse->errors));

            } else {

                Log::channel('shopify-fulfillment-service')->info("Create Fulfillment Service Response Data -".json_encode($serviceResponse));

                $store_shopify_fulfillment_service_data = $serviceResponse->fulfillment_service;
                if(!empty($store_shopify_fulfillment_service_data)){

                    $serviceLocationId = "gid://shopify/Location/".$store_shopify_fulfillment_service_data->location_id;

                    PersonalisedGiftAppUser::where('id', $shopId)->update(['store_location_id' => $serviceLocationId, 'fulfillment_service_response' => json_encode($store_shopify_fulfillment_service_data)]);
                }
            }
        }  
        return true;
    }

    public static function createShopStoreMetafields($shopify_auth_token)
    {
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_token', $shopify_auth_token)->first();
        if(!empty($shopInfo)){

            $shopName = $shopInfo->session->shop;
            $shopAccessToken = $shopInfo->session->access_token;

            $shopifyStoreId = $shopInfo->shopify_store_id;

            $pgsFonts = PersonalisedGiftAppFont::where('personalised_gift_app_user_id', $shopInfo->id)->where('font_type', '!=', 'global_fonts')->orderBy('name_of_font', 'asc')->get();
            $pgsCliparts = PersonalisedGiftAppClipart::where('personalised_gift_app_user_id', $shopInfo->id)->orderBy('name', 'asc')->get();

            $clipartsArray = [];
            $fontsArray = [];
            if(!empty($pgsFonts) && $pgsFonts->count() > 0){
                foreach($pgsFonts as $key => $pgsFont){

                    $fontsArray[$key]['name_of_font'] = $pgsFont->name_of_font;
                    if($pgsFont->font_type == 'global_fonts'){
                        $fontsArray[$key]['font_file'] = $pgsFont->font_file;
                    }else{
                        $fontType = str_replace("_", "-", $pgsFont->font_type);
                        $fontsArray[$key]['font_file'] = $_ENV['APP_URL'].''.$fontType.'/'.$pgsFont->store_font_file_name;
                    }          
                    $fontsArray[$key]['font_type'] = $pgsFont->font_type;
                }
            }

            if(!empty($pgsCliparts) && $pgsCliparts->count() > 0){
                foreach($pgsCliparts as $key => $pgsClipart){
                    $clipartsArray[$key]['name'] = $pgsClipart->name;
                    $clipartsArray[$key]['internal_name'] = $pgsClipart->internal_name;
                    $clipartsArray[$key]['image_url'] = $_ENV['APP_URL'].'cliparts/'.$pgsClipart->store_image_name;
                    $clipartsArray[$key]['height'] = $pgsClipart->height;
                    $clipartsArray[$key]['width'] = $pgsClipart->width;
                }
            }

            $jsonFontData = [
                'data' => $fontsArray
            ];

            $jsonClipartData = [
                'data' => $clipartsArray
            ];

            // update metafields for shopify shop
            $sendShopMetafields = [
                [
                    'key' => 'personalisedGiftAppFonts',
                    'namespace' => 'custom',
                    'type' => 'json',
                    'value' => json_encode($jsonFontData),
                    'ownerId' => $shopifyStoreId,
                ],
                [
                    'key' => 'personalisedGiftAppCliparts',
                    'namespace' => 'custom',
                    'type' => 'json',
                    'value' => json_encode($jsonClipartData),
                    'ownerId' => $shopifyStoreId,
                ],
            ];

            $shopMetafieldResponse = ProductCreator::updateShopMetafields($shopName, $shopAccessToken, $sendShopMetafields);

            if(!empty($shopMetafieldResponse)){
                if(!empty($shopMetafieldResponse->data->metafieldsSet->metafields)){

                    foreach($shopMetafieldResponse->data->metafieldsSet->metafields as $metafield){

                        $checkMetafields = ShopifyMetafield::where([
                            'personalised_gift_app_user_id' => $shopInfo->id,
                            'resource_id' => $shopInfo->id,
                            'resource_type' => 'store',
                            'metafield_key' => $metafield->key,
                            'metafield_namespace' => $metafield->namespace,
                            'metafield_id' => $metafield->id,
                            'metafield_type' => $metafield->type,
                            'owner_id' => $shopifyStoreId,
                        ])->first();

                        $updateData = [
                            'personalised_gift_app_user_id' => $shopInfo->id,
                            'resource_id' => $shopInfo->id,
                            'resource_type' => 'store',
                            'metafield_id' => $metafield->id,
                            'metafield_key' => $metafield->key,
                            'metafield_namespace' => $metafield->namespace,
                            'metafield_type' => $metafield->type,
                            'metafield_value' => $metafield->value,
                            'owner_id' => $shopifyStoreId,
                        ];

                        if(empty($checkMetafields)){
                            ShopifyMetafield::create($updateData);
                        }else{
                            $checkMetafields->update($updateData);
                        }
                    }
                }
            } // create shopify metafields data
        }
        return true;
    }

    public static function deleteShopifyMetafield($metafieldId, $shopify_auth_token)
    {
        $metafieldResponse = '';
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_token', $shopify_auth_token)->first();
        if(!empty($shopInfo)){
            
            $shopName = $shopInfo->session->shop;
            $shopAccessToken = $shopInfo->session->access_token;

            $shopifyGraphQlMetafieldId = [
                'id' => $metafieldId
            ];
            
            $metafieldResponse = ProductCreator::callDeleteMetafield($shopName, $shopAccessToken, $shopifyGraphQlMetafieldId);
        }   
        return $metafieldResponse;     
    }

    public static function deleteShopifyWebhooks($webhookId, $shopify_auth_token)
    {
        $webhookInfo = '';
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_token', $shopify_auth_token)->first();
        if(!empty($shopInfo)){
   
            $shopName = $shopInfo->session->shop;
            $shopAccessToken = $shopInfo->session->access_token;

            $shopifyGraphQlWebhookId = [
                'id' => $webhookId
            ];

            $webhookInfo = ProductCreator::callDeleteShopifyWebhook($shopName, $shopAccessToken, $shopifyGraphQlWebhookId);
        }
        return $webhookInfo;
    }

    public static function updateProductAndCollectionOnSalesChannel($shopName, $shopAccessToken, $shopifySalesChannelId, $shopifyGraphQlId)
    {
        // update product on the sale channels
        if(!empty($shopifySalesChannelId)){
                            
            $sendChannelsData = [
                "publicationId" => $shopifySalesChannelId,
            ];

            Log::channel('shopify-product')->info("Update Product on Sales Channels Request Data -".json_encode($sendChannelsData));

            $sendChannelsDataResponse = ProductCreator::callPublishProductSalesChanel($shopName, $shopAccessToken, $sendChannelsData, $shopifyGraphQlId);

            Log::channel('shopify-product')->info("Update Product on Sales Channels Response Data -".json_encode($sendChannelsDataResponse));
        }
        return true;
    }

    public static function createShopifyCollectionRequest($shopName, $shopAccessToken, $productId, $shopifySalesChannelId)
    {
        Log::channel('shopify-category')->info("check shopify category request called");
        
        $shopifyCollectionIds = [];
        $productCategory = PersonalisedGiftAppCategoryProduct::where('personalised_gift_app_product_id', $productId)->get();
        if(!empty($productCategory) && $productCategory->count() > 0){
            foreach($productCategory as $category){
    
                if(isset($category->personalisedGiftAppCategory) && !empty($category->personalisedGiftAppCategory)){

                    $categoryTitle = $category->personalisedGiftAppCategory->name;
                    $categoryHandle = $category->personalisedGiftAppCategory->slug;
                    $shopifyDbCollectionId = $category->personalisedGiftAppCategory->shopify_collection_id;
                    
                    $shopifyGraphQlCategoryId = '';
                    
                    Log::channel('shopify-category')->info("check shopify category collection info for category name - ".$categoryTitle);
                    
                    if(empty($shopifyDbCollectionId)){
                        
                        Log::channel('shopify-category')->info("create shopify category collection info for category name - ".$categoryTitle);
                        
                        $query = "title:'$categoryTitle' AND handle:'$categoryHandle'";
                        $checkCategoryResponse = ProductCreator::checkShopifyStoreExistCollection($shopName, $shopAccessToken, $query);
                        
                        Log::channel('shopify-category')->info("get Shopify Category Response Data -".json_encode($checkCategoryResponse));
                        
                        $collectionid = '';
                        $collectionHandle = '';
                        if(!empty($checkCategoryResponse->data->collections->edges)){
                            $collectionid = $checkCategoryResponse->data->collections->edges[0]->node->id;
                            $collectionHandle = $checkCategoryResponse->data->collections->edges[0]->node->handle;
                        }
                        
                        if(empty($collectionid)){
    
                            $sendCategoryData = [
                                'title' => $categoryTitle,
                                'descriptionHtml' => $category->personalisedGiftAppCategory->description,
                                'handle' => $categoryHandle,
                            ];
    
                            $categoryImageUrl = trim($category->personalisedGiftAppCategory->background_image);
                            
                            Log::channel('shopify-category')->info("Category image url -".$categoryImageUrl." for category name - ".$categoryTitle);
                            
                            if(!empty($categoryImageUrl)){
                                
                                $validCategoryImageUrl = CustomHelpers::isImageLinkValid($categoryImageUrl);
                                
                                if ($validCategoryImageUrl) {
                                    $sendCategoryData['image'] = [
                                        'src' => $categoryImageUrl,
                                        'altText' => $categoryTitle,
                                    ];
                                }
                            }
    
                            Log::channel('shopify-category')->info("Create Category Request Data -".json_encode($sendCategoryData));
    
                            $categoryResponse = ProductCreator::callCreateCustomCategory($shopName, $shopAccessToken, $sendCategoryData);
    
                            Log::channel('shopify-category')->info("Create Category Response Data -".json_encode($categoryResponse));
    
                            if(!empty($categoryResponse)){
    
                                if(!empty($categoryResponse->data->collectionCreate->collection->id)){
                                    $shopifyGraphQlCategoryId = $categoryResponse->data->collectionCreate->collection->id;
                                    $shopifyCategoryHandle = $categoryResponse->data->collectionCreate->collection->handle;
                                    
                                    // update product on the sale channels
                                    if(!empty($shopifySalesChannelId)){
                                        CustomHelpers::updateProductAndCollectionOnSalesChannel($shopName, $shopAccessToken, $shopifySalesChannelId, $shopifyGraphQlCategoryId);    
                                    }
                                }
                            } 
    
                        }else {
                            $shopifyGraphQlCategoryId = $collectionid;
                            $shopifyCategoryHandle = $collectionHandle;
                        }   
                        
                    }else{
                        Log::channel('shopify-category')->info("update shopify category collection info for category name - ".$categoryTitle);
                        $shopifyGraphQlCategoryId = $category->personalisedGiftAppCategory->shopify_graph_ql_id;
                        $shopifyCategoryHandle = $categoryHandle;
                    }
                    
                    if(!empty($shopifyGraphQlCategoryId)){
                        
                        $shopifyCategoryId = str_replace("gid://shopify/Collection/","", $shopifyGraphQlCategoryId);
                        PersonalisedGiftAppCategory::where('id', $category->personalisedGiftAppCategory->id)->update(['shopify_collection_id' => $shopifyCategoryId, 'shopify_graph_ql_id' => $shopifyGraphQlCategoryId, 'shopify_category_handle' => $shopifyCategoryHandle]);
                    
                    }
                    
                }

                $categoryInfo = PersonalisedGiftAppCategory::select('shopify_graph_ql_id')->where('id', $category->personalised_gift_app_category_id)->first();
                if(!empty($categoryInfo)){
                    $shopifyCollectionIds[] = $categoryInfo->shopify_graph_ql_id;
                }
            }
        }

        return $shopifyCollectionIds;
    }
    
    public static function isImageLinkValid($imageUrl) {
        // Initialize cURL session
        $ch = curl_init($imageUrl);
    
        // Set cURL options
        curl_setopt($ch, CURLOPT_NOBODY, true); // Do a HEAD request to get only headers, not the whole content
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects if any
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return transfer as a string
    
        // Execute cURL session
        curl_exec($ch);
    
        // Check for cURL errors and HTTP status code
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curlError = curl_error($ch);
    
        // Close cURL session
        curl_close($ch);
    
        // Check if the request was successful and the status code is 200
        if (!$curlError && $httpCode == 200) {
            return true; // Image link is valid
        }
    
        return false; // Image link is not valid
    }

    public static function createShopifyProductRequest($shopName, $shopAccessToken, $persolaisedProductId, $shopifyLocationId, $shopifySalesChannelId, $shopifyAuthSessionId, $shopifyPCollectionIds, $rangeType, $marginPrice, $deductPrice, $importCategoryStatus, $userId)
    {     
        $checkPersonalisedProduct = PersonalisedGiftAppProduct::where('id', $persolaisedProductId)->where('personalised_gift_app_user_id', $userId)->whereNull('shopify_product_id')->where('is_publish_shopify_product', 0)->first();
        if(!empty($checkPersonalisedProduct)){
            
            $productTitle = $checkPersonalisedProduct->post_title;
            $pgs_image_url = $_ENV['EXTRA_PGS_IMAGET_SITE_URL'];
            $first_sku_pgs_image_url = $_ENV['PERSONALISED_GIFT_APP_FIRST_SKU_IMAGE_URL'];

            // create products on the shopify store
            $productSku = '';
            $productPrice = 0.00;
            $inventoryQty = 0;
            $pgsProductPrice = 0.00;
            
            $skuData = (!empty($checkPersonalisedProduct->reseller_pricing)) ? json_decode($checkPersonalisedProduct->reseller_pricing) : '';
            if(isset($checkPersonalisedProduct->personalisedGiftAppProductMeta) && !empty($checkPersonalisedProduct->personalisedGiftAppProductMeta)){
                
                $productSku = trim($checkPersonalisedProduct->personalisedGiftAppProductMeta->bigcommerce_sku);

                $pgsProductPrice = $checkPersonalisedProduct->personalisedGiftAppProductMeta->pgs_product_price;
                
                // $productPrice = $checkPersonalisedProduct->personalisedGiftAppProductMeta->product_rrp_price;
                
                $productPrice = CustomHelper::getProductRegularPrice($skuData, $rangeType, $marginPrice, $deductPrice);
                
                $inventoryQty = $checkPersonalisedProduct->personalisedGiftAppProductMeta->product_quantity;
            }
            
            if($productPrice > 0){

                $first_image_external_link = $first_sku_pgs_image_url."".$productSku.".jpg";
        
                $sendProductArray = [
                    'title' => $productTitle,
                    'descriptionHtml' => $checkPersonalisedProduct->post_content,
                    'variants' => [
                        [
                            'price' => number_format($productPrice, 2),
                            'sku' => $productSku,
                            'inventoryManagement' => 'SHOPIFY',
                            'inventoryPolicy' => 'DENY',
                            'inventoryQuantities' => [
                                'availableQuantity' => (int) $inventoryQty,
                                'locationId' => $shopifyLocationId
                            ]
                        ]
                    ],
                    'metafields' => [
                        [
                            'key' => 'customiserData',
                            'namespace' => 'custom',
                            'type' => 'json',
                            'value' => $checkPersonalisedProduct->customiser_data,
                        ],
                        [
                            'key' => 'resellerPricing',
                            'namespace' => 'custom',
                            'type' => 'json',
                            'value' => $checkPersonalisedProduct->reseller_pricing,
                        ],
                    ]
                ];
        
                if(!empty($checkPersonalisedProduct->customiser_data)){
                    $sendProductArray['tags'] = ['Personalised'];
                }
                
                if(!empty($checkPersonalisedProduct->shopify_category_taxonomy_id) && $importCategoryStatus == 1){
                    $sendProductArray['productCategory']['productTaxonomyNodeId'] = "gid://shopify/ProductTaxonomyNode/".$checkPersonalisedProduct->shopify_category_taxonomy_id;
                }
        
                $imagesArray = [];
                $checkImage = CustomHelpers::isImageLinkValid($first_image_external_link);
            
                if($checkImage){
                    $imagesArray[] = $first_image_external_link;
                    Log::channel('shopify-product')->info("Check Image url is valid for product id -".$checkPersonalisedProduct->id." and images - ".$first_image_external_link);
                }else{
                    Log::channel('shopify-product')->info("Check Image url is not valid for product id -".$checkPersonalisedProduct->id." and images - ".$first_image_external_link);
                }
                
                if(!empty($checkPersonalisedProduct->extra_images)){
                    $explodeImages = explode(",", $checkPersonalisedProduct->extra_images);
                    if(!empty($explodeImages) && count($explodeImages) > 0){
                        foreach($explodeImages as $image){
                            $imagesArray[] = $pgs_image_url.''.$image;
                        }
                    }
        
                    /* $explodeAtpImages = explode(",", $checkPersonalisedProduct->atp_images);
                    if(!empty($explodeAtpImages) && count($explodeAtpImages) > 0){
                        foreach($explodeAtpImages as $explodeAtpImage){
                            array_push($imagesArray,$pgs_image_url.''.$explodeAtpImage);
                        }
                    } */
                }
                
                /* if($checkImage){
                    array_push($imagesArray, $first_image_external_link);
                } */
        
                // array_push($imagesArray, $checkPersonalisedProduct->thumbnail_image); // old code
        
                $sendShopifyImageAray = [];
                if(!empty($imagesArray) && count($imagesArray) > 0){
                    foreach($imagesArray as $key => $imgrecord){
                        $sendShopifyImageAray[$key]['src'] = $imgrecord;
                        $sendShopifyImageAray[$key]['altText'] = $productTitle." Image ".$key+1;
                    }
                }
        
                if(!empty($sendShopifyImageAray)){
                    $sendProductArray['images'] = $sendShopifyImageAray;
                }
        
                if(!empty($shopifyPCollectionIds)){
                    $sendProductArray['collectionsToJoin'] = $shopifyPCollectionIds;
                }
                
                $queryString = "sku:'$productSku'";
                $checkProductResponse = ProductCreator::checkShopifyStoreExistProduct($shopName, $shopAccessToken, $queryString);
        
                $shopifyProductd = '';
                if(!empty($checkProductResponse->data->products->edges)){
                    $shopifyProductd = $checkProductResponse->data->products->edges[0]->node->id;
                }
        
                if(empty($shopifyProductd)){
        
                    Log::channel('shopify-product')->info("Create Product Request Data -".json_encode($sendProductArray));
                    $productResponse = ProductCreator::callCreateCustomProducts($shopName, $shopAccessToken, $sendProductArray);
                    $proType = 'productCreate';
                }else{
        
                    $sendProductArray['id'] = $shopifyProductd;
                    Log::channel('shopify-product')->info("Update Product Request Data -".json_encode($sendProductArray));
                    $productResponse = ProductCreator::callUpdateCustomProducts($shopName, $shopAccessToken, $sendProductArray);
                    $proType = 'productUpdate';
                }            
        
                Log::channel('shopify-product')->info("Create Product Response Data -".json_encode($productResponse));
        
                if(!empty($productResponse)){
        
                    $shopifyVariantId = NULL;
                    $inventoryItemId = NULL;
                    if(!empty($productResponse->data->$proType->product)){
                        
                        $shopifyGraphQlProductId = $productResponse->data->$proType->product->id;
                        $shopifyProductHandle = $productResponse->data->$proType->product->handle;
                        $shopifyProductStatus = $productResponse->data->$proType->product->status;
                        $shopifyProductId = str_replace("gid://shopify/Product/","", $shopifyGraphQlProductId);
        
                        if(!empty($productResponse->data->$proType->product->variants)){
                            $shopifyVariantId = $productResponse->data->$proType->product->variants->edges[0]->node->id;
                            $inventoryItemId = $productResponse->data->$proType->product->variants->edges[0]->node->inventoryItem->id;
                        }

                        // update inventory cost per item price
                        if(!empty($inventoryItemId)){

                            CustomHelpers::updateShopifyProductInventoryCostPrice($shopName, $shopAccessToken, $inventoryItemId, $productPrice, $persolaisedProductId);
                        }
        
                        // store metafields data
                        if(!empty($productResponse->data->$proType->product->metafields)){
        
                            foreach($productResponse->data->$proType->product->metafields->edges as $metafield){
        
                                $metaData = $metafield->node;
        
                                $checkProductMetafields = ShopifyMetafield::where([
                                    'personalised_gift_app_user_id' => $userId,
                                    'resource_id' => $checkPersonalisedProduct->id,
                                    'resource_type' => 'product',
                                    'metafield_key' => $metaData->key,
                                    'metafield_namespace' => $metaData->namespace,
                                    'metafield_id' => $metaData->id,
                                    'metafield_type' => $metaData->type,
                                    'owner_id' => $shopifyGraphQlProductId,
                                ])->first();
        
                                if(empty($checkProductMetafields)){
        
                                    $updateMetaData = [
                                        'personalised_gift_app_user_id' => $userId,
                                        'resource_id' => $checkPersonalisedProduct->id,
                                        'resource_type' => 'product',
                                        'metafield_id' => $metaData->id,
                                        'metafield_key' => $metaData->key,
                                        'metafield_namespace' => $metaData->namespace,
                                        'metafield_type' => $metaData->type,
                                        'metafield_value' => $metaData->value,
                                        'owner_id' => $shopifyGraphQlProductId,
                                    ];
        
                                    ShopifyMetafield::create($updateMetaData);
                                }
                            }
                        }

                        $shop_name = str_replace(".myshopify.com","", $checkPersonalisedProduct->shop_domain);
                        $edit_product_link = "https://admin.shopify.com/store/".$shop_name."/products/".$shopifyProductId;
                        $priview_link = "https://".$checkPersonalisedProduct->shop_domain."/products/".$shopifyProductHandle;
            
                        // update product on the sale channels
                        if(!empty($shopifySalesChannelId)){
                            CustomHelpers::updateProductAndCollectionOnSalesChannel($shopName, $shopAccessToken, $shopifySalesChannelId, $shopifyGraphQlProductId);    
                        }
            
                        $checkPersonalisedProduct->update(['shopify_product_id' => $shopifyProductId, 'shopify_graph_ql_id' => $shopifyGraphQlProductId,'shopify_product_handle' => $shopifyProductHandle, 'shopify_edit_product_link' => $edit_product_link, 'shopify_preview_product_link' => $priview_link, 'shopify_product_variant_id' => $shopifyVariantId, 'shopify_product_inventory_item_id' => $inventoryItemId, 'shopify_product_status' => $shopifyProductStatus, 'is_shopify_product' => 1, 'is_job_process' => 0]);

                    }
                }
            }
            
        }

        return true;
    }

    public static function createShopifyHookOrders($orderData, $shop_domain)
    {
        ini_set('memory_limit', -1);
		ini_set('max_execution_time', 30000);
        
        $isInsertOrderInDb = 0;
        $store_id = '';
        $nonPgsItemCount = 0;
	    if (!empty($orderData['line_items']) && count($orderData['line_items']) > 0) {
	      	foreach ($orderData['line_items'] as $key => $orderItem) {
		      	if(!empty($orderItem['product_id'])){
                    $productData = PersonalisedGiftAppProduct::where('shopify_product_id', $orderItem['product_id'])->first();
			        if (!empty($productData)) {
			            $isInsertOrderInDb = 1;
                        $store_id = $productData->personalised_gift_app_user_id;
			        }else{
                        $nonPgsItemCount++;
                    }
                }
	      	}
	    }

        $order_type = ($nonPgsItemCount > 0) ? 'shared_order' : 'pgs_order';
    
        if($isInsertOrderInDb == 1){

            if (!empty($orderData['customer'])) {

				Log::channel('parsing-orders')->info('Saving customer data in database');

				$checkCustomer = ShopifyStoreCustomer::where('customer_id', $orderData['customer']['id'])->first();
                
				$customerData = [
                    'personalised_gift_app_user_id' => $store_id,
					'customer_id' => $orderData['customer']['id'],
					'email' => (isset($orderData['customer']['email']) && !empty($orderData['customer']['email'])) ? $orderData['customer']['email'] : NULL,
					'accepts_marketing' => $orderData['customer']['accepts_marketing'],
					'customer_created_at' => $orderData['customer']['created_at'],
					'customer_updated_at' => $orderData['customer']['updated_at'],
					'first_name' => (isset($orderData['customer']['first_name']) && !empty($orderData['customer']['first_name'])) ? $orderData['customer']['first_name'] : NULL,
					'last_name' => (isset($orderData['customer']['last_name']) && !empty($orderData['customer']['last_name'])) ? $orderData['customer']['last_name'] : NULL,
					'state' => $orderData['customer']['state'],
					'note' => CustomHelper::remove_emoji($orderData['customer']['note']),
					'verified_email' => $orderData['customer']['verified_email'],
					'multipass_identifier' => $orderData['customer']['multipass_identifier'],
					'tax_exempt' => $orderData['customer']['tax_exempt'],
					'phone' => (isset($orderData['customer']['phone']) && !empty($orderData['customer']['phone'])) ? $orderData['customer']['phone'] : NULL,
					'tags' => $orderData['customer']['tags'],
					'currency' => $orderData['customer']['currency'],
					'accepts_marketing_updated_at' => $orderData['customer']['accepts_marketing_updated_at'],
					'marketing_opt_in_level' => (isset($orderData['customer']['marketing_opt_in_level']) && !empty($orderData['customer']['marketing_opt_in_level'])) ? $orderData['customer']['marketing_opt_in_level'] : '',
         		    'admin_graphql_api_id' => (isset($orderData['customer']['admin_graphql_api_id']) && !empty($orderData['customer']['admin_graphql_api_id'])) ? $orderData['customer']['admin_graphql_api_id'] : '',
					'marketing_opt_in_level' => $orderData['customer']['marketing_opt_in_level'],
					'admin_graphql_api_id' => $orderData['customer']['admin_graphql_api_id'],
					'default_address' => (isset($orderData['customer']['default_address']) && !empty($orderData['customer']['default_address'])) ? json_encode($orderData['customer']['default_address']) : '',
				];

				// Check if customer exist in database
				if (empty($checkCustomer)) {
					$checkCustomer = ShopifyStoreCustomer::create($customerData);
					Log::channel('parsing-orders')->info("Customer with email " . $orderData['customer']['id'] . " created in database");
				} else {
					$checkCustomer->update($customerData);
					Log::channel('parsing-orders')->info("Customer with email " . $orderData['customer']['id'] . " updated in database");
				}

				// Now we have customer ID
				$customerId = $checkCustomer->id;

				// Check if order is in database or not
				Log::channel('parsing-orders')->info('Saving order data in database');

				$checkOrder = ShopifyStoreOrder::where([
					'orderId' => $orderData['id'],
					'order_number' => $orderData['order_number']
				])->first();

				$delivery_date = '';
				if (!empty($orderData['note_attributes']) && $orderData['note_attributes'][0]['name'] == 'Delivery Date' && $orderData['note_attributes'][0]['value'] != '') {
					$delivery_date = date('Y-m-d', strtotime($orderData['note_attributes'][0]['value']));
				}

				$billing_phone = NULL;
		        if(isset($orderData['billing_address']['phone']) && !empty($orderData['billing_address']['phone'])){
		            $billing_phone = $orderData['billing_address']['phone'];
		        }

		        $shipping_phone = NULL;
		        if(isset($orderData['shipping_address']['phone']) && !empty($orderData['shipping_address']['phone'])){
		            $shipping_phone = $orderData['shipping_address']['phone'];
		        }

				$orderDetails = [
                    'personalised_gift_app_user_id' => $store_id,
                    'shopify_store_customer_id' => $customerId,
					'shopify_customer_id' => $orderData['customer']['id'],
					'orderId' => $orderData['id'],
					'email' => (isset($orderData['email']) && !empty($orderData['email'])) ? $orderData['email'] : NULL,
					'order_closed_at' => $orderData['closed_at'],
					'order_created_at' => $orderData['created_at'],
					'order_updated_at' => $orderData['updated_at'],
					'number' => $orderData['number'],
					'note' => CustomHelper::remove_emoji($orderData['note']),
					'token' => $orderData['token'],
					'gateway' =>  (isset($orderData['gateway']) && !empty($orderData['gateway'])) ? $orderData['gateway'] : NULL,
					'test' => (isset($orderData['test']) && !empty($orderData['test'])) ? $orderData['test'] : NULL,
					'total_price' => (isset($orderData['total_price']) && !empty($orderData['total_price'])) ? $orderData['total_price'] : NULL,
					'subtotal_price' => (isset($orderData['subtotal_price']) && !empty($orderData['subtotal_price'])) ? $orderData['subtotal_price'] : NULL,
					'total_weight' => (isset($orderData['total_weight']) && !empty($orderData['total_weight'])) ? $orderData['total_weight'] : NULL,
					'total_tax' => (isset($orderData['total_tax']) && !empty($orderData['total_tax'])) ? $orderData['total_tax'] : NULL,
					'taxes_included' => (isset($orderData['taxes_included']) && !empty($orderData['taxes_included'])) ? $orderData['taxes_included'] : NULL,
					'currency' => (isset($orderData['currency']) && !empty($orderData['currency'])) ? $orderData['currency'] : NULL,
					'financial_status' => (isset($orderData['financial_status']) && !empty($orderData['financial_status'])) ? $orderData['financial_status'] : NULL,
					'confirmed' => (isset($orderData['confirmed']) && !empty($orderData['confirmed'])) ? $orderData['confirmed'] : NULL,
					'total_discounts' => (isset($orderData['total_discounts']) && !empty($orderData['total_discounts'])) ? $orderData['total_discounts'] : NULL,
					'total_line_items_price' => (isset($orderData['total_line_items_price']) && !empty($orderData['total_line_items_price'])) ? $orderData['total_line_items_price'] : NULL,
					'cart_token' => (isset($orderData['cart_token']) && !empty($orderData['cart_token'])) ? $orderData['cart_token'] : NULL,
					'buyer_accepts_marketing' => (isset($orderData['buyer_accepts_marketing']) && !empty($orderData['buyer_accepts_marketing'])) ? $orderData['buyer_accepts_marketing'] : NULL,
					'name' => (isset($orderData['name']) && !empty($orderData['name'])) ? $orderData['name'] : NULL,
					'referring_site' => (isset($orderData['referring_site']) && !empty($orderData['referring_site'])) ? $orderData['referring_site'] : NULL,
					'landing_site' => (isset($orderData['landing_site']) && !empty($orderData['landing_site'])) ? $orderData['landing_site'] : NULL,
					'cancelled_at' => (isset($orderData['cancelled_at']) && !empty($orderData['cancelled_at'])) ? $orderData['cancelled_at'] : NULL,
					'cancel_reason' => (isset($orderData['cancel_reason']) && !empty($orderData['cancel_reason'])) ? $orderData['cancel_reason'] : NULL,
					'checkout_token' => (isset($orderData['checkout_token']) && !empty($orderData['checkout_token'])) ? $orderData['checkout_token'] : NULL,
					'reference' => (isset($orderData['reference']) && !empty($orderData['reference'])) ? $orderData['reference'] : NULL,
					'user_id' => (isset($orderData['user_id']) && !empty($orderData['user_id'])) ? $orderData['user_id'] : NULL,
					'location_id' => (isset($orderData['location_id']) && !empty($orderData['location_id'])) ? $orderData['location_id'] : NULL,
					'source_identifier' => (isset($orderData['source_identifier']) && !empty($orderData['source_identifier'])) ? $orderData['source_identifier'] : NULL,
					'source_url' => (isset($orderData['source_url']) && !empty($orderData['source_url'])) ? $orderData['source_url'] : NULL,
					'processed_at' => (isset($orderData['processed_at']) && !empty($orderData['processed_at'])) ? $orderData['processed_at'] : NULL,
					'device_id' => (isset($orderData['device_id']) && !empty($orderData['device_id'])) ? $orderData['device_id'] : NULL,
					'phone' => (isset($orderData['phone']) && !empty($orderData['phone'])) ? $orderData['phone'] : NULL,
					'billing_phone' => $billing_phone,
          			'shipping_phone' => $shipping_phone,
					'customer_locale' => (isset($orderData['customer_locale']) && !empty($orderData['customer_locale'])) ? $orderData['customer_locale'] : NULL,
					'app_id' => (isset($orderData['app_id']) && !empty($orderData['app_id'])) ? $orderData['app_id'] : NULL,
					'browser_ip' => (isset($orderData['browser_ip']) && !empty($orderData['browser_ip'])) ? $orderData['browser_ip'] : NULL,
					'landing_site_ref' => (isset($orderData['landing_site_ref']) && !empty($orderData['landing_site_ref'])) ? $orderData['landing_site_ref'] : NULL,
					'order_number' => (isset($orderData['order_number']) && !empty($orderData['order_number'])) ? $orderData['order_number'] : NULL,
					'discount_applications' => (isset($orderData['discount_applications']) && !empty($orderData['discount_applications'])) ? json_encode($orderData['discount_applications']) : NULL,
					'discount_codes' => (isset($orderData['discount_codes']) && !empty($orderData['discount_codes'])) ? json_encode($orderData['discount_codes']) : NULL,
					'note_attributes' => (isset($orderData['note_attributes']) && !empty($orderData['note_attributes'])) ? json_encode($orderData['note_attributes']) : NULL,
					'payment_gateway_names' => (isset($orderData['payment_gateway_names']) && !empty($orderData['payment_gateway_names'])) ? json_encode($orderData['payment_gateway_names']) : NULL,
					'processing_method' => (isset($orderData['processing_method']) && !empty($orderData['processing_method'])) ? $orderData['processing_method'] : NULL,
					'checkout_id' => (isset($orderData['checkout_id']) && !empty($orderData['checkout_id'])) ? $orderData['checkout_id'] : NULL,
					'source_name' => (isset($orderData['source_name']) && !empty($orderData['source_name'])) ? $orderData['source_name'] : NULL,
					'fulfillment_status' => (isset($orderData['fulfillment_status']) && !empty($orderData['fulfillment_status'])) ? $orderData['fulfillment_status'] : NULL,
					'tax_lines' => (isset($orderData['tax_lines']) && !empty($orderData['tax_lines'])) ? json_encode($orderData['tax_lines']) : NULL,
					'tags' => (isset($orderData['tags']) && !empty($orderData['tags'])) ? $orderData['tags'] : NULL,
					'contact_email' => (isset($orderData['contact_email']) && !empty($orderData['contact_email'])) ? $orderData['contact_email'] : NULL,
					'order_status_url' => (isset($orderData['order_status_url']) && !empty($orderData['order_status_url'])) ? $orderData['order_status_url'] : NULL,
					'presentment_currency' => (isset($orderData['presentment_currency']) && !empty($orderData['presentment_currency'])) ? $orderData['presentment_currency'] : NULL,
					'total_line_items_price_set' => json_encode($orderData['total_line_items_price_set']),
					'total_discounts_set' => json_encode($orderData['total_discounts_set']),
					'total_shipping_price_set' => json_encode($orderData['total_shipping_price_set']),
					'subtotal_price_set' => json_encode($orderData['subtotal_price_set']),
					'total_price_set' => json_encode($orderData['total_price_set']),
					'total_tax_set' => json_encode($orderData['total_tax_set']),
					'line_items' => json_encode($orderData['line_items']),
					'fulfillments' => json_encode($orderData['fulfillments']),
					'refunds' => json_encode($orderData['refunds']),
					'total_tip_received' => (isset($orderData['total_tip_received']) && !empty($orderData['total_tip_received'])) ? $orderData['total_tip_received'] : NULL,
					'original_total_duties_set' => (isset($orderData['original_total_duties_set']) && !empty($orderData['original_total_duties_set'])) ? $orderData['original_total_duties_set'] : '',
		            'current_total_duties_set' => (isset($orderData['current_total_duties_set']) && !empty($orderData['current_total_duties_set'])) ? $orderData['current_total_duties_set'] : '',
		            'admin_graphql_api_id' => (isset($orderData['admin_graphql_api_id']) && !empty($orderData['admin_graphql_api_id'])) ? $orderData['admin_graphql_api_id'] : '',
					'shipping_lines' => json_encode($orderData['shipping_lines']),
					'billing_address' => (!empty($orderData['billing_address'])) ? json_encode($orderData['billing_address']) : '',
					'shipping_address' => (!empty($orderData['shipping_address'])) ? json_encode($orderData['shipping_address']) : '',
					'client_details' => (!empty($orderData['client_details'])) ? json_encode($orderData['client_details']) : '',
					'payment_details' => (!empty($orderData['payment_details'])) ? json_encode($orderData['payment_details']) : '',
					'delivery_date' => $delivery_date,
                    'is_pgs_order' => 1,
                    'order_type' => $order_type
				];

				if (empty($checkOrder)) {
					$checkOrder = ShopifyStoreOrder::create($orderDetails);
					Log::channel('parsing-orders')->info("Order Number #" . $orderData['number'] . " created in database");
				} else {
					$checkOrder->update($orderDetails);
					Log::channel('parsing-orders')->info("Order Number #" . $orderData['number'] . " updated in database");
				}

				// Now we have order ID
				$orderId = $checkOrder->id;
				$shopify_order_id = $checkOrder->orderId;
				$shopify_order_number = $checkOrder->order_number;

				// Loop through order items
				Log::channel('parsing-orders')->info("Loop through order items for Order Number #" . $orderData['number']);

				if (!empty($orderData['line_items']) && count($orderData['line_items']) > 0) {
					
					foreach ($orderData['line_items'] as $key => $orderItem) {

						$is_seller_excluded = 0;
						$productData = PersonalisedGiftAppProduct::where('shopify_product_id', $orderItem['product_id'])->first();

						if (!empty($productData)) {
							
                            // Check if we have order items for this order
                            $checkOrderItem = ShopifyStoreOrderItem::where([
                                'shopify_store_order_id' => $orderId,
                                'order_item_id' => $orderItem['id']
                            ])->first();

                            $orderItemData = [
                                'personalised_gift_app_user_id' => $store_id,
                                'shopify_store_order_id' => $orderId,
                                'shopify_order_id' => $shopify_order_id,
                                'order_item_id' => $orderItem['id'],
                                'variant_id' => $orderItem['variant_id'],
                                'title' => $orderItem['title'],
                                'quantity' => $orderItem['quantity'],
                                'sku' => $orderItem['sku'],
                                'variant_title' => $orderItem['variant_title'],
                                'vendor_name' => $orderItem['vendor'],
                                'product_id' => $orderItem['product_id'],
                                'requires_shipping' => $orderItem['requires_shipping'],
                                'taxable' => $orderItem['taxable'],
                                'gift_card' => $orderItem['gift_card'],
                                'name' => $orderItem['name'],
                                'variant_inventory_management' => $orderItem['variant_inventory_management'],
                                'properties' => (!empty($orderItem['properties'])) ? json_encode($orderItem['properties']) : '',
                                'product_exists' => $orderItem['product_exists'],
                                'fulfillable_quantity' => $orderItem['fulfillable_quantity'],
                                'grams' => $orderItem['grams'],
                                'price' => $orderItem['price'],
                                'total_discount' => $orderItem['total_discount'],
                                'fulfillment_status' => $orderItem['fulfillment_status'],
                                'price_set' => (!empty($orderItem['price_set'])) ? json_encode($orderItem['price_set']) : '',
                                'total_discount_set' => (!empty($orderItem['total_discount_set'])) ? json_encode($orderItem['total_discount_set']) : '',
                                'discount_allocations' => (!empty($orderItem['discount_allocations'])) ? json_encode($orderItem['discount_allocations']) : '',
                                'duties' => (!empty($orderItem['duties'])) ? json_encode($orderItem['duties']) : '',
                                'admin_graphql_api_id' => (isset($orderItem['admin_graphql_api_id']) && !empty($orderItem['admin_graphql_api_id'])) ? $orderItem['admin_graphql_api_id'] : '',
                                'tax_lines' => (!empty($orderItem['tax_lines'])) ? json_encode($orderItem['tax_lines']) : '',
                                'is_seller_excluded' => $is_seller_excluded,
                                'shopify_order_number' => $shopify_order_number,
                                'order_type' => $order_type
                            ];

                            if (empty($checkOrderItem)) {
                                $checkOrderItem = ShopifyStoreOrderItem::create($orderItemData);

                                Log::channel('parsing-orders')->info("Order Item ID " . $orderItem['id'] . " for Order Number #" . $orderData['number'] . " created in database");
                            
                            } else {
                                
                                $checkOrderItem->update($orderItemData);
                                Log::channel('parsing-orders')->info("Order Item ID " . $orderItem['id'] . " for Order Number #" . $orderData['number'] . " updated in database");
                            }

                            Log::channel('parsing-orders')->info("All order items are saved in database");

                            Log::channel('parsing-orders')->info("All data saved for Order Number #" . $orderData['number']);

                            Log::channel('parsing-orders')->info("#######################################################################");

						}
					}

					// save data into teh order table for speed increasing
				}
			}
        }
        return true;
    }

    public static function remove_emoji($string) {
	    return preg_replace('%(?:
	          \xF0[\x90-\xBF][\x80-\xBF]{2}      # planes 1-3
	        | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15
	        | \xF4[\x80-\x8F][\x80-\xBF]{2}      # plane 16
	    )%xs', '', $string); 
	}

    public static function createPgsThirdPartyOrder($orderData, $apikey, $username, $dbOrderItemId)
    {
        $pgs_third_party_api_url = $_ENV['PERSONALISED_GIFT_APP_API_URL'];
        Log::channel('pgs-orders')->info('Pgs order request data : '.json_encode($orderData).' for order item id - '.$dbOrderItemId);
        $order_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_api_url."order/create", "POST", $apikey, $username, $orderData);
        $orderResponseData = json_decode($order_response);
        
        Log::channel('pgs-orders')->info('Pgs order response : '.json_encode($order_response).' for order item id - '.$dbOrderItemId);
        
        if(!empty($orderResponseData->data)){
            
            $pgs_store_id = $orderResponseData->data->cnc_order_id;
            ShopifyStoreOrderItem::where('id', $dbOrderItemId)->update([
                'is_pgs_order_item' => 1,
                'is_pgs_store_order_id' => $pgs_store_id,
                'send_pgs_order_id' => $orderData['order_id'],
                'pgs_order_request' => json_encode($orderData),
                'pgs_order_response' => json_encode($orderResponseData->data),
            ]);
        }
        return true;
    }

    public static function checkPgsThirdPartyOrderStatus($pgsOrderIds, $apikey, $username)
    {
        $pgs_third_party_api_url = $_ENV['PERSONALISED_GIFT_APP_API_URL'];
        $order_status_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_api_url."order/status/?ids=".$pgsOrderIds, "GET", $apikey, $username, "");
        $orderStatusResponseData = json_decode($order_status_response);
        // dd($orderStatusResponseData);
        if(!empty($orderStatusResponseData->data)){
            foreach($orderStatusResponseData->data as $orderIdKey => $orderInfo){
                
                if(!empty($orderInfo)){
                    foreach($orderInfo as $item_id => $itemInfo){
                         
                        $checkShopifyOrderItem = ShopifyStoreOrderItem::where('id', $item_id)->where('send_pgs_order_id', $orderIdKey)->first();
                        if(!empty($checkShopifyOrderItem)){
                            $checkShopifyOrderItem->update([
                                'pgs_order_status' => isset($itemInfo->status) ? $itemInfo->status : NULL,
                                'pgs_order_tracking_id' => isset($itemInfo->tracking_id) ? $itemInfo->tracking_id : NULL,
                                'pgs_order_processed_time' => isset($itemInfo->processed_time) ? $itemInfo->processed_time : NULL,
                                'pgs_order_shipping_service' => isset($itemInfo->shipping_service) ? $itemInfo->shipping_service : NULL,
                            ]);
                        }
                    }  
                }
            }
        }
        return true;
    }

    public static function getOrderSettingData($shopifyAuthSessionId)
    {
        $orderSettingData = [];
        $userData = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopifyAuthSessionId)->first();
        if(!empty($userData)){
            $orderSettingData = [
                'sync_type_value' => $userData->sync_type_value,
                'next_day_shipping_type_value' => $userData->next_day_shipping_type_value,
                'automatically_process_order' => ($userData->automatically_process_order == 1) ? true : false,
                'process_shared_order' => ($userData->process_shared_order == 1) ? true : false,
                'import_category' => ($userData->import_category == 1) ? true : false,
                'import_all' => ($userData->import_all == 1) ? true : false,
                'set_personalised_button_position' => ($userData->set_personalised_button_position == 1) ? true : false,
                'set_personalised_button_selector' => $userData->set_personalised_button_selector,
                'pricing_options' => $userData->pricing_options,
                'margin_change' => $userData->margin_change,
                'deduct_price_change' => $userData->deduct_price_change,
                'price_range_values' => $userData->price_range_values,
                'automated_job_status' => CustomHelpers::getShopRunningJobStatus($userData->shop_domain),
            ];
        }

        return $orderSettingData;
    }

    // delete shopify metafields
    public static function deletePgsShopifyMetafields($storeDomain, $shopAccessToken, $shopifyAuthSessionID)
    {
        $userInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopifyAuthSessionID)->first();
         
        // delete shopify store metafields
        $storeMetafields = ShopifyMetafield::where('personalised_gift_app_user_id', $userInfo->id)->where('resource_type', 'store')->get();
        if(!empty($storeMetafields) && $storeMetafields->count() > 0){
           
            foreach($storeMetafields as $storeMetafield){

                Log::channel('pgs-app-status')->info('start loop for delete shopify metafields for - '.$storeDomain.' and metafield ID - '.$storeMetafield->metafield_id.' removing all sessions on : '.date("Y-m-d H:i:s"));

                if(!empty($storeMetafield->metafield_id)){
                    $shopifyGraphQlMetafieldId = [
                        'id' => $storeMetafield->metafield_id
                    ];
                    ProductCreator::callDeleteMetafield($storeDomain, $shopAccessToken, $shopifyGraphQlMetafieldId); 
                } 
                $storeMetafield->delete();
            }
        }
        return true;
    }

    // delete shopify products
    public static function deletePgsShopifyProducts($storeDomain, $shopAccessToken, $shopifyAuthSessionID)
    {
        $userInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopifyAuthSessionID)->first();
        // delete shopify products
        $storeProducts = PersonalisedGiftAppProduct::where('personalised_gift_app_user_id', $userInfo->id)->get();
        if(!empty($storeProducts) && $storeProducts->count() > 0){
            foreach($storeProducts as $storeProduct){

                PersonalisedGiftAppProductMeta::where('personalised_gift_app_product_id', $storeProduct->id)->delete();

                Log::channel('pgs-app-status')->info('start loop for delete shopify products for - '.$storeDomain.' and product ID - '.$storeProduct->shopify_graph_ql_id.' removing all sessions on : '.date("Y-m-d H:i:s"));

                if(!empty($storeProduct->shopify_graph_ql_id)){
                    $shopifyGraphQlProductId = [
                        'id' => $storeProduct->shopify_graph_ql_id
                    ];
                    ProductCreator::callDeleteShopifyProduct($storeDomain, $shopAccessToken, $shopifyGraphQlProductId);  
                }
                $storeProduct->delete();
            }
        }
        return true;
    }

    // delete shopify collections
    public static function deletePgsShopifyCollections($storeDomain, $shopAccessToken, $shopifyAuthSessionID)
    {
        $userInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopifyAuthSessionID)->first();
        // delete shopify collections
        $storeCollections = PersonalisedGiftAppCategory::where('personalised_gift_app_user_id', $userInfo->id)->get();
        if(!empty($storeCollections) && $storeCollections->count() > 0){
            foreach($storeCollections as $storeCollection){

                Log::channel('pgs-app-status')->info('start loop for delete shopify collection for - '.$storeDomain.' and collection ID - '.$storeCollection->shopify_graph_ql_id.' removing all sessions on : '.date("Y-m-d H:i:s"));

                PersonalisedGiftAppCategoryProduct::where('personalised_gift_app_category_id', $storeCollection->id)->delete();

                if(!empty($storeCollection->shopify_graph_ql_id)){
                    $shopifyGraphQlCollectionId = [
                        'id' => $storeCollection->shopify_graph_ql_id
                    ];
                    ProductCreator::callDeleteShopifyCollection($storeDomain, $shopAccessToken, $shopifyGraphQlCollectionId);  
                }
                $storeCollection->delete();
            }
        }
        return true;
    }

    // delete shopify webhooks
    public static function deletePgsShopifyWebhooks($storeDomain, $shopAccessToken, $shopifyAuthSessionID)
    {
        $userInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopifyAuthSessionID)->first();
        // delete store webhooks
        $storeWebhooks = ShopifyStoreWebhook::where('personalised_gift_app_user_id', $userInfo->id)->get();
        if(!empty($storeWebhooks) && $storeWebhooks->count() > 0){
            foreach($storeWebhooks as $storeWebhook){

                Log::channel('pgs-app-status')->info('start loop for delete shopify webhooks for - '.$storeDomain.' and webhook ID - '.$storeWebhook->webhook_id.' removing all sessions on : '.date("Y-m-d H:i:s"));

                if(!empty($storeWebhook->webhook_id)){

                    $shopifyGraphQlWebhookId = [
                        'id' => "gid://shopify/WebhookSubscription/".$storeWebhook->webhook_id
                    ];

                    ProductCreator::callDeleteShopifyWebhook($storeDomain, $shopAccessToken, $shopifyGraphQlWebhookId);  
                }
                $storeWebhook->delete();
            }
        }
        return true;
    }

    // update product inventory stocks
    public static function updateProductInventoryStock($skus, $apikey, $username, $shopName, $shopAccessToken, $shopifyLocationID, $dbProductId)
    {
        $pgs_third_party_api_url = $_ENV['PERSONALISED_GIFT_APP_API_URL'];
        
        $pgs_product_stock_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_api_url."product/stock?skus=".implode(",", $skus), "GET", $apikey, $username, "");

        $stockResponse = json_decode($pgs_product_stock_response);

        if(!empty($stockResponse->data) && $stockResponse->code == 'product_stocks'){

            foreach($stockResponse->data as $skuKey => $skuData){
                $stockQty = '';
                if(!empty($skuData)){

                    foreach($skuData as $key => $val) {
                        if($key == 'Stock Level'){
                            $stockQty = $val;
                        }
                    }

                    // update product price and stock quantity data
                    Log::channel('syncing-sku-product-quantity')->info('get sku quantity for product sku : '.$skuKey.' and stock quantity from pgs app - '.$stockQty);

                    $metaData = PersonalisedGiftAppProductMeta::where('bigcommerce_sku', $skuKey)->where('personalised_gift_app_product_id', $dbProductId)->get();
                    if(!empty($metaData) && $metaData->count() > 0){
                        foreach($metaData as $meta){

                            if(!empty($meta->personalised_gift_app_product_id) && isset($meta->personalisedGiftAppProduct) && !empty($meta->personalisedGiftAppProduct)){

                                $shopInfo = PersonalisedGiftAppUser::where('id', $meta->personalisedGiftAppProduct->personalised_gift_app_user_id)->first();

                                if(!empty($shopInfo)){

                                    $rangeType = $shopInfo->pricing_options;
                                    $marginPrice = $shopInfo->margin_change;
                                    $deductPrice = $shopInfo->deduct_price_change;
                                    $productPrice = CustomHelper::getProductRegularPrice($skuData, $rangeType, $marginPrice, $deductPrice);
                                    
                                    if($rangeType != 'set_own_price'){

                                        Log::channel('update-shopify-product-price')->info('update shopify product price for range type : '.$rangeType.' and the shopify product id is - '.$meta->personalisedGiftAppProduct->shopify_product_id.' and update product price from shopify product detail page.');

                                        CustomHelpers::updateShopifyProductPrice($shopName, $shopAccessToken, $meta->personalised_gift_app_product_id, $productPrice);

                                        PersonalisedGiftAppProductMeta::where('id', $meta->id)->update(['product_rrp_price' => number_format($productPrice, 2)]);
                                    }                                    
                                }

                                if(!empty($stockQty)){
                                    $shopifyInvntoryItemId = $meta->personalisedGiftAppProduct->shopify_product_inventory_item_id;
                                    if(!empty($shopifyInvntoryItemId)){

                                        $inventoryResponse = ProductCreator::updateVariantInventoryQuantity($shopName, $shopAccessToken, $stockQty, $shopifyLocationID, $shopifyInvntoryItemId);
                                        Log::channel('syncing-sku-product-quantity')->info('get sku quantity for product sku : '.$skuKey.' and stock quantity from pgs app - '.$stockQty.' and inventory response is -'.json_encode($inventoryResponse));
                                    }
                    
                                    PersonalisedGiftAppProductMeta::where('personalised_gift_app_product_id', $meta->personalised_gift_app_product_id)
                                                                    ->where('bigcommerce_sku', $skuKey)
                                                                    ->update(['product_quantity' => $stockQty]);
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    public static function updateProductStocks($skus, $apikey, $username, $shopName, $shopAccessToken, $shopifyLocationID)
    {
        $pgs_third_party_api_url = $_ENV['PERSONALISED_GIFT_APP_API_URL'];
        $pgs_product_stock_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_api_url."product/stock?skus=".implode(",", $skus), "GET", $apikey, $username, "");
        $stockResponse = json_decode($pgs_product_stock_response);
        if(!empty($stockResponse->data)){
            foreach($stockResponse->data as $skuKey => $skuData){
                // $stockQty = 0;
                // foreach($skuData as $key => $val) {
                //     if($key == 'Stock Level'){
                //         $stockQty = $val;
                //     }
                // }

                // $metaData = PersonalisedGiftAppProductMeta::where('bigcommerce_sku', $skuKey)->get();
                // if(!empty($metaData) && $metaData->count() > 0){
                //     foreach($metaData as $meta){
                //         $shopifyInvntoryItemId = $meta->personalisedGiftAppProduct->shopify_product_inventory_item_id;
                //         if(!empty($shopifyInvntoryItemId)){
                //             $productInventoryResponse = ProductCreator::updateVariantInventoryQuantity($shopName, $shopAccessToken, $stockQty, $shopifyLocationID, $shopifyInvntoryItemId);
                //         }
                //         PersonalisedGiftAppProductMeta::where('personalised_gift_app_product_id', $meta->personalised_gift_app_product_id)->update(['product_quantity', $stockQty]);
                //     }
                // }

                $pgs_single_product_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_api_url."product/singal/?sku=".$skuKey, "GET", $apikey, $username, "");
                $productResponse = json_decode($pgs_single_product_response);
                if(!empty($productResponse->data)){

                    $shopifyProductIds = [];
                    $metaData = PersonalisedGiftAppProductMeta::where('bigcommerce_sku', $skuKey)->get();
                    foreach($metaData as $meta){
                        $shopifyProductIds[] = $meta->personalisedGiftAppProduct->shopify_graph_ql_id;
                    }

                    if(!empty($shopifyProductIds) && count($shopifyProductIds)){
                        foreach($shopifyProductIds as $shopifyProductId){

                            $sendProductMetafields = [
                                [
                                    'key' => 'customiserData',
                                    'namespace' => 'custom',
                                    'type' => 'json',
                                    'value' => json_encode($productResponse->data->customiser_data),
                                    'ownerId' => $shopifyProductId,
                                ],
                                [
                                    'key' => 'resellerPricing',
                                    'namespace' => 'custom',
                                    'type' => 'json',
                                    'value' => json_encode($productResponse->data->reseller_pricing),
                                    'ownerId' => $shopifyProductId,
                                ],
                            ];

                            $shopMetafieldResponse = ProductCreator::updateShopMetafields($shopName, $shopAccessToken, $sendProductMetafields);
                            if(!empty($shopMetafieldResponse)){
                                if(!empty($shopMetafieldResponse->data->metafieldsSet->metafields)){
                
                                    foreach($shopMetafieldResponse->data->metafieldsSet->metafields as $metafield){
                
                                        $checkMetafields = ShopifyMetafield::where([
                                            'resource_type' => 'product',
                                            'metafield_key' => $metafield->key,
                                            'metafield_namespace' => $metafield->namespace,
                                            'metafield_id' => $metafield->id,
                                            'metafield_type' => $metafield->type,
                                            'owner_id' => $shopifyProductId,
                                        ])->first();
                
                                        if(!empty($checkMetafields)){
                
                                            $updateData = [
                                                'metafield_value' => $metafield->value,
                                            ];                                            
                                            $checkMetafields->update($updateData);
                                        }
                                    }
                                }
                            } // update shopify metafields data
                        }
                    }
                }
            }            
        }
    }

    public static function getPgsTotalPaginationRecords($shopifyAuthSessionId, $apikey, $username)
    {
        $userData = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopifyAuthSessionId)->first();
        if(!empty($userData)){
            
            $range_type =  $userData->price_range_values;
            $maxrrp = $_ENV['PERSONALISED_PRODUCT_MAX_RRP'];
            $pgs_third_party_product_api_url = $_ENV['PERSONALISED_GIFT_APP_PRODUCT_API_URL'];
            
            $total_pgs_product_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_product_api_url."all_products/?page=1&size=10&range_type=$range_type&max_rrp=$maxrrp", "GET", $apikey, $username, "");

            $totalPgsProducts = json_decode($total_pgs_product_response);
            if(!empty($totalPgsProducts->data)){

                $totalPageProduct = (int)$totalPgsProducts->data->total_page;
                if($totalPageProduct > 0){

                    $countProduct = ($totalPageProduct - 1)*10;
                    
                    $userData->update(['total_pgs_products' => $countProduct, 'total_pgs_product_page_limit' => $totalPageProduct]);
                    
                    if(!empty($range_type)){
                        $decodeRangeType = explode(",", $range_type);
                        if(count($decodeRangeType) > 0){
                            foreach($decodeRangeType as $range){
                                CustomHelper::storeProductRangeTotalProductRecords($apikey, $username, $userData->id, $range);
                            }
                        }
                    }

                    $last_page_pgs_product_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_product_api_url."all_products/?page=$totalPageProduct&size=10&range_type=$range_type&max_rrp=$maxrrp", "GET", $apikey, $username, "");
                    
                    $decodedLastPagePgsProducts = json_decode($last_page_pgs_product_response);
                    if(!empty($decodedLastPagePgsProducts->data->product)){
                        
                        $lastpageTotalProduct = $countProduct + count($decodedLastPagePgsProducts->data->product);
                        
                        $userData->update(['total_pgs_products' => $lastpageTotalProduct]);
                    }
                }
            }
        }
        return true;
    }

    public static function getProductRegularPrice($valueArray, $rangeType, $marginPrice, $deductPrice)
    {
        $regular_price = 0.00;
        if(!empty($valueArray)){
            if ($rangeType == "custom_margin") {
                $margin_per = (float)$marginPrice;
                $margin = ($margin_per / 100) + 1;
    
                $round_up_price = (float)$deductPrice;
                $dropship_for_1 = 0;
                foreach($valueArray as $key => $val) {
                    if($key == 'Dropship For 1'){
                        if(!empty($val)){
                            $dropship_for_1 = trim($val);
                        }
                    }
                }
                
                if($dropship_for_1 > 0){
                    $regular_price = (($dropship_for_1 * 1.2) * $margin) - $round_up_price;
                }
            } else if ($rangeType == "suggested_rrp") {
                foreach($valueArray as $key => $val) {
                    if($key == 'RRP'){
                        if(!empty($val)){
                            $regular_price = trim($val);
                        }
                    }
                }
            } else {
                foreach($valueArray as $key => $val) {
                    if($key == 'RRP'){
                        if(!empty($val)){
                            $regular_price = trim($val);
                        }
                    }
                }
            }
        }
        return $regular_price;
    }

    public static function getAuthUserProducts($userId)
    {
        $authProducts = PersonalisedGiftAppUser::where('id', $userId)->first();
        $authDbProducts = 0;
        if(!empty($authProducts)){
            
            $authDbProducts = $authProducts->total_pgs_products;
            if(!empty($authProducts->price_range_values)){
                
                $decodeRanges = explode(",", $authProducts->price_range_values);
                $authDbProducts  = PersonalisedGiftAppUserProductRanges::where('personalised_gift_app_user_id', $authProducts->id)->whereIn('product_range_type', $decodeRanges)->sum('total_products');
            }
        }
        return $authDbProducts;
    }

    public static function getPgsTotalProducts($shopSessionId, $decodePriceRangeType)
    {
        $dbProducts = PersonalisedGiftAppProduct::select('id')->where('personalised_gift_app_user_id', $shopSessionId)->whereIn('listing_type', $decodePriceRangeType)->count();
        $allProducts = 0;
        if(!empty($dbProducts)){
            $allProducts = $dbProducts;
        }
        return $allProducts;
    }

    public static function createPgsProductData($productData, $shop_domain_name, $shop_db_id, $rangeType, $marginPrice, $deductPrice, $selectedPriceRanges)
    {
        $decodePriceRangeType = explode(",", $selectedPriceRanges);
        
        foreach($productData as $key => $pgsProduct){
            
            if(!empty($pgsProduct->post)){

                $postPgsData = $pgsProduct->post;
                $product_images = NULL;
                $atp_images = NULL;
                $reselerPricingData = NULL;
                $productRrpPrice = 0.00;
                $productPgsPrice = 0.00;
                $shopify_category_taxonomy_id = NULL;
                $product_quantity = 0;

                if(isset($pgsProduct->reseller_pricing) && !empty($pgsProduct->reseller_pricing)){
                  
                    $productRrpPrice = CustomHelper::getProductRegularPrice($pgsProduct->reseller_pricing, $rangeType, $marginPrice, $deductPrice);
                    Log::channel('store-pgs-products')->info("store product json data - ".json_encode($pgsProduct->reseller_pricing)." for post id - ".$postPgsData->ID);
                    
                    if(!empty($pgsProduct->reseller_pricing->Images)){
                        $product_images = $pgsProduct->reseller_pricing->Images;
                    }

                    if(!empty($pgsProduct->reseller_pricing->ATP_Images)){
                        $atp_images = $pgsProduct->reseller_pricing->ATP_Images;
                    }
                    
                    if(!empty($pgsProduct->reseller_pricing->Shopify_Category)){
                        $shopify_category_taxonomy_id = $pgsProduct->reseller_pricing->Shopify_Category;
                    }
                    
                    $productPgsPrice = (isset($pgsProduct->reseller_pricing->RRP) && !empty($pgsProduct->reseller_pricing->RRP)) ? trim($pgsProduct->reseller_pricing->RRP) : 0;
                    $reselerPricingData = json_encode($pgsProduct->reseller_pricing);

                    foreach($pgsProduct->reseller_pricing as $key => $val) {
                        if($key == 'Stock Level'){
                            if(!empty($val)){
                                $product_quantity = trim($val);
                            }
                        }
                    }

                }
                
                $isUpdateProduct = 0;
                if(!empty($pgsProduct->customiser_data)){
                    if(isset($pgsProduct->customiser_data->product_type_cnc) && $pgsProduct->customiser_data->product_type_cnc == 'print'){
                        $isUpdateProduct = 1;
                    }
                }
                
                if(empty($pgsProduct->reseller_pricing)){
                    $isUpdateProduct = 1;
                }
                
                if(!empty($pgsProduct->reseller_pricing)){
                    if(isset($pgsProduct->reseller_pricing->RRP) && empty($pgsProduct->reseller_pricing->RRP)){
                        $isUpdateProduct = 1;
                    }                    
                }
                
                if(isset($pgsProduct->meta->_thumbnail_id[0]) && empty($pgsProduct->meta->_thumbnail_id[0])){
                    $isUpdateProduct = 1;
                }

                $pgsAppProductData = [
                    'personalised_gift_app_user_id' => $shop_db_id,
                    'shop_domain' => $shop_domain_name,
                    'post_id' => $postPgsData->ID,
                    'post_author' => $postPgsData->post_author,
                    'post_date' => $postPgsData->post_date,
                    'post_date_gmt' => $postPgsData->post_date,
                    'post_content' => $postPgsData->post_content,
                    'post_title' => $postPgsData->post_title,
                    'post_excerpt' => $postPgsData->post_excerpt,
                    'post_status' => $postPgsData->post_status,
                    'comment_status' => $postPgsData->comment_status,
                    'ping_status' => $postPgsData->ping_status,
                    'post_password' => $postPgsData->post_password,
                    'post_name' => $postPgsData->post_name,
                    'to_ping' => $postPgsData->to_ping,
                    'pinged' => $postPgsData->pinged,
                    'post_modified' => $postPgsData->post_modified,
                    'post_modified_gmt' => $postPgsData->post_modified_gmt,
                    'post_content_filtered' => $postPgsData->post_content_filtered,
                    'post_parent' => $postPgsData->post_parent,
                    'guid' => $postPgsData->guid,
                    'menu_order' => $postPgsData->menu_order,
                    'post_type' => $postPgsData->post_type,
                    'post_mime_type' => $postPgsData->post_mime_type,
                    'comment_count' => $postPgsData->comment_count,
                    'filter' => $postPgsData->filter,
                    'pgs_link' => $pgsProduct->pgs_link,
                    'customiser_data' => (!empty($pgsProduct->customiser_data)) ? json_encode($pgsProduct->customiser_data) : NULL,
                    'reseller_pricing' => $reselerPricingData,
                    'extra_images' => $product_images,
                    'atp_images' => $atp_images,
                    'thumbnail_image' => $pgsProduct->thumbnail_image,
                    'shopify_category_taxonomy_id' => $shopify_category_taxonomy_id,
                    'listing_type' => (isset($pgsProduct->listing_type) && !empty($pgsProduct->listing_type)) ? $pgsProduct->listing_type : NULL,
                    'product_created_by' => 'syncing_product_job'
                ];  

                $authLoginUserProducts = CustomHelper::getAuthUserProducts($shop_db_id);
                $totalAddedRecords = CustomHelper::getPgsTotalProducts($shop_db_id, $decodePriceRangeType);
                
                /* $getPgsProductInfo = PersonalisedGiftAppProduct::updateOrCreate(['personalised_gift_app_user_id' => $shop_db_id, 'post_id' => $postPgsData->ID, 'post_title' => $postPgsData->post_title], $pgsAppProductData); */
                
                // if($totalAddedRecords <= $authLoginUserProducts){
                    
                    $getPgsProductInfo = PersonalisedGiftAppProduct::where('personalised_gift_app_user_id', $shop_db_id)->where('post_id', $postPgsData->ID)->first();
                    if(empty($getPgsProductInfo)){
                        
                        $pgsAppProductData['shopify_product_status'] = 'Inactive';
                        $pgsAppProductData['is_publish_shopify_product'] = $isUpdateProduct;
                        $getPgsProductInfo = PersonalisedGiftAppProduct::create($pgsAppProductData);
                        
                    }else{
                        $getPgsProductInfo->update($pgsAppProductData);
                    }

                    $dbProductId = $getPgsProductInfo->id;

                    // save product meta data 
                    if(!empty($pgsProduct->meta)){
        
                        $postPgsMetaData = $pgsProduct->meta;
                        $savePgsProductMetaData = [
                            // 'personalised_gift_app_product_id' => $dbProductId,
                            'product_rrp_price' => trim($productRrpPrice),
                            'pgs_product_price' => trim($productPgsPrice),
                            'product_quantity' => $product_quantity,
                            'bigcommerce_importer_version' => (!empty($postPgsMetaData->bigcommerce_importer_version)) ? $postPgsMetaData->bigcommerce_importer_version[0] : NULL,
                            'bigcommerce_id' => (!empty($postPgsMetaData->bigcommerce_id)) ? $postPgsMetaData->bigcommerce_id[0] : NULL,
                            'bigcommerce_sku' => (!empty($postPgsMetaData->bigcommerce_sku)) ? $postPgsMetaData->bigcommerce_sku[0] : NULL,
                            'bigcommerce_sku_normalized' => (!empty($postPgsMetaData->bigcommerce_sku_normalized)) ? $postPgsMetaData->bigcommerce_sku_normalized[0] : NULL,
                            'bigcommerce_rating' => (!empty($postPgsMetaData->bigcommerce_rating)) ? $postPgsMetaData->bigcommerce_rating[0] : NULL,
                            'bigcommerce_review_count' => (!empty($postPgsMetaData->bigcommerce_review_count)) ? $postPgsMetaData->bigcommerce_review_count[0] : NULL,
                            'bigcommerce_review_rating_sum' => (!empty($postPgsMetaData->bigcommerce_review_rating_sum)) ? $postPgsMetaData->bigcommerce_review_rating_sum[0] : NULL,
                            'bigcommerce_sales' => (!empty($postPgsMetaData->bigcommerce_sales)) ? $postPgsMetaData->bigcommerce_sales[0] : NULL,
                            'bigcommerce_calculated_price' => (!empty($postPgsMetaData->bigcommerce_calculated_price)) ? $postPgsMetaData->bigcommerce_calculated_price[0] : NULL,
                            'bigcommerce_inventory_level' => (!empty($postPgsMetaData->bigcommerce_inventory_level)) ? $postPgsMetaData->bigcommerce_inventory_level[0] : NULL,
                            'bigcommerce_price_range' => (!empty($postPgsMetaData->bigcommerce_price_range)) ? json_encode($postPgsMetaData->bigcommerce_price_range[0]) : NULL,
                            'bigcommerce_data_hash' => (!empty($postPgsMetaData->bigcommerce_data_hash)) ? $postPgsMetaData->bigcommerce_data_hash[0] : NULL,
                            'wp_old_date' => (!empty($postPgsMetaData->_wp_old_date)) ? $postPgsMetaData->_wp_old_date[0] : NULL,
                            'bigcommerce_source_data' => (!empty($postPgsMetaData->bigcommerce_source_data)) ? json_encode($postPgsMetaData->bigcommerce_source_data[0]) : NULL,
                            'bigcommerce_listing_data' => (!empty($postPgsMetaData->bigcommerce_listing_data)) ? json_encode($postPgsMetaData->bigcommerce_listing_data[0]) : NULL,
                            'bigcommerce_modifier_data' => (!empty($postPgsMetaData->bigcommerce_modifier_data)) ? json_encode($postPgsMetaData->bigcommerce_modifier_data[0]) : NULL,
                            'bigcommerce_options_data' => (!empty($postPgsMetaData->bigcommerce_options_data)) ? json_encode($postPgsMetaData->bigcommerce_options_data[0]) : NULL,
                            'bigcommerce_custom_fields' => (!empty($postPgsMetaData->bigcommerce_custom_fields)) ? json_encode($postPgsMetaData->bigcommerce_custom_fields[0]) : NULL,
                            'thumbnail_id' => (!empty($postPgsMetaData->_thumbnail_id)) ? $postPgsMetaData->_thumbnail_id[0] : NULL,
                            'bigcommerce_gallery' => (!empty($postPgsMetaData->bigcommerce_gallery)) ? json_encode($postPgsMetaData->bigcommerce_gallery[0]) : NULL,
                            'bigcommerce_variant_images' => (!empty($postPgsMetaData->bigcommerce_variant_images)) ? json_encode($postPgsMetaData->bigcommerce_variant_images[0]) : NULL,
                            'bigcommerce_reviews' => (!empty($postPgsMetaData->bigcommerce_reviews)) ? json_encode($postPgsMetaData->bigcommerce_reviews[0]) : NULL,
                            'bigcommerce_approved_review_count' => (!empty($postPgsMetaData->bigcommerce_approved_review_count)) ? $postPgsMetaData->bigcommerce_approved_review_count[0] : NULL,
                        ]; 
                        
                        PersonalisedGiftAppProductMeta::updateOrCreate(['personalised_gift_app_product_id' => $dbProductId], $savePgsProductMetaData);
                    }
        
                    // save category data 
                    if(!empty($pgsProduct->category)){
        
                        $postPgsCategoryData = $pgsProduct->category;
                        if(!empty($postPgsCategoryData) && count($postPgsCategoryData) > 0){
                            foreach($postPgsCategoryData as $categoryData){
        
                                $savePgsCategoryData = [
                                    'personalised_gift_app_user_id' => $shop_db_id,
                                    'shop_domain' => $shop_domain_name,
                                    'term_id' => $categoryData->term_id,
                                    'name' => $categoryData->name,
                                    'slug' => $categoryData->slug,
                                    'term_group' => $categoryData->term_group,
                                    'term_taxonomy_id' => $categoryData->term_taxonomy_id,
                                    'taxonomy' => $categoryData->taxonomy,
                                    'description' => $categoryData->description,
                                    'parent' => $categoryData->parent,
                                    'count' => $categoryData->count,
                                    'filter' => $categoryData->filter,
                                    'background_image' => $categoryData->background_image,
                                ];  
        
                                /* $categoryInfo = PersonalisedGiftAppCategory::where('shop_domain', $shop_domain_name)->where('term_id', $categoryData->term_id)->where('name', $categoryData->name)->where('slug', $categoryData->slug)->whereNull('shopify_collection_id')->first();
                                if(empty($categoryInfo)){
                                    $categoryInfo = PersonalisedGiftAppCategory::create($savePgsCategoryData);
                                }else{
                                    $categoryInfo->update($savePgsCategoryData);
                                } */
                                
                                $categoryInfo = PersonalisedGiftAppCategory::updateOrCreate(['shop_domain' => $shop_domain_name,'term_id' => $categoryData->term_id, 'name' => $categoryData->name, 'slug' => $categoryData->slug], $savePgsCategoryData);
        
                                // save product category category data 
                                $productCategoryData = [
                                    'personalised_gift_app_category_id' => $categoryInfo->id,
                                    'personalised_gift_app_product_id' => $dbProductId,
                                ];
        
                                PersonalisedGiftAppCategoryProduct::updateOrCreate(['personalised_gift_app_category_id' => $categoryInfo->id,'personalised_gift_app_product_id' => $dbProductId], $productCategoryData);
        
                            }
                        }
                    }

                // }else{
                //    return true;
                // }
                
            }
        }
        return true;
    }

    public static function createPgsItemShopifyFulfillment($itemData)
    {
        $getUserInfo = PersonalisedGiftAppUser::where('id', $itemData->shopifyStoreOrder->personalised_gift_app_user_id)->first();
        if(!empty($getUserInfo)){
            $shopInfo = Session::where('id', $getUserInfo->shopify_auth_session_id)->first();
            
            if(!empty($shopInfo)){
                
                $shopName = $shopInfo->shop;
                $shopAccessToken = $shopInfo->access_token;

                $fulfillemntData = [
                    'notifyCustomer' => true,
                    'trackingInfo' => [
                        'company' => 'Personalised Gift APP',
                        'number' => $itemData->pgs_order_tracking_id
                    ],
                    'lineItemsByFulfillmentOrder' => [
                        'fulfillmentOrderId' => $itemData->shopify_fulfillment_order_id,
                        'fulfillmentOrderLineItems' => [
                            [
                                'id' => $itemData->shopify_fulfillment_order_item_id,
                                'quantity' => (int) $itemData->quantity
                            ]
                        ]
                    ],
                    'originAddress' => null
                ];

                Log::channel('create-order-fulfillment-job')->info('Create order fulfillment order request : '.json_encode($fulfillemntData).' for db order item id - '.$itemData->id);
                
                $shopOrderResponse = ProductCreator::createShopifyOrderFulfillment($shopName, $shopAccessToken, $fulfillemntData);
                
                Log::channel('create-order-fulfillment-job')->info('Create order fulfillment order response : '.json_encode($shopOrderResponse).' for db order item id - '.$itemData->id);
                
                $updateFulfillRecord['shopify_order_fulfillment_request'] = json_encode($fulfillemntData);
                $updateFulfillRecord['shopify_order_fulfillment_response'] = json_encode($shopOrderResponse);

                if(!empty($shopOrderResponse->data)){

                    $fulfillInfo = $shopOrderResponse->data->fulfillmentCreateV2->fulfillment;
                    if(!empty($fulfillInfo)){
                        $updateFulfillRecord['shopify_fulfillemnt_id'] = $fulfillInfo->id;
                        $updateFulfillRecord['shopify_fulfillemnt_status'] = $fulfillInfo->status;
                        $updateFulfillRecord['shopify_fulfillemnt_tracking_info'] = json_encode($fulfillInfo->trackingInfo);
                    }                    
                }
                ShopifyStoreOrderItem::where('id', $itemData->id)->update($updateFulfillRecord);
            }
        }
    }

    public static function checkShopifyThemeSupport($shopName, $shopAccessToken)
    {
        $SHOPIFY_VERSION = $_ENV['SHOPIFY_VERSION'];
        $SHOPIFY_THEME_API = "https://$shopName/admin/api/$SHOPIFY_VERSION/themes.json";
            
        $APP_BLOCK_TEMPLATES = ['product', 'collection', 'index'];
        
        $theme_response = PersonalisedAppTrait::callCurlShopifyRestAPI($SHOPIFY_THEME_API, "GET", '', $shopAccessToken);
        $decoded_theme_response = json_decode($theme_response);
        // dd($decoded_theme_response);
        if(isset($decoded_theme_response->themes) && !empty($decoded_theme_response->themes)){
            foreach($decoded_theme_response->themes as $theme)
            {
                if($theme->role == "main")
                {
                    $active_theme_id = $theme->admin_graphql_api_id;
                    $shopifyMainThemeId = str_replace("gid://shopify/Theme/","", $active_theme_id);
                    
                    $SHOPIFY_ASSETS_API = "https://$shopName/admin/api/$SHOPIFY_VERSION/themes/$shopifyMainThemeId/assets.json";
        
                    $theme_assets_response = PersonalisedAppTrait::callCurlShopifyRestAPI($SHOPIFY_ASSETS_API, "GET", '', $shopAccessToken);
                    $decoded_theme_assets_response = json_decode($theme_assets_response);

                    $assetsData = $decoded_theme_assets_response->assets;
                    // Check if JSON template files exist for the template specified in `$APP_BLOCK_TEMPLATES`
                    // $templateJSONFiles = array_filter($assetsData, function($file) use ($APP_BLOCK_TEMPLATES) {
                    //     return(in_array(str_replace('templates/', '', $file->key), $APP_BLOCK_TEMPLATES));
                    // });

                    $templateJSONFiles = array_filter($assetsData, function ($file) use ($APP_BLOCK_TEMPLATES) {
                      foreach ($APP_BLOCK_TEMPLATES as $template) {
                        if ($file->key === "templates/{$template}.json") {
                          return true;
                        }
                      }
                      return false;
                    });

                    if (count($templateJSONFiles) > 0 && (count($templateJSONFiles) === count($APP_BLOCK_TEMPLATES))) {
                        // echo 'All desired templates support sections everywhere!';
                    } else if (count($templateJSONFiles)) {
                        // echo 'Only some of the desired templates support sections everywhere.';
                    }

                    // Retrieve the body of JSON templates and find what section is set as `main`
                    $templateMainSections = [];
                    if(!empty($templateJSONFiles)){
                        foreach ($templateJSONFiles as $file) {

                            $SHOPIFY_SINGLE_ASSETS_API = "https://$shopName/admin/api/$SHOPIFY_VERSION/themes/$shopifyMainThemeId/assets.json?asset[key]=".$file->key;
                            
                            $theme_assets_response = PersonalisedAppTrait::callCurlShopifyRestAPI($SHOPIFY_SINGLE_ASSETS_API, "GET", '', $shopAccessToken);
                            $json = json_decode($theme_assets_response);

                            if(isset($json->asset) && !empty($json->asset)){
                                $jsonValue = json_decode($json->asset->value, true);

                                $main = null;
                                foreach ($jsonValue['sections'] as $id => $section) {
                                    if ($id === 'main' || strpos($section['type'], 'main-') === 0) {
                                      $main = $section;
                                      break;
                                    }
                                }
                                  
                                if ($main) {
                                    $templateMainSections[] = array_filter($assetsData, function ($file) use ($main) {
                                      return $file->key === "sections/{$main['type']}.liquid";
                                    });
                                }
                            }
                        }
                    }

                    return $templateJSONFiles;
                    // Request the content of each section and check if it has a schema that contains a
                    // block of type
                }
            }
        }
    }
    
    // get order shipping price
    public static function getOrderShippingPrice($shippingLines)
    {
        $shippingPrice = 0;
        if(!empty($shippingLines)){
            $decodeShippingData = json_decode($shippingLines);
            $shippingPrice = $decodeShippingData[0]->price;
        }
        return $shippingPrice;
    }
    
    public static function runShopifyPublishingProduct($shopify_auth_session_id)
    {
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', $shopify_auth_session_id)->where('import_all', 1)->first();
        if(!empty($shopInfo)){
            
            $shopName = $shopInfo->session->shop;
            $shopAccessToken = $shopInfo->session->access_token;
            $shopifyAuthSessionId = $shopInfo->shopify_auth_session_id;
            
            $shopifyLocationId = '';
            $shopifySalesChannelId = '';
            if(!empty($shopInfo->store_location_id)){
                $shopifyLocationId = $shopInfo->store_location_id;
            }
    
            if(!empty($shopInfo->store_sales_channel_id)){
                $shopifySalesChannelId = $shopInfo->store_sales_channel_id;
            }
            
            $rangeType = $shopInfo->pricing_options;
            $marginPrice = $shopInfo->margin_change;
            $deductPrice = $shopInfo->deduct_price_change;
            $userId = $shopInfo->id;
            $importCategoryStatus = $shopInfo->import_category;
            
            CustomHelpers::publishProductsOnShopify($shopName, $rangeType, $marginPrice, $deductPrice, $userId, $shopAccessToken, $shopifySalesChannelId, $shopifyLocationId, $shopifyAuthSessionId, $importCategoryStatus);
            
        }
        return true;
    }
    
    public static function publishProductsOnShopify($shopName, $rangeType, $marginPrice, $deductPrice, $userId, $shopAccessToken, $shopifySalesChannelId, $shopifyLocationId, $shopifyAuthSessionId, $importCategoryStatus)
    {
        $details['shop_name'] = $shopName;
		$details['range_type'] = $rangeType;
		$details['margin_price'] = $marginPrice;
		$details['deduct_price'] = $deductPrice;
		$details['user_id'] = $userId;
		$details['access_token'] = $shopAccessToken;
		$details['sales_channel_id'] = $shopifySalesChannelId;
		$details['shopify_location_id'] = $shopifyLocationId;
		$details['auth_session_id'] = $shopifyAuthSessionId;
		$details['import_category_status'] = $importCategoryStatus;
		
		$shopData = PersonalisedGiftAppUser::where('id', $userId)->first();
		$decodedRangeTypes = [];
		if(!empty($shopData->price_range_values)){
		    $decodedRangeTypes = explode(",", $shopData->price_range_values);
		}
		
        PersonalisedGiftAppProduct::where('personalised_gift_app_user_id', $userId)->whereNull('shopify_product_id')->whereIn('listing_type', $decodedRangeTypes)->where('is_shopify_product', 0)->where('is_publish_shopify_product', 0)->update(['is_job_process' => 1]);

        $persolaisedProducts = PersonalisedGiftAppProduct::where('personalised_gift_app_user_id', $userId)->whereNull('shopify_product_id')->whereIn('listing_type', $decodedRangeTypes)->where('is_shopify_product', 0)->where('is_publish_shopify_product', 0)->where('is_job_process', 1)->get();

        if(!empty($persolaisedProducts) && $persolaisedProducts->count() > 0){
            foreach($persolaisedProducts as $persolaisedProduct){
                
                $details['db_product_id'] = $persolaisedProduct->id;
                
                AutomaticPublishShopifyProductJob::dispatch($details)->onQueue('publish_product');
                
                // $persolaisedProduct->update(['is_shopify_product' => 1]);
            }
        }
        return true;
    }
    
    public static function updateProductPriceCrons($shopName, $rangeType, $marginPrice, $deductPrice, $shopAccessToken, $shopifyAuthSessionId, $userId)
    {
        $details['shop_name'] = $shopName;
		$details['range_type'] = $rangeType;
		$details['margin_price'] = $marginPrice;
		$details['deduct_price'] = $deductPrice;
		$details['access_token'] = $shopAccessToken;
		
		$shopData = PersonalisedGiftAppUser::where('id', $userId)->first();
		$decodedRangeTypes = [];
		if(!empty($shopData->price_range_values)){
		    $decodedRangeTypes = explode(",", $shopData->price_range_values);
		}
		
        PersonalisedGiftAppProduct::where('personalised_gift_app_user_id', $userId)->whereNotNull('shopify_product_id')->whereIn('listing_type', $decodedRangeTypes)->where('is_publish_shopify_product', 0)->update(['is_update_product_price' => 1]);
        $persolaisedProducts = PersonalisedGiftAppProduct::where('personalised_gift_app_user_id', $userId)->whereNotNull('shopify_product_id')->whereIn('listing_type', $decodedRangeTypes)->where('is_publish_shopify_product', 0)->where('is_update_product_price', 1)->get();
        if(!empty($persolaisedProducts) && $persolaisedProducts->count() > 0){
            foreach($persolaisedProducts as $persolaisedProduct){
                
                $details['personalised_product_data'] = $persolaisedProduct;
                $details['db_product_id'] = $persolaisedProduct->id;
       
                AutomaticUpdateProductPriceJob::dispatch($details)->onQueue('update_price');
            }
        }
        return true;
    }
    
    public static function GetClipartReferNumber($clipartName, $authSessionId, $type)
    {
        $clipartInfo = PersonalisedGiftAppClipart::where('personalised_gift_app_user_id', $authSessionId)->where('name', $clipartName)->first();
        $clipartReferNumber = '';
        if(!empty($clipartInfo)){
            $clipartReferNumber = $clipartInfo->internal_name;
            if(!empty($type)){
                $clipartReferNumber = $clipartReferNumber.' ('.$clipartInfo->name.')';
            }
        }
        return $clipartReferNumber;
    }
    
    public static function storeProductRangeTotalProductRecords($apikey, $username, $userId, $rangetype)
    {
        $maxrrp = $_ENV['PERSONALISED_PRODUCT_MAX_RRP'];
        $pgs_third_party_product_api_url = $_ENV['PERSONALISED_GIFT_APP_PRODUCT_API_URL'];
    
        $total_pgs_product_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_product_api_url."all_products/?page=1&size=10&range_type=$rangetype&max_rrp=$maxrrp", "GET", $apikey, $username, "");
        
        $totalPgsProducts = json_decode($total_pgs_product_response);
        if(!empty($totalPgsProducts->data)){
    
            $totalPageProduct = (int)$totalPgsProducts->data->total_page;
            if($totalPageProduct > 0){
    
                $countProduct = ($totalPageProduct - 1)*10;
                
                $updateTotalRecord = [
                    'personalised_gift_app_user_id' => $userId,
                    'total_products' => $countProduct,
                    'total_page_limit' => $totalPageProduct,
                    'product_range_type' => $rangetype
                ];
    
                $checkUserProductRange = PersonalisedGiftAppUserProductRanges::where('personalised_gift_app_user_id', $userId)->where('product_range_type', $rangetype)->first();
                if(!empty($checkUserProductRange)){
                    $checkUserProductRange->update($updateTotalRecord);
                }else{
                    PersonalisedGiftAppUserProductRanges::create($updateTotalRecord);
                }
    
                $last_page_pgs_product_response = PersonalisedAppTrait::callPersonalisedAppAPI($pgs_third_party_product_api_url."all_products/?page=$totalPageProduct&size=10&range_type=$rangetype&max_rrp=$maxrrp", "GET", $apikey, $username, "");
                
                $decodedLastPagePgsProducts = json_decode($last_page_pgs_product_response);
                if(!empty($decodedLastPagePgsProducts->data->product)){
                    
                    $lastpageTotalProduct = $countProduct + count($decodedLastPagePgsProducts->data->product);
                    
                    $updateLastPageTotalRecord = [
                        'personalised_gift_app_user_id' => $userId,
                        'total_products' => $lastpageTotalProduct
                    ];
    
                    $checkUserLastPageProductRange = PersonalisedGiftAppUserProductRanges::where('personalised_gift_app_user_id', $userId)->where('product_range_type', $rangetype)->first();
                    if(!empty($checkUserLastPageProductRange)){
                        $checkUserLastPageProductRange->update($updateLastPageTotalRecord);
                    }
                }
            }
        }
        
        return true;
    }
    
    public static function UpdateShopifyProductStatus($shopName, $shopAccessToken, $authUserId, $checkStatus, $updateStatus, $ranges)
    {
        $details['shop_name'] = $shopName;
        $details['access_token'] = $shopAccessToken;
        
        if($updateStatus == 'ARCHIVED'){
            $updatedJob = AutomaticUpdateProductArchivedStatusJob::class;
            $jobQueue = 'update_archived_products_status';
        }else{
            $updatedJob = AutomaticUpdateProductActiveStatusJob::class;
            $jobQueue = 'update_active_products_status';
        }
        		
        $updatedProducts = PersonalisedGiftAppProduct::select('id', 'shopify_graph_ql_id')->where('personalised_gift_app_user_id', $authUserId)->whereNotNull('shopify_graph_ql_id')->where('shopify_product_status', $checkStatus)->whereIn('listing_type', $ranges)->get();
        if(!empty($updatedProducts) && $updatedProducts->count() > 0){
            foreach($updatedProducts as $updatedProduct){
                
                $details['db_product_id'] = $updatedProduct->id;
                $details['status'] = $updateStatus;
                
                $updatedJob::dispatch($details)->onQueue($jobQueue);
            }
        }
        return true;
    }
    
    public static function updateShopifyProductStatusChange($shopName, $shopAccessToken, $dbProductId, $updateStatus)
    {
        $productInfo = PersonalisedGiftAppProduct::where('id', $dbProductId)->whereNotNull('shopify_graph_ql_id')->first();
        if(!empty($productInfo)){
            
            $changeProductResponse = ProductCreator::changeShopifyProductStatus($shopName, $shopAccessToken, $productInfo->shopify_graph_ql_id, $updateStatus);
                
            Log::channel('automatic-update-archived-product-status')->info("Change Product Response Data -".json_encode($changeProductResponse));

            if(!empty($changeProductResponse)){
                if(!empty($changeProductResponse->data->productChangeStatus->product)){
                    $shopifyGraphQlProductId = $changeProductResponse->data->productChangeStatus->product->id;
                    $apiStatus = $changeProductResponse->data->productChangeStatus->product->status;
                    
                    PersonalisedGiftAppProduct::where('shopify_graph_ql_id', $shopifyGraphQlProductId)->update(['shopify_product_status' => $apiStatus]);
                }
            }
        }
        return true;
    }

    public static function storePgsCreateProductWebhookData($pgsProduct, $shop_domain_name, $user_id, $rangeType, $marginPrice, $deductPrice, $selectedPriceRanges, $importStatus, $importCategoryStatus, $shopAccessToken, $shopifyLocationId, $shopifySalesChannelId, $shopifyAuthSessionId)
    {
        $decodePriceRangeType = explode(",", $selectedPriceRanges);
        
        if(!empty($pgsProduct->post)){

            $postPgsData = $pgsProduct->post;
            $product_images = NULL;
            $atp_images = NULL;
            $reselerPricingData = NULL;
            $productRrpPrice = 0.00;
            $productPgsPrice = 0.00;
            $shopify_category_taxonomy_id = NULL;
            $product_quantity = 0;

            if(isset($pgsProduct->reseller_pricing) && !empty($pgsProduct->reseller_pricing)){
              
                $productRrpPrice = CustomHelper::getProductRegularPrice($pgsProduct->reseller_pricing, $rangeType, $marginPrice, $deductPrice);
                
                if(!empty($pgsProduct->reseller_pricing->Images)){
                    $product_images = $pgsProduct->reseller_pricing->Images;
                }

                if(!empty($pgsProduct->reseller_pricing->ATP_Images)){
                    $atp_images = $pgsProduct->reseller_pricing->ATP_Images;
                }
                
                if(!empty($pgsProduct->reseller_pricing->Shopify_Category)){
                    $shopify_category_taxonomy_id = $pgsProduct->reseller_pricing->Shopify_Category;
                }
                
                $productPgsPrice = (isset($pgsProduct->reseller_pricing->RRP) && !empty($pgsProduct->reseller_pricing->RRP)) ? trim($pgsProduct->reseller_pricing->RRP) : 0;
                $reselerPricingData = json_encode($pgsProduct->reseller_pricing);

                foreach($pgsProduct->reseller_pricing as $key => $val) {
                    if($key == 'Stock Level'){
                        if(!empty($val)){
                            $product_quantity = trim($val);
                        }
                    }
                }

            }
            
            $isUpdateProduct = 0;
            if(!empty($pgsProduct->customiser_data)){
                if(!empty($pgsProduct->customiser_data->product_type_cnc) && $pgsProduct->customiser_data->product_type_cnc == 'print'){
                    $isUpdateProduct = 1;
                }
            }
            
            if(empty($pgsProduct->reseller_pricing)){
                $isUpdateProduct = 1;
            }else{
                if(empty($pgsProduct->reseller_pricing->RRP)){
                    $isUpdateProduct = 1;
                }
            }            
            
            if(empty($pgsProduct->meta->_thumbnail_id[0])){
                $isUpdateProduct = 1;
            }

            $pgsAppProductData = [
                'personalised_gift_app_user_id' => $user_id,
                'shop_domain' => $shop_domain_name,
                'post_id' => $postPgsData->ID,
                'post_author' => $postPgsData->post_author,
                'post_date' => $postPgsData->post_date,
                'post_date_gmt' => $postPgsData->post_date,
                'post_content' => $postPgsData->post_content,
                'post_title' => $postPgsData->post_title,
                'post_excerpt' => $postPgsData->post_excerpt,
                'post_status' => $postPgsData->post_status,
                'comment_status' => $postPgsData->comment_status,
                'ping_status' => $postPgsData->ping_status,
                'post_password' => $postPgsData->post_password,
                'post_name' => $postPgsData->post_name,
                'to_ping' => $postPgsData->to_ping,
                'pinged' => $postPgsData->pinged,
                'post_modified' => $postPgsData->post_modified,
                'post_modified_gmt' => $postPgsData->post_modified_gmt,
                'post_content_filtered' => $postPgsData->post_content_filtered,
                'post_parent' => $postPgsData->post_parent,
                'guid' => $postPgsData->guid,
                'menu_order' => $postPgsData->menu_order,
                'post_type' => $postPgsData->post_type,
                'post_mime_type' => $postPgsData->post_mime_type,
                'comment_count' => $postPgsData->comment_count,
                'filter' => $postPgsData->filter,
                'pgs_link' => $pgsProduct->pgs_link,
                'customiser_data' => (!empty($pgsProduct->customiser_data)) ? json_encode($pgsProduct->customiser_data) : NULL,
                'reseller_pricing' => $reselerPricingData,
                'extra_images' => $product_images,
                'atp_images' => $atp_images,
                'thumbnail_image' => $pgsProduct->thumbnail_image,
                'shopify_category_taxonomy_id' => $shopify_category_taxonomy_id,
                'listing_type' => (!empty($pgsProduct->listing_type)) ? $pgsProduct->listing_type : NULL,
                'shopify_product_status' => 'Inactive',
                'is_publish_shopify_product' => $isUpdateProduct,
                'product_created_by' => 'pgs_webhook'
            ];  

            $getPgsProductInfo = PersonalisedGiftAppProduct::create($pgsAppProductData);

            $dbProductId = $getPgsProductInfo->id;

            // save product meta data 
            if(!empty($pgsProduct->meta)){

                $postPgsMetaData = $pgsProduct->meta;
                $savePgsProductMetaData = [
                    'product_rrp_price' => trim($productRrpPrice),
                    'pgs_product_price' => trim($productPgsPrice),
                    'product_quantity' => $product_quantity,
                    'bigcommerce_importer_version' => (!empty($postPgsMetaData->bigcommerce_importer_version)) ? $postPgsMetaData->bigcommerce_importer_version[0] : NULL,
                    'bigcommerce_id' => (!empty($postPgsMetaData->bigcommerce_id)) ? $postPgsMetaData->bigcommerce_id[0] : NULL,
                    'bigcommerce_sku' => (!empty($postPgsMetaData->bigcommerce_sku)) ? $postPgsMetaData->bigcommerce_sku[0] : NULL,
                    'bigcommerce_sku_normalized' => (!empty($postPgsMetaData->bigcommerce_sku_normalized)) ? $postPgsMetaData->bigcommerce_sku_normalized[0] : NULL,
                    'bigcommerce_rating' => (!empty($postPgsMetaData->bigcommerce_rating)) ? $postPgsMetaData->bigcommerce_rating[0] : NULL,
                    'bigcommerce_review_count' => (!empty($postPgsMetaData->bigcommerce_review_count)) ? $postPgsMetaData->bigcommerce_review_count[0] : NULL,
                    'bigcommerce_review_rating_sum' => (!empty($postPgsMetaData->bigcommerce_review_rating_sum)) ? $postPgsMetaData->bigcommerce_review_rating_sum[0] : NULL,
                    'bigcommerce_sales' => (!empty($postPgsMetaData->bigcommerce_sales)) ? $postPgsMetaData->bigcommerce_sales[0] : NULL,
                    'bigcommerce_calculated_price' => (!empty($postPgsMetaData->bigcommerce_calculated_price)) ? $postPgsMetaData->bigcommerce_calculated_price[0] : NULL,
                    'bigcommerce_inventory_level' => (!empty($postPgsMetaData->bigcommerce_inventory_level)) ? $postPgsMetaData->bigcommerce_inventory_level[0] : NULL,
                    'bigcommerce_price_range' => (!empty($postPgsMetaData->bigcommerce_price_range)) ? json_encode($postPgsMetaData->bigcommerce_price_range[0]) : NULL,
                    'bigcommerce_data_hash' => (!empty($postPgsMetaData->bigcommerce_data_hash)) ? $postPgsMetaData->bigcommerce_data_hash[0] : NULL,
                    'wp_old_date' => (!empty($postPgsMetaData->_wp_old_date)) ? $postPgsMetaData->_wp_old_date[0] : NULL,
                    'bigcommerce_source_data' => (!empty($postPgsMetaData->bigcommerce_source_data)) ? json_encode($postPgsMetaData->bigcommerce_source_data[0]) : NULL,
                    'bigcommerce_listing_data' => (!empty($postPgsMetaData->bigcommerce_listing_data)) ? json_encode($postPgsMetaData->bigcommerce_listing_data[0]) : NULL,
                    'bigcommerce_modifier_data' => (!empty($postPgsMetaData->bigcommerce_modifier_data)) ? json_encode($postPgsMetaData->bigcommerce_modifier_data[0]) : NULL,
                    'bigcommerce_options_data' => (!empty($postPgsMetaData->bigcommerce_options_data)) ? json_encode($postPgsMetaData->bigcommerce_options_data[0]) : NULL,
                    'bigcommerce_custom_fields' => (!empty($postPgsMetaData->bigcommerce_custom_fields)) ? json_encode($postPgsMetaData->bigcommerce_custom_fields[0]) : NULL,
                    'thumbnail_id' => (!empty($postPgsMetaData->_thumbnail_id)) ? $postPgsMetaData->_thumbnail_id[0] : NULL,
                    'bigcommerce_gallery' => (!empty($postPgsMetaData->bigcommerce_gallery)) ? json_encode($postPgsMetaData->bigcommerce_gallery[0]) : NULL,
                    'bigcommerce_variant_images' => (!empty($postPgsMetaData->bigcommerce_variant_images)) ? json_encode($postPgsMetaData->bigcommerce_variant_images[0]) : NULL,
                    'bigcommerce_reviews' => (!empty($postPgsMetaData->bigcommerce_reviews)) ? json_encode($postPgsMetaData->bigcommerce_reviews[0]) : NULL,
                    'bigcommerce_approved_review_count' => (!empty($postPgsMetaData->bigcommerce_approved_review_count)) ? $postPgsMetaData->bigcommerce_approved_review_count[0] : NULL,
                ]; 
                
                PersonalisedGiftAppProductMeta::updateOrCreate(['personalised_gift_app_product_id' => $dbProductId], $savePgsProductMetaData);
            }

            // save category data 
            if(!empty($pgsProduct->category)){

                $postPgsCategoryData = $pgsProduct->category;
                if(!empty($postPgsCategoryData) && count($postPgsCategoryData) > 0){
                    foreach($postPgsCategoryData as $categoryData){

                        $savePgsCategoryData = [
                            'personalised_gift_app_user_id' => $user_id,
                            'shop_domain' => $shop_domain_name,
                            'term_id' => $categoryData->term_id,
                            'name' => $categoryData->name,
                            'slug' => $categoryData->slug,
                            'term_group' => $categoryData->term_group,
                            'term_taxonomy_id' => $categoryData->term_taxonomy_id,
                            'taxonomy' => $categoryData->taxonomy,
                            'description' => $categoryData->description,
                            'parent' => $categoryData->parent,
                            'count' => $categoryData->count,
                            'filter' => $categoryData->filter,
                            'background_image' => $categoryData->background_image,
                        ];  
                        
                        $categoryInfo = PersonalisedGiftAppCategory::updateOrCreate(['shop_domain' => $shop_domain_name,'term_id' => $categoryData->term_id, 'name' => $categoryData->name, 'slug' => $categoryData->slug], $savePgsCategoryData);

                        // save product category category data 
                        $productCategoryData = [
                            'personalised_gift_app_category_id' => $categoryInfo->id,
                            'personalised_gift_app_product_id' => $dbProductId,
                        ];

                        PersonalisedGiftAppCategoryProduct::updateOrCreate(['personalised_gift_app_category_id' => $categoryInfo->id,'personalised_gift_app_product_id' => $dbProductId], $productCategoryData);

                    }
                }
            }
            
            $userProductRange = PersonalisedGiftAppUserProductRanges::where('personalised_gift_app_user_id', $user_id)->where('product_range_type', $pgsProduct->listing_type)->first();
            if(!empty($userProductRange)){
                $totalProducts = $userProductRange->total_products+1;
                $userProductRange->update(['total_products' => $totalProducts]);
            }

            if($isUpdateProduct == 0){
                return [
                    'importStatus' => $importStatus,
                    'importCategoryStatus' => $importCategoryStatus,
                    'shop_domain_name' => $shop_domain_name,
                    'shopAccessToken' => $shopAccessToken,
                    'dbProductId' => $dbProductId,
                    'shopifySalesChannelId' => $shopifySalesChannelId,
                    'shopifyLocationId' => $shopifyLocationId,
                    'shopifyAuthSessionId' => $shopifyAuthSessionId,
                    'rangeType' => $rangeType,
                    'marginPrice' => $marginPrice,
                    'deductPrice' => $deductPrice,
                    'user_id' => $user_id
                ];
            }else{
                return null;
            }
        }else{
            return null;
        }
        
    }
    
    public static function updatePgsHookRequestProducts($pgsProduct)
    {
        $createDbProductData = [];
        if(!empty($pgsProduct->post)){
        
            $postPgsData = $pgsProduct->post;
            $product_images = NULL;
            $atp_images = NULL;
            $reselerPricingData = NULL;
            $productRrpPrice = 0.00;
            $productPgsPrice = 0.00;
            $shopify_category_taxonomy_id = NULL;
            $dbProductIds = [];
            $product_quantity = 0;
    
            if(isset($pgsProduct->reseller_pricing) && !empty($pgsProduct->reseller_pricing)){
                      
                if(!empty($pgsProduct->reseller_pricing->Images)){
                    $product_images = $pgsProduct->reseller_pricing->Images;
                }
    
                if(!empty($pgsProduct->reseller_pricing->ATP_Images)){
                    $atp_images = $pgsProduct->reseller_pricing->ATP_Images;
                }
                
                if(!empty($pgsProduct->reseller_pricing->Shopify_Category)){
                    $shopify_category_taxonomy_id = $pgsProduct->reseller_pricing->Shopify_Category;
                }
                
                $productPgsPrice = (!empty($pgsProduct->reseller_pricing->RRP)) ? trim($pgsProduct->reseller_pricing->RRP) : 0;
                $reselerPricingData = json_encode($pgsProduct->reseller_pricing);

                foreach($pgsProduct->reseller_pricing as $key => $val) {
                    if($key == 'Stock Level'){
                        if(!empty($val)){
                            $product_quantity = trim($val);
                        }
                    }
                }

            }

            $isUpdateProduct = 0;
            if(!empty($pgsProduct->customiser_data)){
                if(!empty($pgsProduct->customiser_data->product_type_cnc) && $pgsProduct->customiser_data->product_type_cnc == 'print'){
                    $isUpdateProduct = 1;
                }
            }
            
            if(empty($pgsProduct->reseller_pricing)){
                $isUpdateProduct = 1;
            }else{
                if(empty($pgsProduct->reseller_pricing->RRP)){
                    Log::channel('shopify-update-product')->info("check product reseller price -".$pgsProduct->reseller_pricing->RRP." for post id - ".$postPgsData->ID);
                    $isUpdateProduct = 1;
                }
            }            
            
            if(empty($pgsProduct->meta->_thumbnail_id[0])){
                $isUpdateProduct = 1;
            }
    
            $pgsAppProductData = [
                'post_id' => $postPgsData->ID,
                'post_author' => $postPgsData->post_author,
                'post_date' => $postPgsData->post_date,
                'post_date_gmt' => $postPgsData->post_date,
                'post_content' => $postPgsData->post_content,
                'post_title' => $postPgsData->post_title,
                'post_excerpt' => $postPgsData->post_excerpt,
                'post_status' => $postPgsData->post_status,
                'comment_status' => $postPgsData->comment_status,
                'ping_status' => $postPgsData->ping_status,
                'post_password' => $postPgsData->post_password,
                'post_name' => $postPgsData->post_name,
                'to_ping' => $postPgsData->to_ping,
                'pinged' => $postPgsData->pinged,
                'post_modified' => $postPgsData->post_modified,
                'post_modified_gmt' => $postPgsData->post_modified_gmt,
                'post_content_filtered' => $postPgsData->post_content_filtered,
                'post_parent' => $postPgsData->post_parent,
                'guid' => $postPgsData->guid,
                'menu_order' => $postPgsData->menu_order,
                'post_type' => $postPgsData->post_type,
                'post_mime_type' => $postPgsData->post_mime_type,
                'comment_count' => $postPgsData->comment_count,
                'filter' => $postPgsData->filter,
                'pgs_link' => $pgsProduct->pgs_link,
                'customiser_data' => (!empty($pgsProduct->customiser_data)) ? json_encode($pgsProduct->customiser_data) : NULL,
                'reseller_pricing' => $reselerPricingData,
                'extra_images' => $product_images,
                'atp_images' => $atp_images,
                'thumbnail_image' => $pgsProduct->thumbnail_image,
                'shopify_category_taxonomy_id' => $shopify_category_taxonomy_id,
                'listing_type' => (!empty($pgsProduct->listing_type)) ? $pgsProduct->listing_type : NULL,
                'is_publish_shopify_product' => $isUpdateProduct
            ];  
            
            $getPgsProductInfo = PersonalisedGiftAppProduct::where('post_id', $postPgsData->ID)->get();
            if(!empty($getPgsProductInfo) && $getPgsProductInfo->count() > 0){
                foreach($getPgsProductInfo as $productInfo){
                    $productInfo->update($pgsAppProductData);
                    $dbProductIds[] = $productInfo->id;
                }
            }else{
                // Create product code here for all shops
                $getUsers = PersonalisedGiftAppUser::whereRaw('FIND_IN_SET("'.$pgsProduct->listing_type.'",price_range_values)')->where('personalised_app_user_status', 1)->get();
                if(!empty($getUsers) && $getUsers->count() > 0){
                    foreach($getUsers as $getUser){
                        
                        $userId = $getUser->id;
                        $shopDomain = $getUser->shop_domain;
                        $priceOption = $getUser->pricing_options;
                        $marginPrice = $getUser->margin_change;
                        $deductPrice = $getUser->deduct_price_change;
                        $productRange = $getUser->price_range_values;
                        $importStatus = $getUser->import_all;
                        $importCategoryStatus = $getUser->import_category;

                        $shopAccessToken = $getUser->session->access_token;
                        $shopifyAuthSessionId = $getUser->shopify_auth_session_id;

                        $shopifyLocationId = '';
                        $shopifySalesChannelId = '';
                        if(!empty($getUser->store_location_id)){
                            $shopifyLocationId = $getUser->store_location_id;
                        }
                
                        if(!empty($getUser->store_sales_channel_id)){
                            $shopifySalesChannelId = $getUser->store_sales_channel_id;
                        }

                        $store_pgs_product_Data = CustomHelpers::storePgsCreateProductWebhookData($pgsProduct, $shopDomain, $userId, $priceOption, $marginPrice, $deductPrice, $productRange, $importStatus, $importCategoryStatus, $shopAccessToken, $shopifyLocationId, $shopifySalesChannelId, $shopifyAuthSessionId);  
                        
                        if(!empty($store_pgs_product_Data)){
                            $createDbProductData[] = $store_pgs_product_Data;
                        }
                        
                    }
                }

            }

            // save product meta data 
            if(!empty($pgsProduct->meta)){ 
                $checkProductMetas = PersonalisedGiftAppProductMeta::whereIn('personalised_gift_app_product_id', $dbProductIds)->get();
                if(!empty($checkProductMetas) && $checkProductMetas->count() > 0){

                    $postPgsMetaData = $pgsProduct->meta;
                    $savePgsProductMetaData = [
                        'pgs_product_price' => trim($productPgsPrice),
                        'product_quantity' => $product_quantity,
                        'bigcommerce_importer_version' => (!empty($postPgsMetaData->bigcommerce_importer_version)) ? $postPgsMetaData->bigcommerce_importer_version[0] : NULL,
                        'bigcommerce_id' => (!empty($postPgsMetaData->bigcommerce_id)) ? $postPgsMetaData->bigcommerce_id[0] : NULL,
                        'bigcommerce_sku' => (!empty($postPgsMetaData->bigcommerce_sku)) ? $postPgsMetaData->bigcommerce_sku[0] : NULL,
                        'bigcommerce_sku_normalized' => (!empty($postPgsMetaData->bigcommerce_sku_normalized)) ? $postPgsMetaData->bigcommerce_sku_normalized[0] : NULL,
                        'bigcommerce_rating' => (!empty($postPgsMetaData->bigcommerce_rating)) ? $postPgsMetaData->bigcommerce_rating[0] : NULL,
                        'bigcommerce_review_count' => (!empty($postPgsMetaData->bigcommerce_review_count)) ? $postPgsMetaData->bigcommerce_review_count[0] : NULL,
                        'bigcommerce_review_rating_sum' => (!empty($postPgsMetaData->bigcommerce_review_rating_sum)) ? $postPgsMetaData->bigcommerce_review_rating_sum[0] : NULL,
                        'bigcommerce_sales' => (!empty($postPgsMetaData->bigcommerce_sales)) ? $postPgsMetaData->bigcommerce_sales[0] : NULL,
                        'bigcommerce_calculated_price' => (!empty($postPgsMetaData->bigcommerce_calculated_price)) ? $postPgsMetaData->bigcommerce_calculated_price[0] : NULL,
                        'bigcommerce_inventory_level' => (!empty($postPgsMetaData->bigcommerce_inventory_level)) ? $postPgsMetaData->bigcommerce_inventory_level[0] : NULL,
                        'bigcommerce_price_range' => (!empty($postPgsMetaData->bigcommerce_price_range)) ? json_encode($postPgsMetaData->bigcommerce_price_range[0]) : NULL,
                        'bigcommerce_data_hash' => (!empty($postPgsMetaData->bigcommerce_data_hash)) ? $postPgsMetaData->bigcommerce_data_hash[0] : NULL,
                        'wp_old_date' => (!empty($postPgsMetaData->_wp_old_date)) ? $postPgsMetaData->_wp_old_date[0] : NULL,
                        'bigcommerce_source_data' => (!empty($postPgsMetaData->bigcommerce_source_data)) ? json_encode($postPgsMetaData->bigcommerce_source_data[0]) : NULL,
                        'bigcommerce_listing_data' => (!empty($postPgsMetaData->bigcommerce_listing_data)) ? json_encode($postPgsMetaData->bigcommerce_listing_data[0]) : NULL,
                        'bigcommerce_modifier_data' => (!empty($postPgsMetaData->bigcommerce_modifier_data)) ? json_encode($postPgsMetaData->bigcommerce_modifier_data[0]) : NULL,
                        'bigcommerce_options_data' => (!empty($postPgsMetaData->bigcommerce_options_data)) ? json_encode($postPgsMetaData->bigcommerce_options_data[0]) : NULL,
                        'bigcommerce_custom_fields' => (!empty($postPgsMetaData->bigcommerce_custom_fields)) ? json_encode($postPgsMetaData->bigcommerce_custom_fields[0]) : NULL,
                        'thumbnail_id' => (!empty($postPgsMetaData->_thumbnail_id)) ? $postPgsMetaData->_thumbnail_id[0] : NULL,
                        'bigcommerce_gallery' => (!empty($postPgsMetaData->bigcommerce_gallery)) ? json_encode($postPgsMetaData->bigcommerce_gallery[0]) : NULL,
                        'bigcommerce_variant_images' => (!empty($postPgsMetaData->bigcommerce_variant_images)) ? json_encode($postPgsMetaData->bigcommerce_variant_images[0]) : NULL,
                        'bigcommerce_reviews' => (!empty($postPgsMetaData->bigcommerce_reviews)) ? json_encode($postPgsMetaData->bigcommerce_reviews[0]) : NULL,
                        'bigcommerce_approved_review_count' => (!empty($postPgsMetaData->bigcommerce_approved_review_count)) ? $postPgsMetaData->bigcommerce_approved_review_count[0] : NULL,
                    ];

                    foreach($checkProductMetas as $productMeta){
                        $productMeta->update($savePgsProductMetaData);
                    }
                }
        
            }
        
            if(!empty($pgsProduct->category)){
        
                $postPgsCategoryData = $pgsProduct->category;
                if(!empty($postPgsCategoryData) && count($postPgsCategoryData) > 0){
                    foreach($postPgsCategoryData as $categoryData){
        
                        $savePgsCategoryData = [
                            'term_id' => $categoryData->term_id,
                            'name' => $categoryData->name,
                            'slug' => $categoryData->slug,
                            'term_group' => $categoryData->term_group,
                            'term_taxonomy_id' => $categoryData->term_taxonomy_id,
                            'taxonomy' => $categoryData->taxonomy,
                            'description' => $categoryData->description,
                            'parent' => $categoryData->parent,
                            'count' => $categoryData->count,
                            'filter' => $categoryData->filter,
                            'background_image' => $categoryData->background_image,
                        ];  
        
                        $categoryInfo = PersonalisedGiftAppCategory::where(['term_id' => $categoryData->term_id, 'name' => $categoryData->name, 'slug' => $categoryData->slug])->get();
                        if(!empty($categoryInfo) && $categoryInfo->count() > 0){
                            foreach($categoryInfo as $category){
                                
                                $category->update($savePgsCategoryData);
                                
                                if(!empty($dbProductIds) && count($dbProductIds) > 0){
                                    foreach($dbProductIds as $dbProductId){
        
                                        // save product category category data 
                                        $productCategoryData = [
                                            'personalised_gift_app_category_id' => $category->id,
                                            'personalised_gift_app_product_id' => $dbProductId,
                                        ];
                                        
                                        $checkCategoryProduct = PersonalisedGiftAppCategoryProduct::where(['personalised_gift_app_category_id' => $category->id,'personalised_gift_app_product_id' => $dbProductId])->first();
                                        if(empty($checkCategoryProduct)){
                                            PersonalisedGiftAppCategoryProduct::create($productCategoryData);
                                        }
                                    }
                                }                        
                            }
                        }
                    }
                }
            }

        }

        Log::channel('pgs-app-update-products')->info('pgs app updated products: '.json_encode($dbProductIds));
        Log::channel('pgs-app-update-products')->info('pgs app created products: '.json_encode($createDbProductData));

        CustomHelpers::updatePgsHookProductOnShopify($dbProductIds);
        CustomHelpers::createPgsHookProductOnShopify($createDbProductData);
        
        return true;
    }

    public static function createPgsHookProductOnShopify($createDbProductData)
    {
        if(!empty($createDbProductData)){
            foreach($createDbProductData as $productData){
                $checkProductStatus = PersonalisedGiftAppProduct::where('id', $productData['dbProductId'])->where('personalised_gift_app_user_id', $productData['user_id'])->where('is_job_process', 0)->first();
                
                if(!empty($checkProductStatus)){
                    if($productData['importStatus'] == 1){

                        $shopifyCollectionIds = [];
                        if($productData['importCategoryStatus'] == 1){
                            // create category on the shopify store
                            $shopifyCollectionIds = CustomHelper::createShopifyCollectionRequest($productData['shop_domain_name'], $productData['shopAccessToken'], $productData['dbProductId'], $productData['shopifySalesChannelId']);  
                        }
                
                        // create product on the shopify store
                        CustomHelper::createShopifyProductRequest($productData['shop_domain_name'], $productData['shopAccessToken'], $productData['dbProductId'], $productData['shopifyLocationId'], $productData['shopifySalesChannelId'], $productData['shopifyAuthSessionId'], $shopifyCollectionIds, $productData['rangeType'], $productData['marginPrice'], $productData['deductPrice'], $productData['importCategoryStatus'], $productData['user_id']); 
                        sleep(1);
                    }
                }
            }
        }
    }

    public static function updatePgsHookProductOnShopify($dbProductIds)
    {
        $pgs_image_url = $_ENV['EXTRA_PGS_IMAGET_SITE_URL'];
        $first_sku_pgs_image_url = $_ENV['PERSONALISED_GIFT_APP_FIRST_SKU_IMAGE_URL'];

        if(!empty($dbProductIds)){
            foreach($dbProductIds as $dbProductId){
                $checkPersonalisedProduct = PersonalisedGiftAppProduct::where('id', $dbProductId)->first();
                if(!empty($checkPersonalisedProduct)){

                    $userId = $checkPersonalisedProduct->personalised_gift_app_user_id;

                    // update product on shopify
                    $rangeType = '';
                    $marginPrice = '0.00';
                    $deductPrice = '0.00';
                    $importCategoryStatus = '0';
                    $importStatus = '0';
                    $shopifyAuthSessionId = '0';
                    $shopName = '';
                    $shopAccessToken = '';
                    $shopifyLocationId = '';
                    $shopifySalesChannelId = '';

                    if(!empty($checkPersonalisedProduct->personalisedGiftAppUser)){
                        $rangeType = $checkPersonalisedProduct->personalisedGiftAppUser->pricing_options;
                        $marginPrice = $checkPersonalisedProduct->personalisedGiftAppUser->margin_change;
                        $deductPrice = $checkPersonalisedProduct->personalisedGiftAppUser->deduct_price_change;
                        $importCategoryStatus = $checkPersonalisedProduct->personalisedGiftAppUser->import_category;
                        $importStatus = $checkPersonalisedProduct->personalisedGiftAppUser->import_all;
                        $shopifyAuthSessionId = $checkPersonalisedProduct->personalisedGiftAppUser->shopify_auth_session_id;
                        $shopName = $checkPersonalisedProduct->personalisedGiftAppUser->shop_domain;
                        $shopAccessToken = $checkPersonalisedProduct->personalisedGiftAppUser->shopify_auth_token;
                        $shopifyLocationId = $checkPersonalisedProduct->personalisedGiftAppUser->store_location_id;
                        $shopifySalesChannelId = $checkPersonalisedProduct->personalisedGiftAppUser->store_sales_channel_id;
                    }

                    if(empty($checkPersonalisedProduct->shopify_graph_ql_id)){
                        
                        if($checkPersonalisedProduct->is_publish_shopify_product == 0){

                            $createDbProductData[] = [
                                'importStatus' => $importStatus,
                                'importCategoryStatus' => $importCategoryStatus,
                                'shop_domain_name' => $shopName,
                                'shopAccessToken' => $shopAccessToken,
                                'dbProductId' => $checkPersonalisedProduct->id,
                                'shopifySalesChannelId' => $shopifySalesChannelId,
                                'shopifyLocationId' => $shopifyLocationId,
                                'shopifyAuthSessionId' => $shopifyAuthSessionId,
                                'rangeType' => $rangeType,
                                'marginPrice' => $marginPrice,
                                'deductPrice' => $deductPrice,
                                'user_id' => $userId
                            ];

                            CustomHelpers::createPgsHookProductOnShopify($createDbProductData);
                        }

                    }else{

                        if($checkPersonalisedProduct->is_publish_shopify_product == 0){

                            $productTitle = $checkPersonalisedProduct->post_title;

                            $productSku = '';
                            $productPrice = 0.00;
                            $inventoryQty = 0;
                            $pgsProductPrice = 0.00;
                            
                            $skuData = (!empty($checkPersonalisedProduct->reseller_pricing)) ? json_decode($checkPersonalisedProduct->reseller_pricing) : '';
                            if(isset($checkPersonalisedProduct->personalisedGiftAppProductMeta) && !empty($checkPersonalisedProduct->personalisedGiftAppProductMeta)){
                                
                                $productSku = trim($checkPersonalisedProduct->personalisedGiftAppProductMeta->bigcommerce_sku);
                                
                                $productPrice = CustomHelper::getProductRegularPrice($skuData, $rangeType, $marginPrice, $deductPrice);

                                $pgsProductPrice = $checkPersonalisedProduct->personalisedGiftAppProductMeta->pgs_product_price;
                                
                                $inventoryQty = $checkPersonalisedProduct->personalisedGiftAppProductMeta->product_quantity;
                            }

                            $pgsMetaInfo = PersonalisedGiftAppProductMeta::where('personalised_gift_app_product_id', $checkPersonalisedProduct->id)->first();
                            if(!empty($pgsMetaInfo)){
                                $pgsMetaInfo->update(['product_rrp_price' => trim($productPrice)]);
                            }
        
                            $first_image_external_link = $first_sku_pgs_image_url."".$productSku.".jpg";

                            $shopifyPCollectionIds = [];
                            $getProductColections = PersonalisedGiftAppCategoryProduct::where('personalised_gift_app_product_id', $dbProductId)->get();
                            if(!empty($getProductColections) && $getProductColections->count() > 0){
                                foreach($getProductColections as $getProductColection){
                                    $shopifyPCollectionIds[] = $getProductColection->personalisedGiftAppCategory->shopify_graph_ql_id;
                                }
                            }

                            $variantsArray = [
                                'id' => $checkPersonalisedProduct->shopify_product_variant_id,
                                'sku' => $productSku,
                                'inventoryManagement' => 'SHOPIFY',
                                'inventoryPolicy' => 'DENY',
                                'inventoryQuantities' => [
                                    'availableQuantity' => (int) $inventoryQty,
                                    'locationId' => $shopifyLocationId
                                ]
                            ];
        
                            if($rangeType != 'set_own_price'){
                                if($productPrice > 0){
                                    $variantsArray['price'] = number_format($productPrice, 2);
                                }   
                                                             
                                Log::channel('update-shopify-product-price')->info('update shopify product price for range type : '.$rangeType.' and the shopify product id is - '.$checkPersonalisedProduct->shopify_product_id.' and update product price from update and create product webhook request and product price is - '.number_format($productPrice, 2));
                            }

                            $metafieldsData = [];
                            if(!empty($checkPersonalisedProduct->customiser_data)){
                                $metafieldsData[0] = [
                                    'key' => 'customiserData',
                                    'namespace' => 'custom',
                                    'type' => 'json',
                                    'value' => $checkPersonalisedProduct->customiser_data
                                ];
                            
                                $customiserDataMetafield = CustomHelpers::checkProductShopifyMetafieldId($checkPersonalisedProduct->shopify_graph_ql_id, 'customiserData');
                                if(!empty($customiserDataMetafield)){
                                    $metafieldsData[0]['id'] = $customiserDataMetafield;
                                }	
                            }
                            
                            if(!empty($checkPersonalisedProduct->reseller_pricing)){
                                $metafieldsData[1] = [
                                    'key' => 'resellerPricing',
                                    'namespace' => 'custom',
                                    'type' => 'json',
                                    'value' => $checkPersonalisedProduct->reseller_pricing
                                ];
                            
                                $resellerPricingMetafield = CustomHelpers::checkProductShopifyMetafieldId($checkPersonalisedProduct->shopify_graph_ql_id, 'resellerPricing');
                                if(!empty($resellerPricingMetafield)){
                                    $metafieldsData[1]['id'] = $resellerPricingMetafield;
                                }	
                            }
        
                            $sendProductArray = [
                                'id' => $checkPersonalisedProduct->shopify_graph_ql_id,
                                'title' => $productTitle,
                                'descriptionHtml' => $checkPersonalisedProduct->post_content,
                                'variants' => [
                                    $variantsArray
                                ]
                            ];

                            if(!empty($metafieldsData)){
                                $sendProductArray['metafields'] = array_values($metafieldsData);
                            }
                            
                            if(!empty($checkPersonalisedProduct->customiser_data)){
                                $sendProductArray['tags'] = ['Personalised'];
                            }
                            
                            if(!empty($checkPersonalisedProduct->shopify_category_taxonomy_id) && $importCategoryStatus == 1){
                                $sendProductArray['productCategory']['productTaxonomyNodeId'] = "gid://shopify/ProductTaxonomyNode/".$checkPersonalisedProduct->shopify_category_taxonomy_id;
                            }
                    
                            $imagesArray = [];
                            $checkImage = CustomHelpers::isImageLinkValid($first_image_external_link);
                        
                            if($checkImage){
                                $imagesArray[] = $first_image_external_link;
                                Log::channel('shopify-update-product')->info("Check Image url is valid for product id -".$checkPersonalisedProduct->id." and images - ".$first_image_external_link);
                            }else{
                                Log::channel('shopify-update-product')->info("Check Image url is not valid for product id -".$checkPersonalisedProduct->id." and images - ".$first_image_external_link);
                            }
                            
                            if(!empty($checkPersonalisedProduct->extra_images)){
                                $explodeImages = explode(",", $checkPersonalisedProduct->extra_images);
                                if(!empty($explodeImages) && count($explodeImages) > 0){
                                    foreach($explodeImages as $image){
                                        $imagesArray[] = $pgs_image_url.''.$image;
                                    }
                                }
                            }
                    
                            $sendShopifyImageAray = [];
                            if(!empty($imagesArray) && count($imagesArray) > 0){
                                foreach($imagesArray as $key => $imgrecord){
                                    $sendShopifyImageAray[$key]['src'] = $imgrecord;
                                    $sendShopifyImageAray[$key]['altText'] = $productTitle." Image ".$key+1;
                                }
                            }
                    
                            if(!empty($sendShopifyImageAray)){
                                $sendProductArray['images'] = $sendShopifyImageAray;
                            }
                    
                            if(!empty($shopifyPCollectionIds)){
                                $sendProductArray['collectionsToJoin'] = $shopifyPCollectionIds;
                            }
        
                            Log::channel('shopify-update-product')->info("Update Product Request Data -".json_encode($sendProductArray));
                            $productResponse = ProductCreator::callUpdateCustomProducts($shopName, $shopAccessToken, $sendProductArray);
                            $proType = 'productUpdate';          
                    
                            Log::channel('shopify-update-product')->info("Update Product Response Data -".json_encode($productResponse));
                    
                            if(!empty($productResponse)){
                    
                                if(!empty($productResponse->data->$proType->product)){
                                    $shopifyProductStatus = $productResponse->data->$proType->product->status;
                                    
                                    // update inventory cost per item price
                                    if($rangeType != 'set_own_price'){

                                        $inventoryItemId = $checkPersonalisedProduct->shopify_product_inventory_item_id;

                                        if(!empty($inventoryItemId)){

                                            CustomHelpers::updateShopifyProductInventoryCostPrice($shopName, $shopAccessToken, $inventoryItemId, $productPrice, $dbProductId);
                                        }
                                    }

                                    // store metafields data
                                    if(!empty($productResponse->data->$proType->product->metafields)){
                    
                                        foreach($productResponse->data->$proType->product->metafields->edges as $metafield){
                    
                                            $metaData = $metafield->node;
                    
                                            $checkProductMetafields = ShopifyMetafield::where([
                                                'personalised_gift_app_user_id' => $userId,
                                                'resource_id' => $checkPersonalisedProduct->id,
                                                'resource_type' => 'product',
                                                'metafield_key' => $metaData->key,
                                                'metafield_namespace' => $metaData->namespace,
                                                'metafield_id' => $metaData->id,
                                                'metafield_type' => $metaData->type,
                                                'owner_id' => $checkPersonalisedProduct->shopify_graph_ql_id,
                                            ])->first();
                    
                                            if(!empty($checkProductMetafields)){
                    
                                                $updateMetaData = [
                                                    'personalised_gift_app_user_id' => $userId,
                                                    'resource_id' => $checkPersonalisedProduct->id,
                                                    'resource_type' => 'product',
                                                    'metafield_id' => $metaData->id,
                                                    'metafield_key' => $metaData->key,
                                                    'metafield_namespace' => $metaData->namespace,
                                                    'metafield_type' => $metaData->type,
                                                    'metafield_value' => $metaData->value,
                                                    'owner_id' => $checkPersonalisedProduct->shopify_graph_ql_id,
                                                ];
                                                
                                                $checkProductMetafields->update($updateMetaData);
                                            }
                                        }
                                    }
                                    $checkPersonalisedProduct->update(['shopify_product_status' => $shopifyProductStatus]);
                                }            
                            }

                        }else{

                            // delete product from shopify store
                            if(!empty($checkPersonalisedProduct->shopify_graph_ql_id)){

                                $shopifyGraphQlProductId = [
                                    'id' => $checkPersonalisedProduct->shopify_graph_ql_id
                                ];
                                ProductCreator::callDeleteShopifyProduct($shopName, $shopAccessToken, $shopifyGraphQlProductId); 
                            }

                        }

                    }

                }
            }
        }

        return true;
    }

    public static function checkProductShopifyMetafieldId($ownerId, $metakey)
    {
        $metafieldId = '';
        $metafieldInfo = ShopifyMetafield::where('owner_id', $ownerId)->where('metafield_key', $metakey)->first();
        if(!empty($metafieldInfo)){
            $metafieldId = $metafieldInfo->metafield_id;
        }

        return $metafieldId;
    }
    
    public static function updateShopifyProductPrice($shopName, $shopAccessToken, $dbProductId, $productPrice)
    {
        $persolaisedProduct = PersonalisedGiftAppProduct::where('id', $dbProductId)->whereNotNull('shopify_graph_ql_id')->whereNotNull('shopify_product_variant_id')->first();
        if(!empty($persolaisedProduct)){
            
            $shopifyVariantId = $persolaisedProduct->shopify_product_variant_id;

            $inventoryItemId = $persolaisedProduct->shopify_product_inventory_item_id;
            
            $variantArray = [
                'id' => $shopifyVariantId,
                'price' => number_format($productPrice, 2)
            ];
    
            Log::channel('automatic-update-shopify-product-price')->info("Update variant Request Data -".json_encode($variantArray));

            $productInventoryResponse = ProductCreator::updateProductVariantPrice($shopName, $shopAccessToken, $variantArray);

            // update inventory cost per item price
            if(!empty($inventoryItemId)){

                $pgsProductPrice = (isset($persolaisedProduct->personalisedGiftAppProductMeta) && !empty($persolaisedProduct->personalisedGiftAppProductMeta)) ? $persolaisedProduct->personalisedGiftAppProductMeta->pgs_product_price : 0.00;

                CustomHelpers::updateShopifyProductInventoryCostPrice($shopName, $shopAccessToken, $inventoryItemId, $productPrice, $dbProductId);
            }
        }
        
        return true;
    }

    public static function updateShopifyProductInventoryCostPrice($shopName, $shopAccessToken, $inventoryItemId, $productPrice, $dbProductId)
    {
        $productDropshipPrice = CustomHelpers::getProductDropShipPrice($dbProductId);   
        if($productDropshipPrice > 0){
            
            $inventoryArray = [
                'cost' => number_format($productDropshipPrice, 2),
                'tracked' => true,
                'countryCodeOfOrigin' => 'US'
            ];

            Log::channel('automatic-update-shopify-inventory-cost-price')->info("Update inventory cost request data -".json_encode($inventoryArray));

            $productInventoryResponse = ProductCreator::updateInventoryItemCostPrice($shopName, $shopAccessToken, $inventoryArray, $inventoryItemId);

            Log::channel('automatic-update-shopify-inventory-cost-price')->info("Update inventory cost response data -".json_encode($productInventoryResponse));
        }
        
        return true;
    }
    
    public static function syncPgsAppProducts($apikey, $username, $shopName)
    {
        $shopData = PersonalisedGiftAppUser::where('shop_domain', $shopName)->first();

        if(!empty($shopData->price_range_values)){
            
            //$totalProduct = $shopData->total_pgs_products;
            $decodeRanges = explode(",", $shopData->price_range_values);
            $total_page_limit = $shopData->total_pgs_product_page_limit;
            
            if(!empty($decodeRanges) && count($decodeRanges) > 0){
                //$totalProduct  = PersonalisedGiftAppUserProductRanges::where('personalised_gift_app_user_id', $shopData->id)->whereIn('product_range_type', $decodeRanges)->sum('total_products');
                $total_page_limit = PersonalisedGiftAppUserProductRanges::where('personalised_gift_app_user_id', $shopData->id)->whereIn('product_range_type', $decodeRanges)->sum('total_page_limit');
            }
        }
        
        /* $syncingLimit = 30;
        $startLimit = 1;
        $details['shop_domain'] = $shopName;
        $details['shopify_auth_session_id'] = $shopData->shopify_auth_session_id;
        $details['apikey'] = $apikey;
        $details['username'] = $username;
        $details['sync_limit'] = $syncingLimit;
        $details['lastpage'] = $startLimit;
        $details['totalpage'] = $total_page_limit;
        $details['price_range_values'] = $shopData->price_range_values;
        
        AutomaticSyncPgsProductJob::dispatch($details)->onQueue('sync_pgs_new_products'); */
        
        $totalSyncingCount = $total_page_limit/30;
        $fractionalPart = fmod($totalSyncingCount, 1);

        if ($fractionalPart > 0) {
            // Value has a fractional part, add 1 to the last digit
            $totalSyncingCount = ceil($totalSyncingCount);
        }
        
        $startLimit = 1;
        if($total_page_limit < 30){
            $syncingLimit = $total_page_limit;
        }else{
            $syncingLimit = 30;
        }
        
        for ($i = 1; $i <= $totalSyncingCount; $i++) {
            
            $details['shop_domain'] = $shopName;
            $details['shopify_auth_session_id'] = $shopData->shopify_auth_session_id;
            $details['apikey'] = $apikey;
            $details['username'] = $username;
            $details['sync_limit'] = $syncingLimit;
            $details['lastpage'] = $startLimit;
            $details['totalpage'] = $total_page_limit;
            $details['sync_count'] = $i;
            $details['total_sync_count'] = $totalSyncingCount;
            $details['price_range_values'] = $shopData->price_range_values;
            
            $startLimit = $startLimit+30;
            $syncingLimit = $syncingLimit+30;
            
            AutomaticSyncPgsProductJob::dispatch($details)->onQueue('sync_pgs_new_products');
        }
        
        return true;
    }

    public static function storeShopifyMandatoryWebhookRequest($webhookType, $requestData)
    {
        if(!empty($requestData)){

			$data = json_encode($requestData);
			$shop_id = $requestData['shop_id'];
			$shop_domain = $requestData['shop_domain'];

			$updateRecordData = [
                'response_data' => json_encode($data),
                'shop_id' => $shop_id,
                'shop_domain' => $shop_domain,
                'webhook_type' => $webhookType
            ];
            MandatoryShopifyWebhook::create($updateRecordData);
		}
        return true;
    }
    
    public static function getShopRunningJobStatus($shop_domain)
    {
        $jobStaus = 0;
        // check delete product Job
        $deleteProductJob = DeletedHookProduct::where('shop_domain', $shop_domain)->where('is_updated', 0)->get();
        if(!empty($deleteProductJob) && $deleteProductJob->count() > 0){
            $jobStaus = 1;
        }
        
        // check hook order Job
        $hookOrderJob = HookOrder::where('shop_domain', $shop_domain)->where('is_updated', 0)->get();
        if(!empty($hookOrderJob) && $hookOrderJob->count() > 0){
            $jobStaus = 1;
        }
        
        // check automated jobs
        $automatedJob = Job::where('shop_domain', $shop_domain)->get();
        if(!empty($automatedJob) && $automatedJob->count() > 0){
            $jobStaus = 1;
        }
        
        return $jobStaus;
    }

    public static function getProductDropShipPrice($productId)
    {
        $dropship_for_1 = 0.00;
        $pgsProductInfo = PersonalisedGiftAppProduct::where('id', $productId)->first();
        if(!empty($pgsProductInfo->reseller_pricing)){
            $valueArray = json_decode($pgsProductInfo->reseller_pricing);
            if(!empty($valueArray)){
                foreach($valueArray as $key => $val) {
                    if($key == 'Dropship For 1'){
                        if(!empty($val)){
                            $dropship_for_1 = trim($val);
                        }
                    }
                }
            }
        }
        return $dropship_for_1;
    }

    public static function sendOrderFulfillmentRequest($shopName, $shopifyGraphQlFulfillOrderId, $shopAccessToken, $dbOrderId)
    {
        $SHOPIFY_VERSION = $_ENV['SHOPIFY_VERSION'];
        $fulfillmentRequestData  = [
                            "fulfillment_request" => [
                                "message" => "Fulfill this ASAP please.",
                            ]
                        ];

        $SHOPIFY_FULFILLMENT_REQUEST_API = "https://$shopName/admin/api/$SHOPIFY_VERSION/fulfillment_orders/$shopifyGraphQlFulfillOrderId/fulfillment_request.json";

        $request_response = PersonalisedAppTrait::callCurlShopifyRestAPI($SHOPIFY_FULFILLMENT_REQUEST_API, "POST", $fulfillmentRequestData, $shopAccessToken);

        $requestResponse = json_decode($request_response);

        Log::channel('shopify-fulfillment-request')->info("Create Fulfillment Request Response Data -".json_encode($requestResponse));

        if(!empty($requestResponse)){
           
           if (!empty($requestResponse) && !empty($requestResponse->errors)) {

                Log::channel('shopify-fulfillment-request')->info("Create Fulfillment Request Error Response Data -".json_encode($requestResponse->errors));

            } else {

                $updateOriginalOrderData = NULL;
                $submitedOrderData = NULL;
                $unSubmitedOrderData = NULL;

                if(!empty($requestResponse->original_fulfillment_order)){
                    $updateOriginalOrderData = json_encode($requestResponse->original_fulfillment_order);
                }

                if(!empty($requestResponse->submitted_fulfillment_order)){
                    $submitedOrderData = json_encode($requestResponse->submitted_fulfillment_order);
                }

                if(!empty($requestResponse->unsubmitted_fulfillment_order)){
                    $unSubmitedOrderData = json_encode($requestResponse->unsubmitted_fulfillment_order);
                }

                ShopifyStoreOrder::where('id', $dbOrderId)->update([
                    'original_fulfillment_order' => $updateOriginalOrderData,
                    'submitted_fulfillment_order' => $submitedOrderData,
                    'unsubmitted_fulfillment_order' => $unSubmitedOrderData
                ]);
            }
        }

        return true;
    }

    public static function acceptOrderFulfillmentRequest($shopName, $shopifyGraphQlFulfillOrderId, $shopAccessToken, $dbOrderId)
    {
        $SHOPIFY_VERSION = $_ENV['SHOPIFY_VERSION'];
        $fulfillmentRequestData  = [
                            "fulfillment_request" => [
                                "message" => "We will start processing your fulfillment request",
                            ]
                        ];

        $SHOPIFY_FULFILLMENT_ACCEPT_REQUEST_API = "https://$shopName/admin/api/$SHOPIFY_VERSION/fulfillment_orders/$shopifyGraphQlFulfillOrderId/fulfillment_request/accept.json";

        $accepted_request_response = PersonalisedAppTrait::callCurlShopifyRestAPI($SHOPIFY_FULFILLMENT_ACCEPT_REQUEST_API, "POST", $fulfillmentRequestData, $shopAccessToken);

        $acceptRequestResponse = json_decode($accepted_request_response);

        Log::channel('shopify-fulfillment-request')->info("Create Fulfillment Accept Request Response Data -".json_encode($acceptRequestResponse));

        if(!empty($acceptRequestResponse)){
           
           if (!empty($acceptRequestResponse) && !empty($acceptRequestResponse->errors)) {

                Log::channel('shopify-fulfillment-request')->info("Create Fulfillment Accept Request Error Response Data -".json_encode($acceptRequestResponse->errors));

            } else {

                $store_shopify_accept_fulfillment_request_data = $acceptRequestResponse->fulfillment_order;
                if(!empty($store_shopify_accept_fulfillment_request_data)){

                    ShopifyStoreOrder::where('id', $dbOrderId)->update(['accept_fulfillment_request_order_response' => json_encode($store_shopify_accept_fulfillment_request_data)]);
                }
            }
        }
        return true;
    }
    
}

