<?php

namespace App\Http\Controllers;

use App\Http\Helpers\CustomHelpers;
use Illuminate\Http\Request;
use Mail, Log;
use CustomHelper;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Redirect;
use App\Models\User;
use App\Lib\ProductCreator;
use App\Models\PersonalisedGiftAppUser;
use App\Models\PersonalisedGiftAppFont;
use App\Models\ValidProductImage;
use App\Traits\PersonalisedAppTrait;
use App\Models\PersonalisedGiftAppProduct;
use App\Models\PersonalisedGiftAppProductMeta;
use App\Models\PersonalisedGiftAppUserProductRanges;

class FrontController extends Controller
{
    use PersonalisedAppTrait;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return redirect('/');
    }

    public function verifyUserEmail($email,$user_id)
    {
        $decrypted_email = Crypt::decryptString($email);
        $decrypted_user_id = Crypt::decryptString($user_id);
        
        $user = User::where('id', $decrypted_user_id)->first();
        if(!empty($user)){
            $user->update(['email' => $decrypted_email]);
        }
        return redirect('login')->with('success', 'The user email is verified.');
    }

    public function checkPgsProductImages(Request $request)
    {
        $pgs_third_party_api_url = $_ENV['PERSONALISED_GIFT_APP_API_URL'];
        $pgs_third_party_product_api_url = $_ENV['PERSONALISED_GIFT_APP_PRODUCT_API_URL'];
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', 2)->first();
        
        $range_type = 'personalised_products';
        if(!empty($shopInfo) && $shopInfo->personalised_app_user_status == 1){
            
            $username = $shopInfo->username;
            $apikey = $shopInfo->api_key;  
            $lastPage = $shopInfo->last_sync_page;  
            
            $maxrrp = '10000';
            $totalSyncingCount = 300;
            $range_type =  $shopInfo->price_range_values;
            $range_type = 'personalised_products';

            // $pgs_product_response = $this->callPersonalisedAppAPI($pgs_third_party_api_url."product/count", "GET", $apikey, $username, "");

            for($i = 201; $i <= $totalSyncingCount; $i++){
                $pgs_product_response = $this->callPersonalisedAppAPI($pgs_third_party_product_api_url."all_products/?page=$i&size=10&range_type=$range_type&max_rrp=$maxrrp", "GET", $apikey, $username, "");
    
                $totalPgsProducts = json_decode($pgs_product_response);
                
                if(!empty($totalPgsProducts->data)){
                    
                    $pgsProducts = $totalPgsProducts->data->product;
                    $printedProducts = [];
                    $imagesError = [];
                    $resellingError = [];
                    if(!empty($pgsProducts)){
                        foreach($pgsProducts as $pgsProduct){
                            $isUpdateProduct = 0;
                            if(!empty($pgsProduct->customiser_data)){
                                $personalisedData = $pgsProduct->customiser_data;
                                if(isset($personalisedData->product_type_cnc) && $personalisedData->product_type_cnc == 'print'){
                                    $printedProducts[] = $pgsProduct->post->ID;
                                }
                            }
                            
                            if(!empty($pgsProduct->reseller_pricing)){
                                $resellingError[] = $pgsProduct->post->ID;
                            }
                            
                            if((isset($pgsProduct->meta->thumbnail_id) && $pgsProduct->meta->thumbnail_id == '')){
                                $imagesError[] = $pgsProduct->post->ID;
                            }
                        }
                    }
                    
                    if(!empty($printedProducts)){
                        echo '<pre> printed error'; print_r($printedProducts);
                    }
                    
                    if(!empty($imagesError)){
                        echo '<pre> image error '; print_r($imagesError);
                    }
                    
                    if(!empty($resellingError)){
                        echo '<pre> reseller error '; print_r($resellingError);
                    }
                    /* $totalPageProduct = (int)$totalPgsProducts->data->total_page;
    
                    if($totalPageProduct > 0){
    
                        $countProduct = ($totalPageProduct - 1)*10;
                        $shopInfo->update(['total_pgs_products' => $countProduct]);
    
                        $last_page_pgs_product_response = $this->callPersonalisedAppAPI($pgs_third_party_product_api_url."all_products/?page=$totalPageProduct&size=10&range_type=$range_type&max_rrp=$maxrrp", "GET", $apikey, $username, "");
                        
                        $decodedLastPagePgsProducts = json_decode($last_page_pgs_product_response);
    
                        if(!empty($decodedLastPagePgsProducts->data->product)){
                            
                            $lastpageTotalProduct = $countProduct + count($decodedLastPagePgsProducts->data->product);
                            $shopInfo->update(['total_pgs_products' => $lastpageTotalProduct]);
    
                            if($lastPage <= $totalPageProduct){
    
                                $perPage = 1;
                                if($lastPage > 0){
                                    $perPage = $lastPage+1;
                                }
            
                                for ($i = $perPage; $i <= $totalPageProduct; $i++) {
                                    
                                    echo $i.'<br>';
                                    // $this->updatePgsProducts($i, $apikey, $username, $range_type, $maxrrp);
                                    // $shopInfo->update(['last_sync_page' => $i]);
                                }
                            }
    
    
                        }
                    }    */            
                }
            }
            dd('tets');
        }
        
        
        
    }

    private function updatePgsProducts($page, $apikey, $username, $range_type, $maxrrp)
    {
        $pgs_third_party_api_url = $_ENV['PERSONALISED_GIFT_APP_API_URL'];
        $pgs_third_party_product_api_url = $_ENV['PERSONALISED_GIFT_APP_PRODUCT_API_URL'];
        $pgs_product_response = $this->callPersonalisedAppAPI($pgs_third_party_product_api_url."all_products/?page=$page&size=10&range_type=$range_type&max_rrp=$maxrrp", "GET", $apikey, $username, "");
        
        $decodedPgsProducts = json_decode($pgs_product_response);

        // $shopInfo = PersonalisedGiftAppUser::where('username', $username)->where('api_key', $apikey)->first();
        // $shop_domain_name = NULL;
        // $shop_db_id = NULL;
        // if(!empty($shopInfo)){
        //     $shop_domain_name = (isset($shopInfo->session) && !empty($shopInfo->session)) ? $shopInfo->session->shop : NULL;
        //     $shop_db_id = $shopInfo->shopify_auth_session_id;
        // }

        $pgs_image_url = $_ENV['EXTRA_PGS_IMAGET_SITE_URL'];
        if(!empty($decodedPgsProducts) && $decodedPgsProducts->statusCode == 200 && $decodedPgsProducts->success == 'true' && !empty($decodedPgsProducts->data)){

            $productData = $decodedPgsProducts->data->product;
            foreach($productData as $product){
                if(!empty($product->reseller_pricing)){

                    $external_link = CustomHelper::isImageLinkValid("https://personalisedgiftsupply.com/wp-content/uploads/Images/PlainImages/".$product->reseller_pricing->SKU.".jpg");
                    
                    if ($external_link) {

                        ValidProductImage::create([
                            'sku' => $product->reseller_pricing->SKU,
                            'image' => 'sku image',
                            'status' => 'valid',
                            'image_type' => 'sku_image'
                        ]);

                    } else {

                        ValidProductImage::create([
                            'sku' => $product->reseller_pricing->SKU,
                            'image' => 'sku image',
                            'status' => 'not_valid',
                            'image_type' => 'sku_image'
                        ]);
                    }

                    if(!empty($product->reseller_pricing->Images)){
                        $imageArray = explode(",", $product->reseller_pricing->Images);
                        if(!empty($imageArray) && count($imageArray) > 0){
                            foreach($imageArray as $img){

                                if (CustomHelper::isImageLinkValid($pgs_image_url.''.$img)) {
    
                                    ValidProductImage::create([
                                        'sku' => $product->reseller_pricing->SKU,
                                        'image' => $img,
                                        'status' => 'valid',
                                        'image_type' => 'image_array'
                                    ]);
                                } else {

                                    ValidProductImage::create([
                                        'sku' => $product->reseller_pricing->SKU,
                                        'image' => $img,
                                        'status' => 'not_valid',
                                        'image_type' => 'image_array'
                                    ]);
                                }
                            }
                        }
                    }
                }
            }
            // store products data
            // $store_pgs_product_data = $this->savePgsProductData($productData, $shop_domain_name, $shop_db_id);
        }   

        return true;
    }

    public function createShopifyFontFiles(Request $request)
    {
        dd('tets');
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', 8)->first();
        if(!empty($shopInfo)){

            $shopName = $shopInfo->session->shop;
            $shopAccessToken = $shopInfo->session->access_token;

            $fonts = PersonalisedGiftAppFont::whereNull('shopify_file_id')->get();
            if(!empty($fonts) && $fonts->count() > 0){
                foreach($fonts as $font){
                    $filesArray = [
                        'originalSource' => $font->font_file,
                        'contentType' => 'FILE',
                        'alt' => "Json File",
                    ]; // for add files
                    
                    $productInventoryResponse = ProductCreator::callCreateShopifyFiles($shopName, $shopAccessToken, $filesArray);
                    dd($productInventoryResponse);
                }
            }
        }          
    }
    
    public function checkDuplicateProducts(Request $request)
    {
        $shopName = 'quick-start-957754ea.myshopify.com';
        $shopAccessToken = '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';
        $duplicateProducts = [];
        $not_delete_product = array("3819","3486","3485");
        dd('tets');
        $products = PersonalisedGiftAppProduct::where('shopify_auth_session_id', 8)->whereNotIn('id', $not_delete_product)->whereNotNull('shopify_product_id')->limit(200)->get();
        if(!empty($products) && $products->count() > 0){
            foreach($products as $product){
                
                $shopifyGraphQlProductId = [
                    "input" => [
                        "id" => "gid://shopify/Product/".$product->shopify_product_id    
                    ]    
                ];
                
                ProductCreator::callDeleteShopifyProduct($shopName, $shopAccessToken, $shopifyGraphQlProductId); 
                
                $updateData = [
                    'shopify_product_id' => NULL,
                    'shopify_product_handle' => NULL,
                    'shopify_product_variant_id' => NULL,
                    'shopify_product_inventory_item_id' => NULL,
                    'shopify_graph_ql_id' => NULL,
                    'shopify_edit_product_link' => NULL,
                    'shopify_preview_product_link' => NULL,
                ];
                
                $product->update($updateData);
                // $productTitle = str_replace("'", "", $product->post_title);
                // $productSku = $product->personalisedGiftAppProductMeta->bigcommerce_sku;
                // $queryString = "title:'$product->post_title'";
                // // dd($queryString);
                // $checkProductResponse = ProductCreator::checkShopifyStoreExistDuplicateProduct($shopName, $shopAccessToken, $queryString);
                // if(!empty($checkProductResponse->data->products->edges) && count($checkProductResponse->data->products->edges) > 1){
                //     foreach($checkProductResponse->data->products->edges as $node){
                //         $productid = str_replace("gid://shopify/Product/", "", $node->node->id);
                //         if($productid != $product->shopify_product_id){
                //             $duplicateProducts[] = $productid;
                //         }
                //     }
                    
                // }
            }
            dd('Compleet');
        }
    }
    
    public function checkPgsProductTestImages(Request $request)
    {
        // $valid = [];
        // $notValid = [];
        // $images = ['https://personalisedgiftsupply.com/wp-content/uploads/Images/PlainImages/CNC-SED01-005530.jpg','https://personalisedgiftsupply.com/wp-content/uploads/Images/PlainImages/CNC-SED01-004510.1.jpg','https://personalisedgiftsupply.com/wp-content/uploads/Images/PlainImages/CNC-SED01-005530.jpg','https://personalisedgiftsupply.com/wp-content/uploads/Images/PlainImages/CNC-SED01-004555.1.jpg','https://www.google.com/'];
        // if(!empty($images)){
        //     foreach($images as $image){
        //         $external_link = CustomHelper::isImageLinkValid($image);
        //         if($external_link){
        //             $valid[] = $image;
        //         }else{
        //             $notValid[] = $image;
        //         }
        //     }
        // }
        
        // echo '<pre>'; print_r($valid);
        // dd($notValid);
        
        Log::channel('check-cron-products')->info('Start cron job call start time: '.date("H:i:s"));
        $pgs_third_party_api_url = $_ENV['PERSONALISED_GIFT_APP_API_URL'];
        $pgs_third_party_product_api_url = $_ENV['PERSONALISED_GIFT_APP_PRODUCT_API_URL'];
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', 2)->first();
        $maxrrp = 10000;
        
        $username = $shopInfo->username;
        $apikey = $shopInfo->api_key;  
        $lastPage = $shopInfo->last_sync_page;  
        $shopifyAuthSessionId = $shopInfo->shopify_auth_session_id;
        
        $ranges = 'personalised_products,engraved_trophies,decorated_glassware,say_it_with_glass';
        // $ranges = $shopInfo->price_range_values;
        
        if(!empty($ranges)){
            
            $decodeRanges = explode(",", $ranges);
            if(!empty($decodeRanges) && count($decodeRanges) > 0){
                $totalPageLimit  = PersonalisedGiftAppUserProductRanges::where('personalised_gift_app_user_id', $shopInfo->id)->whereIn('product_range_type', $decodeRanges)->sum('total_page_limit');
            }
        }
        
        for ($i = 1; $i <= $totalPageLimit; $i++) {
            
            $pgs_product_response = $this->callPersonalisedAppAPI($pgs_third_party_product_api_url."all_products/?page=$i&size=10&range_type=$ranges&max_rrp=$maxrrp", "GET", $apikey, $username, "");
    
            $totalPgsProducts = json_decode($pgs_product_response);
        }
        
        Log::channel('check-cron-products')->info('End cron job call start time: '.date("H:i:s"));
        
        dd('Complete');
        
    }

}
