<?php

namespace App\Http\Controllers;

use App\Http\Helpers\CustomHelpers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Redirect;
use App\Models\User;
use Response;
use CustomHelper;
use App\Models\PersonalisedGiftAppUser;
use App\Models\ShopifyMetafield;
use App\Models\DeletedHookProduct;
use App\Models\UpdatedHookProduct;
use App\Models\MandatoryShopifyWebhook;
use App\Models\PersonalisedGiftAppProduct;
use App\Models\PersonalisedGiftAppProductMeta;
use App\Models\ShopifyStoreOrder;
use App\Models\ShopifyStoreOrderItem;
use App\Lib\ProductCreator;
use App\Models\HookOrder;
use App\Models\HookProductInventory;
use App\Traits\PersonalisedAppTrait;
use App\Jobs\AutomaticPublishShopifyProductJob;
use App\Jobs\AutomaticUpdateProductPriceJob;
use App\Models\Session;
use App\Models\PgsHookProduct;
use App\Models\PgsDeleteHookProduct;
use App\Models\PersonalisedGiftAppCategoryProduct;
use App\Models\PersonalisedGiftAppUserProductRanges;

class CronController extends Controller
{
    use PersonalisedAppTrait;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
	public function createOrderByWebhook(Request $request)
	{
        $orderData = $request->all();
		Log::channel('shopify-orders')->info('Order hook call');
		
		$shopifyHeaderInfo = $request->header();
		$shop_domain = NULL;
		if(!empty($shopifyHeaderInfo)){
		   $shop_domain = $shopifyHeaderInfo['x-shopify-shop-domain'][0];
		}

		if(!empty($orderData)){
			$data = json_encode($orderData);
			$order_id = $orderData['id'];

			$checkHookOrder = HookOrder::where([
				'order_id' => $order_id
			])->first();

			if(empty($checkHookOrder)) {
				$orderRecordData = [
					'data' => json_encode($data),
					'order_id' => $order_id,
					'shop_domain' => $shop_domain
				];
				HookOrder::create($orderRecordData);
			}
		}
		
		Log::channel('shopify-orders')->info("All order items are saved in database");
		Log::channel('shopify-orders')->info("#######################################################################");

		header('HTTP/1.0 200 OK');
	}

    public function updateProductInventory(Request $request)
	{
		$itemData = $request->all();
		Log::channel('shopify-product-inventory')->info('Product Inventory Hook Call');
		
		$shopifyHeaderInfo = $request->header();
		$shop_domain = NULL;
		if(!empty($shopifyHeaderInfo)){
		   $shop_domain = $shopifyHeaderInfo['x-shopify-shop-domain'][0];
		}
    
        Log::channel('shopify-product-inventory')->info('header info - '.json_encode($request->header()));
        
		if(!empty($itemData)){
			$data = json_encode($itemData);
			$inventory_id = $itemData['inventory_item_id'];

			$checkHookInventory = HookProductInventory::where([
				'inventory_item_id' => $inventory_id
			])->first();

			if(empty($checkHookInventory)) {
				$inventoryRecordData = [
                    'data' => json_encode($data),
                    'inventory_item_id' => $inventory_id,
					'shop_domain' => $shop_domain
                ];
                HookProductInventory::create($inventoryRecordData);
			}			
		}
		
		Log::channel('shopify-product-inventory')->info("All product items are saved in database");
		Log::channel('shopify-product-inventory')->info("#######################################################################");

		header('HTTP/1.0 200 OK');
	}
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
	public function updateProductByWebhook(Request $request)
	{
		$productData = $request->all();
		Log::channel('updated-shopify-products')->info('Updated product call');
		
		$shopifyHeaderInfo = $request->header();
		$shop_domain = NULL;
		if(!empty($shopifyHeaderInfo)){
		   $shop_domain = $shopifyHeaderInfo['x-shopify-shop-domain'][0];
		}
		
		if(!empty($productData)){
			$data = json_encode($productData);
			$product_id = $productData['id'];
            
			$checkUpdateProductHookOrder = UpdatedHookProduct::where([
				'product_id' => $product_id
			])->first();

			$productRecordData = [
				'data' => json_encode($data),
				'product_id' => $product_id,
				'shop_domain' => $shop_domain
			];
			UpdatedHookProduct::create($productRecordData);
		}
		
		Log::channel('updated-shopify-products')->info("All updated products are saved in database");
		Log::channel('updated-shopify-products')->info("#######################################################################");

		header('HTTP/1.0 200 OK');
	}
	
	/**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
	public function deleteProductByWebhook(Request $request)
	{
		$productData = $request->all();
		Log::channel('deleted-products')->info('Delete product call');
		
		$shopifyHeaderInfo = $request->header();
		$shop_domain = NULL;
		if(!empty($shopifyHeaderInfo)){
		   $shop_domain = $shopifyHeaderInfo['x-shopify-shop-domain'][0];
		}
		
		if(!empty($productData)){
			$data = json_encode($productData);
			$product_id = $productData['id'];

            $userInfo = PersonalisedGiftAppProduct::where('shopify_product_id', $product_id)->first();
            $userId = NULL;
            if(!empty($userInfo)){
                $userId = $userInfo->personalised_gift_app_user_id;
            }
            
			$checkProductHookOrder = DeletedHookProduct::where([
				'product_id' => $product_id
			])->first();

			if(empty($checkProductHookOrder)) {
				$productRecordData = [
					'data' => json_encode($data),
					'product_id' => $product_id,
					'personalised_gift_app_user_id' => $userId,
					'shop_domain' => $shop_domain
				];
				DeletedHookProduct::create($productRecordData);
			}
		}
		
		Log::channel('deleted-products')->info("All deleted products are saved in database");
		Log::channel('deleted-products')->info("#######################################################################");

		header('HTTP/1.0 200 OK');
	}
	
		/**
     * set a cron job for get records fron hook orders tables.
     *
     * @return \Illuminate\Http\Response
     */
	public function CronJobForDeletedHookProducts(Request $request)
	{
		Log::channel('deleted-products')->info("#######################################################################");
		Log::channel('deleted-products')->info('Update deleted product cron job call start time: '.date("H:i:s"));

		$hookProducts = DeletedHookProduct::where('is_updated', 0)->get();

		if(!empty($hookProducts) && $hookProducts->count() > 0){
	        foreach ($hookProducts as $hookProduct) {

	        	$productData = json_decode(json_decode($hookProduct->data),true);
	            $product_id = $hookProduct->product_id;

	            $productInfo = PersonalisedGiftAppProduct::where('shopify_product_id', $product_id)->first();
	            
	            Log::channel('deleted-products')->info("#######################################################################");
		        Log::channel('deleted-products')->info('encoded data: '.json_encode($product_id));
		
	            if(!empty($productInfo)){
	                
                    Log::channel('deleted-products')->info("#######################################################################");
		            Log::channel('deleted-products')->info('inside if');
		            
		            $checkProductMetafield = ShopifyMetafield::where('owner_id', $productInfo->shopify_graph_ql_id)->get();
		            if(!empty($checkProductMetafield) && $checkProductMetafield->count() > 0){
		                ShopifyMetafield::where('owner_id', $productInfo->shopify_graph_ql_id)->delete();
		            }
		            
		            $shopifyInventoryId = str_replace("gid://shopify/InventoryItem/","", $productInfo->shopify_product_inventory_item_id);
		            $chceckProductInventory = HookProductInventory::where('inventory_item_id', $shopifyInventoryId)->where('shop_domain', $hookProduct->shop_domain)->first();
		            if(!empty($chceckProductInventory)){
		                $chceckProductInventory->delete();
		            }
		            
		            $product_range_type = $productInfo->listing_type;
		            $dbUserId = $productInfo->personalised_gift_app_user_id;
		            $productRanges = PersonalisedGiftAppUserProductRanges::where('personalised_gift_app_user_id', $dbUserId)->where('product_range_type', $product_range_type)->first();
		            if(!empty($productRanges)){
		                $totalProducts = $productRanges->total_products-1;
		                $productRanges->update(['total_products' => $totalProducts]);
		            }  
		            
		            PersonalisedGiftAppCategoryProduct::where('personalised_gift_app_product_id', $productInfo->id)->delete();
		            
		            PersonalisedGiftAppProductMeta::where('personalised_gift_app_product_id', $productInfo->id)->delete();
		            
		            PersonalisedGiftAppUser::where('id', $dbUserId)->update(['last_sync_page' => 0]);
		            
		            $productInfo->delete();
		            /* PersonalisedGiftAppProduct::where('shopify_product_id', $product_id)->update([
                        'shopify_product_id' => NULL,
                        'shopify_graph_ql_id' => NULL,
                        'shopify_product_handle' => NULL,
                        'shopify_product_variant_id' => NULL,
                        'shopify_product_inventory_item_id' => NULL,
                        'shopify_edit_product_link' => NULL,
                        'shopify_preview_product_link' => NULL,
                        'shopify_product_status' => 'Inactive',
                        'is_shopify_product' => 0,
                    ]); */
		            
	            } else {
	                Log::channel('deleted-products')->info("#######################################################################");
		            Log::channel('deleted-products')->info('inside else');
	            }

				$affected = DeletedHookProduct::where('product_id', $product_id);
				$record['is_updated'] = 1;
				$affected->update($record);
				
				Log::channel('deleted-products')->info("Update delete hook product to is_updated 1 product id -".$product_id);
	        }	    
	    }
	    Log::channel('deleted-products')->info('Update Order cron job call end time: '.date("H:i:s"));
	    Log::channel('deleted-products')->info("#######################################################################");

	}

	/**
     * set a cron job for get records fron hook orders tables.
     *
     * @return \Illuminate\Http\Response
     */
	public function cronJobForCreateHookOrders(Request $request)
	{	
		ini_set('memory_limit', -1);
		ini_set('max_execution_time', 30000);

		Log::channel('shopify-orders')->info("#######################################################################");
		Log::channel('shopify-orders')->info('Update Order cron job call start time: '.date("H:i:s"));

        $cronJobDurationInMinutes = 9;
		$cronJobDurationInSeconds = $cronJobDurationInMinutes * 60;
		$startTime = time();
		$endTime = $startTime + $cronJobDurationInSeconds;

		$hookOrders = HookOrder::where('is_updated', 0)->get();

		if($hookOrders->count() > 0){
	        foreach ($hookOrders as $key => $order) {

	        	$timeDifference = $endTime - time();
  				if($timeDifference <= $cronJobDurationInSeconds && $timeDifference > 0){

		            $orderData = json_decode(json_decode($order->data),true);
		            $order_id = $order->order_id;
					Log::channel('shopify-orders')->info("Order Data for Order ID ".$order->order_id.": ".json_encode($orderData, true));

		            CustomHelper::createShopifyHookOrders($orderData, $order->shop_domain); // store shopify orders on teh orders table

					$affected = HookOrder::where('order_id', $order_id);
					$record['is_updated'] = 1;
					$affected->update($record);

					Log::channel('shopify-orders')->info("Update hook order to is_updated 1 order id -".$order_id);

				}else{
					break;
				}
	        }
	    
	    }else{
	    	Log::channel('shopify-orders')->info('No Records founds for update orders');
	    }

	    Log::channel('shopify-orders')->info('Update Order cron job call end time: '.date("H:i:s"));
	    Log::channel('shopify-orders')->info("#######################################################################");

	}

	public function CronJobForCreatePgsOrders()
	{
		$this->getOrderFulfillmentInformation(); // get order fulfillment information

		Log::channel('pgs-orders')->info("#######################################################################");
		Log::channel('pgs-orders')->info('Create PGS order cron job call start time: '.date("H:i:s"));

		$orderItems = ShopifyStoreOrderItem::where('is_pgs_order_item', 0)->whereNull('is_pgs_store_order_id')->limit(50)->get();
		if(!empty($orderItems) && $orderItems->count() > 0){
			foreach($orderItems as $orderItem){
				
				$shopInfo = PersonalisedGiftAppUser::where('id', $orderItem->shopifyStoreOrder->personalised_gift_app_user_id)->first();
				if(!empty($shopInfo) && $shopInfo->personalised_app_user_status == 1){

					$username = $shopInfo->username;
        			$apikey = $shopInfo->api_key;  

					if(!empty($orderItem->shopifyStoreOrder->shipping_address)){
						$addressInfo = json_decode($orderItem->shopifyStoreOrder->shipping_address);
					}else{
						$addressInfo = json_decode($orderItem->shopifyStoreOrder->shopifyStoreCustomer->default_address);
					}
					
					// add code for next day shipping value
					$orderShippingTotal = CustomHelper::getOrderShippingPrice($orderItem->shopifyStoreOrder->shipping_lines);
				   	$next_day = false;
				   	$cnc_b2b_next_day_shipping = $shopInfo->next_day_shipping_type_value;
				    if ($cnc_b2b_next_day_shipping && $cnc_b2b_next_day_shipping == "enable_next_day_shipping") {
				        if ($orderShippingTotal > 0) {
				            $next_day = true;
				        }
				    } else if ($cnc_b2b_next_day_shipping && $cnc_b2b_next_day_shipping == "all_orders_to_next_day") {
				        $next_day = true;
				    } else if ($cnc_b2b_next_day_shipping && $cnc_b2b_next_day_shipping == "disable_next_day_shipping") {
				        $next_day = false;
				    }
				    
				    $next_day_shipping_value = ($next_day) ? 1 : 0;
				    
				    // update next day shipping option on order item table
				    $orderItem->update(['is_order_shipping_value' => $next_day_shipping_value]);
					
					/*
					$customerInfo = [
						'address_line_1' => (isset($addressInfo->address1) && !empty($addressInfo->address1)) ? $addressInfo->address1 : $orderItem->shipping_address_1,
						'address_line_2' => (isset($addressInfo->address2) && !empty($addressInfo->address2)) ? $addressInfo->address2 : $orderItem->shipping_address_2,
						'town' => $addressInfo->province,
						'county' => $addressInfo->country_code,
						'postcode' => $addressInfo->province_code,
						'country' => $addressInfo->country,
					];
					*/
					
					$customerInfo = [
						'address_line_1' => (isset($addressInfo->address1) && !empty($addressInfo->address1)) ? $addressInfo->address1 : $orderItem->shipping_address_1,
						'address_line_2' => (isset($addressInfo->address2) && !empty($addressInfo->address2)) ? $addressInfo->address2 : $orderItem->shipping_address_2,
						'town' => $addressInfo->city,
						'county' => $addressInfo->country,
						'postcode' => $addressInfo->zip,
						'country' => $addressInfo->country_code,
					];
					
					$orderData = [
						'order_id' => $orderItem->shopifyStoreOrder->order_number.''.$orderItem->shopify_store_order_id,
						'item_id' => $orderItem->id,
						'custom_field' => "",
						'product_sku' => $orderItem->sku,
						'product_name' => $orderItem->title,
						'item_number' => $orderItem->sku,
						'quantity' => $orderItem->quantity,
						'shipping_type' => 'Standard',
						'next_day' => $next_day_shipping_value,
						'customer_name' => $orderItem->shopifyStoreOrder->shopifyStoreCustomer->first_name.' '.$orderItem->shopifyStoreOrder->shopifyStoreCustomer->last_name,
						'address_line_1' => $customerInfo['address_line_1'],
						'address_line_2' => $customerInfo['address_line_2'],
						'town' => $customerInfo['town'],
						'county' => $customerInfo['county'],
						'postcode' => $customerInfo['postcode'],
						'country' => $customerInfo['country'],
						'reference' => $orderItem->shopifyStoreOrder->reference,
						'order_notes' => $orderItem->shopifyStoreOrder->note,
						'uploadNewUrl' => '',
						'print_url' => '',
						'order_from' => 'Shopify_Order',
						'sale_price' => $orderItem->price
					];

					if(!empty($orderItem->properties)){
						$decodedData = json_decode($orderItem->properties);
						foreach($decodedData as $propertyData){
							if($propertyData->name == 'FONTS'){
								$orderData['engrave_fonts'] = $propertyData->value;
							}

							if($propertyData->name == 'LINE 1'){
								$orderData['font_value_1'] = $propertyData->value;
							}

							if($propertyData->name == 'LINE 2'){
								$orderData['font_value_2'] = $propertyData->value;
							}

							if($propertyData->name == 'LINE 3'){
								$orderData['font_value_3'] = $propertyData->value;
							}

							if($propertyData->name == 'LINE 4'){
								$orderData['font_value_4'] = $propertyData->value;
							}

							if($propertyData->name == 'LINE 5'){
								$orderData['font_value_5'] = $propertyData->value;
							}

							if($propertyData->name == 'LINE 6'){
								$orderData['font_value_6'] = $propertyData->value;
							}

							if($propertyData->name == 'LINE 7'){
								$orderData['font_value_7'] = $propertyData->value;
							}

							if($propertyData->name == 'LINE 8'){
								$orderData['font_value_8'] = $propertyData->value;
							}

							if($propertyData->name == 'LINE 9'){
								$orderData['font_value_9'] = $propertyData->value;
							}

							if($propertyData->name == 'LINE 10'){
								$orderData['font_value_10'] = $propertyData->value;
							}

							if($propertyData->name == 'FONT COLOR'){
								$orderData['font_color'] = $propertyData->value;
							}	

							if($propertyData->name == 'CLIPART'){
								$orderData['clipart'] = CustomHelper::GetClipartReferNumber($propertyData->value, $orderItem->shopifyStoreOrder->personalised_gift_app_user_id, '');
							}
						}
					}
					CustomHelper::createPgsThirdPartyOrder($orderData, $apikey, $username, $orderItem->id);
					$this->acceptedOrderFulfillmentRequest();
				}else{
					Log::channel('pgs-orders')->info('Store staus not active from PGS APP for store db id : '.$orderItem->shopifyStoreOrder->personalised_gift_app_user_id);
				}
			}
		}

		Log::channel('pgs-orders')->info('Create PGS order cron job call end time: '.date("H:i:s"));
	    Log::channel('pgs-orders')->info("#######################################################################");

	}

	private function getOrderFulfillmentInformation()
	{
		Log::channel('get-order-fulfillment-job')->info("#######################################################################");
		Log::channel('get-order-fulfillment-job')->info('Check order fulfillment cron job call start time: '.date("H:i:s"));

		$fulfillOrders = ShopifyStoreOrder::where('is_pgs_order', 1)->whereNull('shopify_fulfillment_order_id')->limit(50)->get();

		if(!empty($fulfillOrders) && $fulfillOrders->count() > 0){
			foreach($fulfillOrders as $fulfillOrder){
				$shopInfo = PersonalisedGiftAppUser::where('id', $fulfillOrder->personalised_gift_app_user_id)->first();
				if(!empty($shopInfo)){
		            
		            $shopName = $shopInfo->session->shop;
            		$shopAccessToken = $shopInfo->session->access_token;

            		$dbOrderId = $fulfillOrder->id;
					$shopifyOrderId = $fulfillOrder->admin_graphql_api_id;

					$shopOrderResponse = ProductCreator::getShopifyOrderFulfillment($shopName, $shopAccessToken, $shopifyOrderId);

					if(!empty($shopOrderResponse)){
						if(!empty($shopOrderResponse->data)){
							
							$shopifyGraphQlOrderId = $shopOrderResponse->data->order->id;
							$shopifyOrderyId = str_replace("gid://shopify/Order/","", $shopifyGraphQlOrderId);

							if(!empty($shopOrderResponse->data->order->fulfillmentOrders->nodes)){

								foreach($shopOrderResponse->data->order->fulfillmentOrders->nodes as $fulfillOrder){

									$shopifyGraphQlFulfillOrderId = $fulfillOrder->id;
									if(!empty($fulfillOrder->lineItems->edges)){

										foreach($fulfillOrder->lineItems->edges as $lineitem){
											$shopifyGraphQlFulfillOrderLineItemIdId = $lineitem->node->id;
											$item_sku = $lineitem->node->sku;
											
											$updateRecord = [
												'shopify_fulfillment_order_id' => $shopifyGraphQlFulfillOrderId,
												'shopify_fulfillment_order_item_id' => $shopifyGraphQlFulfillOrderLineItemIdId,
												'shipping_address_1' => $shopOrderResponse->data->order->shippingAddress->address1,
												'shipping_address_2' => $shopOrderResponse->data->order->shippingAddress->address2,
												'shipping_address_customer_name' => $shopOrderResponse->data->order->shippingAddress->name,
												'shipping_address_province' => $shopOrderResponse->data->order->shippingAddress->province,
												'shipping_address_zip' => $shopOrderResponse->data->order->shippingAddress->zip,
												'shipping_address_phone' => $shopOrderResponse->data->order->shippingAddress->phone,
											];

											$checkFulfillmentLineItems = ShopifyStoreOrderItem::where('shopify_order_id', $shopifyOrderyId)->where('sku', $item_sku)->whereNull('shopify_fulfillment_order_item_id')->first();
											
											if(!empty($shopifyGraphQlFulfillOrderId)){

												$shopifyfulfillmentOrderId = str_replace("gid://shopify/FulfillmentOrder/","", $shopifyGraphQlFulfillOrderId);

												CustomHelper::sendOrderFulfillmentRequest($shopName, $shopifyfulfillmentOrderId, $shopAccessToken, $dbOrderId); // send order fulfillment request for order 
											}
		
											if(!empty($checkFulfillmentLineItems)){
												$checkFulfillmentLineItems->update($updateRecord);
											}
										}
									}
									ShopifyStoreOrder::where('orderId', $shopifyOrderyId)->update(['shopify_fulfillment_order_id' => $shopifyGraphQlFulfillOrderId]);
								}
							}
						}
					}
				}	
			}
		}

		Log::channel('get-order-fulfillment-job')->info('Check order fulfillment cron job call end time: '.date("H:i:s"));
	    Log::channel('get-order-fulfillment-job')->info("#######################################################################");
	}

	public function acceptedOrderFulfillmentRequest()
	{
		Log::channel('accept-fulfillment-request')->info("#######################################################################");
		Log::channel('accept-fulfillment-request')->info('Check shopify fulfillment order status cron job call start time: '.date("H:i:s"));

		$fulfillment_records = ShopifyStoreOrder::whereNotNull('shopify_fulfillment_order_id')->whereNull('accept_fulfillment_request_order_response')->get();
		if(!empty($fulfillment_records) && $fulfillment_records->count() > 0){
			foreach($fulfillment_records as $fulfillment_record){

				Log::channel('accept-fulfillment-request')->info("for order id - ".$fulfillment_record->id);

				$shopInfo = PersonalisedGiftAppUser::where('id', $fulfillment_record->personalised_gift_app_user_id)->first();
				if(!empty($shopInfo)){
		            
		            $shopName = $shopInfo->session->shop;
            		$shopAccessToken = $shopInfo->session->access_token;

            		$dbOrderId = $fulfillment_record->id;

					$totalItemCount = $fulfillment_record->getPgsShopifyStoreOrderItem->count();
					$totalPgsItemCount = $fulfillment_record->totalPgsShopifyStoreOrderItem->count();

					if($totalItemCount == $totalPgsItemCount){
						$shopifyfulfillmentOrderId = str_replace("gid://shopify/FulfillmentOrder/","", $fulfillment_record->shopify_fulfillment_order_id);

						CustomHelper::acceptOrderFulfillmentRequest($shopName, $shopifyfulfillmentOrderId, $shopAccessToken, $dbOrderId); // send order fulfillment request for order 
					}
				}
			}
		}

		Log::channel('accept-fulfillment-request')->info("#######################################################################");
		Log::channel('accept-fulfillment-request')->info('Check shopify fulfillment cron job call start time: '.date("H:i:s"));
	}

	public function getPgsOrderStatusInformation()
	{
		Log::channel('pgs-order-status')->info("#######################################################################");
		Log::channel('pgs-order-status')->info('Check PGS order status cron job call start time: '.date("H:i:s"));

		$pgsOrderIds = [];
		$totalRecordQuery = ShopifyStoreOrderItem::where('is_pgs_order_item', 1)->whereNotNull('is_pgs_store_order_id');
		$orderItems = $totalRecordQuery->where(function($query) {
			$query->whereNull('pgs_order_status')
				->orWhere('pgs_order_status', '!=', 'completed');
		})->limit(50)->get();

		if(!empty($orderItems) && $orderItems->count() > 0){
			foreach($orderItems as $orderItem){
				$pgsOrderIds[$orderItem->shopifyStoreOrder->personalised_gift_app_user_id][] = $orderItem->shopifyStoreOrder->order_number.''.$orderItem->shopify_store_order_id;
			}

			if(!empty($pgsOrderIds) && count($pgsOrderIds) > 0){
				foreach($pgsOrderIds as $authkey => $pgsOrderId){

					$shopInfo = PersonalisedGiftAppUser::where('id', $authkey)->first();
					if(!empty($shopInfo) && $shopInfo->personalised_app_user_status == 1){

						$username = $shopInfo->username;
						$apikey = $shopInfo->api_key;  

						$pgsOrders = implode(",", $pgsOrderId);
						CustomHelper::checkPgsThirdPartyOrderStatus($pgsOrders, $apikey, $username);
					}
				}
			}
		}

		$this->createShopifyItemFulfillment(); // create shopify order fulfillment

		Log::channel('pgs-order-status')->info('Check PGS order status cron job call end time: '.date("H:i:s"));
	    Log::channel('pgs-order-status')->info("#######################################################################");

	}

	private function createShopifyItemFulfillment()
	{
		Log::channel('create-order-fulfillment-job')->info("#######################################################################");
		Log::channel('create-order-fulfillment-job')->info('Create order fulfillment cron job call start time: '.date("H:i:s"));

		$orderItems = ShopifyStoreOrderItem::where('is_pgs_order_item', 1)->whereNotNull('is_pgs_store_order_id')->where('pgs_order_status', 'completed')->whereNotNull('shopify_fulfillment_order_id')->whereNotNull('shopify_fulfillment_order_item_id')->where('is_order_fulfilled', 0)->where('pgs_order_tracking_id', '!=', '')->limit(20)->get();

		if(!empty($orderItems) && $orderItems->count() > 0){
			foreach($orderItems as $orderItem){

				$shopInfo = PersonalisedGiftAppUser::where('id', $orderItem->shopifyStoreOrder->personalised_gift_app_user_id)->first();
				if(!empty($shopInfo) && $shopInfo->automatically_process_order == 1){
					
					$is_fullfillment = false;
					if($orderItem->shopifyStoreOrder->order_type == 'pgs_order'){
						$is_fullfillment = true;
					}else if($orderItem->shopifyStoreOrder->order_type == 'shared_order' && $shopInfo->process_shared_order == 1){
						$is_fullfillment = true;
					}

					if($is_fullfillment){
						$shopName = $shopInfo->session->shop;
						$shopAccessToken = $shopInfo->session->access_token;

						$fulfillemntData = [
							'notifyCustomer' => true,
							'trackingInfo' => [
								'company' => 'Personalised Gift APP',
								'number' => $orderItem->pgs_order_tracking_id
							],
							'lineItemsByFulfillmentOrder' => [
								'fulfillmentOrderId' => $orderItem->shopify_fulfillment_order_id,
								'fulfillmentOrderLineItems' => [
									[
										'id' => $orderItem->shopify_fulfillment_order_item_id,
										'quantity' => (int) $orderItem->quantity
									]
								]
							],
							'originAddress' => null
						];

						Log::channel('create-order-fulfillment-job')->info('Create order fulfillment order request : '.json_encode($fulfillemntData).' for db order item id - '.$orderItem->id);
						
						$shopOrderResponse = ProductCreator::createShopifyOrderFulfillment($shopName, $shopAccessToken, $fulfillemntData);
						
						Log::channel('create-order-fulfillment-job')->info('Create order fulfillment order response : '.json_encode($shopOrderResponse).' for db order item id - '.$orderItem->id);
						
						$updateFulfillRecord['shopify_order_fulfillment_request'] = json_encode($fulfillemntData);
						$updateFulfillRecord['shopify_order_fulfillment_response'] = json_encode($shopOrderResponse);

						if(!empty($shopOrderResponse->data)){

							$fulfillInfo = $shopOrderResponse->data->fulfillmentCreateV2->fulfillment;
							$updateFulfillRecord['is_order_fulfilled'] = 1;
							$updateFulfillRecord['shopify_fulfillemnt_id'] = $fulfillInfo->id;
							$updateFulfillRecord['shopify_fulfillemnt_status'] = $fulfillInfo->status;
							$updateFulfillRecord['shopify_fulfillemnt_tracking_info'] = json_encode($fulfillInfo->trackingInfo);
						}

						$orderItem->update($updateFulfillRecord);
						
					}else{
						$orderItem->update(['is_order_fulfilled' => 1]);
					}

				}else{
					$orderItem->update(['is_order_fulfilled' => 1]);
				}
			}
		}

		Log::channel('create-order-fulfillment-job')->info('Create order fulfillment cron job call end time: '.date("H:i:s"));
	    Log::channel('create-order-fulfillment-job')->info("#######################################################################");
	}

	public function syncPgsProductQunatity(Request $request)
    {
        $shopInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', 2)->first();
        if(!empty($shopInfo) && $shopInfo->personalised_app_user_status == 1){

            $shopName = $shopInfo->session->shop;
            $shopAccessToken = $shopInfo->session->access_token;

            $username = $shopInfo->username;
            $apikey = $shopInfo->api_key;  
            $shopifyLocationID = $shopInfo->store_location_id;

			$productSkus = array();
            $products = PersonalisedGiftAppProduct::where('personalised_gift_app_user_id', $shopInfo->id)->get();
            if(!empty($products) && $products->count() > 0){
                foreach($products as $product){

					if(!empty($product->personalisedGiftAppProductMeta->bigcommerce_sku)){
						$productSkus[] = $product->personalisedGiftAppProductMeta->bigcommerce_sku;
					}
                }

				if (count($productSkus) > 10) {
					foreach (array_chunk($productSkus, 10) as $productSkus) {
						CustomHelper::updateProductInventoryStock($productSkus, $apikey, $username, $shopName, $shopAccessToken, $shopifyLocationID, ''); 
					}
				} else {
					CustomHelper::updateProductInventoryStock($productSkus, $apikey, $username, $shopName, $shopAccessToken, $shopifyLocationID, '');
				}
            }
        }        
    }

	// update product quantity when user view product detail page on the shopify store
	public function getPgsProductQuantity(Request $request)
	{
		$productSku = $request->sku;
		$domainName = $request->domain;
		Log::channel('syncing-sku-product-quantity')->info('get sku quantity for product sku : '.$productSku.' for domain name - '.$domainName);
		$response = [];
		if(!empty($productSku) && !empty($domainName)){
			
			$getStoreName = Session::where('shop', $domainName)->first();
			
			if(!empty($getStoreName)){
                
                $userInfo = PersonalisedGiftAppUser::where('shopify_auth_session_id', $getStoreName->id)->first();
                
				$productMetaInfo = PersonalisedGiftAppProductMeta::where('bigcommerce_sku', $productSku)
				->join('personalised_gift_app_products', 'personalised_gift_app_product_metas.personalised_gift_app_product_id', '=', 'personalised_gift_app_products.id')
				->where('personalised_gift_app_products.personalised_gift_app_user_id', $userInfo->id)
				->get();

				if(!empty($productMetaInfo) && $productMetaInfo->count() > 0){
					foreach($productMetaInfo as $meta){
						
						if(isset($meta->personalisedGiftAppProduct) && !empty($meta->personalisedGiftAppProduct)){

							$authSessionId = $meta->personalisedGiftAppProduct->personalised_gift_app_user_id;
							$shopInfo = PersonalisedGiftAppUser::where('id', $authSessionId)->first();
							
							if(!empty($shopInfo)){

								$shopName = $shopInfo->session->shop;
								$shopAccessToken = $shopInfo->session->access_token;

								$username = $shopInfo->username;
								$apikey = $shopInfo->api_key;  
								$shopifyLocationID = $shopInfo->store_location_id;

								$skudata = array($productSku);
								CustomHelper::updateProductInventoryStock($skudata, $apikey, $username, $shopName, $shopAccessToken, $shopifyLocationID, $meta->personalised_gift_app_product_id);
							}
						}
					}
					$response = [
						'success' => true,
						'message' => "Quantity updated successfully for this SKU - ".$productSku
					];
				}else{
					$response = [
						'success' => false,
						'message' => "Product not found for this SKU - ".$productSku
					];
				}
			}else{
				$response = [
					'success' => false,
					'message' => "Domain not found"
				];
			}

		}else{
			$response = [
				'success' => false,
				'message' => "Sku and domain name is required"
			];
		}

		return Response::json($response);
	}
	
	// create shopify product automated jobs
	public function createPgsProductAutomatedJob(Request $request)
	{
	    Log::channel('create-automated-shopify-products')->info("#######################################################################");
		Log::channel('create-automated-shopify-products')->info('Update auomated create product cron job call start time: '.date("H:i:s"));
		
		$users = PersonalisedGiftAppUser::where('personalised_app_user_status', 1)->where('import_all', 1)->get();
		dd($users);
        if(!empty($users) && $users->count() > 0){
            foreach($users as $user){
                
                Log::channel('create-automated-shopify-products')->info('user found for create automated products - '.$user->id);
                
                $checkStoreMetafields = ShopifyMetafield::where('resource_type', 'store')->where('personalised_gift_app_user_id', $user->id)->first();
				if(empty($checkStoreMetafields)){
					CustomHelper::createShopStoreMetafields($user->shopify_auth_token);    
				}
	
				$shopifyLocationId = '';
				$shopifySalesChannelId = '';
				if(!empty($user->store_location_id)){
					$shopifyLocationId = $user->store_location_id;
				}
	
				if(!empty($user->store_sales_channel_id)){
					$shopifySalesChannelId = $user->store_sales_channel_id;
				}
	
				$shopName = $user->session->shop;
				$shopAccessToken = $user->session->access_token;
				$shopifyAuthSessionId = $user->id;
				
				$rangeType = $user->pricing_options;
                $marginPrice = $user->margin_change;
                $deductPrice = $user->deduct_price_change;

				$details['shop_name'] = $shopName;
				$details['range_type'] = $rangeType;
				$details['margin_price'] = $marginPrice;
				$details['deduct_price'] = $deductPrice;
				$details['user_id'] = $user->id;
				$details['access_token'] = $shopAccessToken;
				$details['sales_channel_id'] = $shopifySalesChannelId;
				$details['shopify_location_id'] = $shopifyLocationId;
				$details['auth_session_id'] = $shopifyAuthSessionId;
				
				AutomaticUpdateProductPriceJob::dispatch($details);
				dd($details);
				AutomaticPublishShopifyProductJob::dispatch($details);
			}
		}
		
		Log::channel('create-automated-shopify-products')->info('Update auomated create product cron job call end time: '.date("H:i:s"));
	    Log::channel('create-automated-shopify-products')->info("#######################################################################");
	}
	
	// store pgs product updating request webhooks
	public function getPgsProductApiWebhook(Request $request)
	{
	    Log::channel('pgs-product-hook-request')->info('Received webhook request from PGS APP data : '.json_encode($request->all()));
		if(!empty($request->post)){
            
            $pgsProductRecordData = [
				'data' => json_encode($request->all()),
				'listing_type' => $request->listing_type,
				'type' => $request->type,
			];
			
			PgsHookProduct::create($pgsProductRecordData);
			
			$responseData = [
                'success' => true,
                "statusCode" => 200,
                'data' => [],
                'message' => 'Product information saved on the shopify public public app'
            ];
			
		}else{
		    $responseData = [
                'success' => false,
                "statusCode" => 401,
                'data' => [],
                'message' => 'Shopify product request not found'
            ];
		}
		return json_encode($responseData);
	}
	
	// store pgs product deleted request webhooks
	public function deletePgsProductApiWebhook(Request $request)
	{
	    Log::channel('delete-pgs-product-hook-request')->info('Received webhook request from PGS APP data : '.json_encode($request->all()));
		if(!empty($request->sku)){
            
			$checkDeletedPgsHookProduct = PgsDeleteHookProduct::where('sku', $request->sku)->first();
			if(empty($checkDeletedPgsHookProduct)) {
				$pgsProductRecordData = [
					'data' => json_encode($request->all()),
					'sku' => $request->sku
				];
				PgsDeleteHookProduct::create($pgsProductRecordData);
			}
			
			$responseData = [
                'success' => true,
                "statusCode" => 200,
                'data' => [],
                'message' => 'Deleted sku product information saved on the shopify public public app'
            ];
            
		}else{
		    $responseData = [
                'success' => false,
                "statusCode" => 401,
                'data' => [],
                'message' => 'Shopify product sku not found'
            ];
		}
		
		return json_encode($responseData);
	}
	
	public function updateModifyPgsWebhookRequest(Request $request)
	{
		Log::channel('pgs-app-update-products')->info("#######################################################################");
		Log::channel('pgs-app-update-products')->info('pgs app update product cron job call start time: '.date("H:i:s"));
		
	    $productWebhookRequests = PgsHookProduct::where('is_updated', 0)->limit('200')->get();
		if(!empty($productWebhookRequests) && $productWebhookRequests->count() > 0){
	        foreach($productWebhookRequests as $productWebhookRequest){
	            $decodeData = json_decode($productWebhookRequest->data);
	            
	            CustomHelper::updatePgsHookRequestProducts($decodeData);
	            $productWebhookRequest->update(['is_updated' => 1]);
	        }
	    }
		
		Log::channel('pgs-app-update-products')->info("#######################################################################");
		Log::channel('pgs-app-update-products')->info('pgs app update product cron job call start time: '.date("H:i:s"));
	}
	
	public function updateDeletedPgsWebhookRequest(Request $request)
	{
	    Log::channel('pgs-app-delete-products')->info("#######################################################################");
		Log::channel('pgs-app-delete-products')->info('pgs app deleted product cron job call start time: '.date("H:i:s"));
		
	    $hookRequests = PgsDeleteHookProduct::where('is_updated', 0)->get();
	    if(!empty($hookRequests) && $hookRequests->count() > 0){
	        foreach($hookRequests as $hookRequest){
	                
	            $sku = $hookRequest->sku;
	            Log::channel('pgs-app-delete-products')->info('delete product sku: '.$sku);
	            $productMetas = PersonalisedGiftAppProductMeta::where('bigcommerce_sku', $sku)->get();
	            if(!empty($productMetas) && $productMetas->count() > 0){
	                foreach($productMetas as $productMeta){
	                    
	                    $productId = $productMeta->personalisedGiftAppProduct->id;
	                    $shopifyGraphQlId = $productMeta->personalisedGiftAppProduct->shopify_graph_ql_id;
	                    $pgsUserId = $productMeta->personalisedGiftAppProduct->personalised_gift_app_user_id;
	                    $pgsProductListingType = $productMeta->personalisedGiftAppProduct->listing_type;
	                    
	                    if(!empty($shopifyGraphQlId)){
    		            
        		            $userInfo = PersonalisedGiftAppUser::where('id', $pgsUserId)->first();
        		            if(!empty($userInfo)){
        		                
        		                $storeDomain = $userInfo->session->shop;
                        		$shopAccessToken = $userInfo->session->access_token;
            		            
            		            $shopifyGraphQlProductId = [
                                    'id' => $shopifyGraphQlId
                                ];
                                ProductCreator::callDeleteShopifyProduct($storeDomain, $shopAccessToken, $shopifyGraphQlProductId);  
        		            }
        		            
                        }else{
                            
                            $productRanges = PersonalisedGiftAppUserProductRanges::where('personalised_gift_app_user_id', $pgsUserId)->where('product_range_type', $pgsProductListingType)->first();
        		            if(!empty($productRanges)){
								if($productRanges->total_products > 0){
									$totalProducts = $productRanges->total_products-1;
        		                	$productRanges->update(['total_products' => $totalProducts]);
								}        		                
        		            }  
                            
                        	$checkCategoryProducts = PersonalisedGiftAppCategoryProduct::where('personalised_gift_app_product_id', $productId)->get();
    	                    if(!empty($checkCategoryProducts) && $checkCategoryProducts->count() > 0){
    	                        PersonalisedGiftAppCategoryProduct::where('personalised_gift_app_product_id', $productId)->delete();
    	                    }
    
    	                    $checkProduct = PersonalisedGiftAppProduct::where('id', $productId)->first();
    	                    if(!empty($checkProduct)){
    	                    	$checkProduct->delete();
    	                    }
    	                    
                        	$productMeta->delete();
                        }
	                }
	            }
	            
	            $hookRequest->update(['is_updated' => 1]);
	        }
	    }
	    
	    Log::channel('pgs-app-delete-products')->info('pgs app deleted product cron job call end time: '.date("H:i:s"));
	    Log::channel('pgs-app-delete-products')->info("#######################################################################");
	}

	public function updateCustomDropShipPrice(Request $request)
	{
		$pgsProducts = PersonalisedGiftAppProduct::whereNotNull('shopify_product_inventory_item_id')->where('is_update_cost_price', 0)->limit(50)->get();
		if(!empty($pgsProducts) && $pgsProducts->count() > 0){
			foreach ($pgsProducts as $pgsProduct) {

				$shopName = $pgsProduct->personalisedGiftAppUser->shop_domain;
				$shopAccessToken = $pgsProduct->personalisedGiftAppUser->shopify_auth_token;

				$productPrice = 0;
				CustomHelpers::updateShopifyProductInventoryCostPrice($shopName, $shopAccessToken, $pgsProduct->shopify_product_inventory_item_id, $productPrice, $pgsProduct->id);
				$pgsProduct->update(['is_update_cost_price' => 1]);
			}
			dd('complete');
		}
	}

}
