<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Auth\Events\PasswordReset;
use App\Models\User;
use URL;

class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Where to redirect users after resetting their password.
     *
     * @var string
     */
    // protected $redirectTo = RouteServiceProvider::HOME;

    protected $redirectTo = '/login';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

     /**
     * Reset Password
     *
     * @param mixed $user user
     * @param mixed $password password
     *
     * @return void
     */
    protected function resetPassword($user, $password)
    {
        $userExists = User::where('email', $user->email)->first();
        if($userExists)
        {
            $userExists->password = $password;

            $userExists->setRememberToken(Str::random(60));

            $userExists->save();
            event(new PasswordReset($userExists));
            return redirect()->route('login')->with('success', 'Password has been reset.');
        }
        else
        {
            return redirect()->route('login')->with('error', 'User not found.');
        }        
    }
    
}
