<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use URL;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function login(Request $request)
    {
        $input = $request->all();
        $this->validate(
            $request,
            [
                'email' => 'required|email',
                'password' => 'required',
            ]
        );
        $remember = (isset($input['remember']) && !empty($input['remember'])) ? true : false;
        $credentials = [
            'email' => $input['email'],
            'password' => $input['password']
        ];
        
        $userExists = User::where('email', $input['email'])->first();
        if($userExists)
        {
            if (Auth::attempt($credentials, $remember)) 
            {
                return redirect('admin/dashboard')->with('success', 'You are successfully logged in.');
            } 
            else 
            {
                return redirect('/login')->with('error', 'Incorrect email or password.');
            }
        }
        else
        {
            return redirect('/login')->with('error', 'Incorrect email or password.');
        }

    }

    protected function loggedOut(Request $request)
    {
        return redirect('login');
    }

}
