<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\User;
use App\Models\Session;
use CustomHelper;
use DB,DataTables,Log,Mail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use File,Storage;
use App\Models\ShopifyStoreOrder;
use App\Models\ShopifyStoreOrderItem;
use App\Models\PersonalisedGiftAppUser;

class StoreController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');      
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $data['title'] = 'Shopify Stores';
        return view('admin.stores.lists')->with('data', $data);
    }

    public function showShopifyStoreListing(Request $request)
    {
        ## Read value
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); // Rows display per page

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column']; // Column index
        $columnName = $columnName_arr[$columnIndex]['data']; // Column name
        $columnName = ($columnName == 'status' || $columnName == 'page_action') ? 'id' : $columnName;
        $columnSortOrder = $order_arr[0]['dir']; // asc or desc
        $searchValue = $search_arr['value']; // Search value

        $totalRecordQuery = Session::whereNotNull('scope')->whereNotNull('access_token');

        if(!empty($searchValue)){
            $totalRecordQuery = $totalRecordQuery->where(function ($q) use ($searchValue)
            {
                $q->where('shop', 'LIKE', '%' .$searchValue . '%');
            });
        }
        
        $totalRecordswithFilter = $totalRecordQuery->count();

        $records = $totalRecordQuery->skip($start)
               ->take($rowperpage)
               ->orderBy($columnName, $columnSortOrder)
               ->get();
           
        $totalRecords = $records->count();
        $totalRecordswithFilter = $totalRecordswithFilter;
        $data_arr = array();
        
        foreach($records as $key => $record){

            $shop = $record->shop;
            $created_date = date('d-m-Y h:i:s A', strtotime($record->created_at));
            $page_action = "<a href='".url('admin/shopify-store-orders/'.$record->id)."' class='action-icon' title='View Store Orders'> <i class='ti-shopping-cart-full'></i></a>";
            
            $data_arr[] = array(
                "shop"  => $shop,
                "created_at" => $created_date,
                "status" => "Active",
                "page_action" => $page_action
            );
        }
         
        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );
         
        echo json_encode($response);
        exit;

    }

    public function shopifyStoreOrders($store_id)
    {
        $storeInfo = Session::where('id', $store_id)->first();
        if(!empty($storeInfo)){
            $data['title'] = 'Shopify Store Orders';
            $data['store_info'] = $storeInfo;
            return view('admin.stores.order-lists')->with('data', $data);
        }else{
            return redirect('admin/shopify-stores')->with('error', 'Shopify store not found');
        }
    }

    public function showshopifyStoreOrderListings(Request $request)
    {
        ## Read value
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); // Rows display per page

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column']; // Column index
        $columnName = $columnName_arr[$columnIndex]['data']; // Column name
        $columnName = ($columnName == 'page_action') ? 'id' : $columnName;
        $columnSortOrder = $order_arr[0]['dir']; // asc or desc
        $searchValue = $search_arr['value']; // Search value

        $store_id = (!empty($request->get('store_id'))) ? $request->get('store_id') : '';
        
        $pgsUser = PersonalisedGiftAppUser::where('shopify_auth_session_id', $store_id)->first();
        $userId = (!empty($pgsUser)) ? $pgsUser->id : '';
        $totalRecordQuery = ShopifyStoreOrder::where('personalised_gift_app_user_id', $userId);

        if(!empty($searchValue)){
            $totalRecordQuery = $totalRecordQuery->where(function ($q) use ($searchValue)
            {
                $q->where('order_number', 'LIKE', '%' .$searchValue . '%');
            });
        }
        
        $totalRecordswithFilter = $totalRecordQuery->count();

        $records = $totalRecordQuery->skip($start)
               ->take($rowperpage)
               ->orderBy($columnName, $columnSortOrder)
               ->get();
           
        $totalRecords = $records->count();
        $totalRecordswithFilter = $totalRecordswithFilter;
        $data_arr = array();
        
        foreach($records as $key => $record){

            $order_number = $record->name;
            $created_date = date('d-m-Y h:i:s A', strtotime($record->created_at));
            $page_action = "<a href='".url('admin/view-store-order/'.$record->personalised_gift_app_user_id.'/'.$record->id)."' class='action-icon' title='View Order'> <i class='ti-eye'></i></a>";
            
            $data_arr[] = array(
                "order_number"  => $order_number,
                "created_at" => $created_date,
                "page_action" => $page_action,
            );
        }
         
        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );
         
        echo json_encode($response);
        exit;
    }

    public function viewStoreOrder($storeId,$orderId)
    {
        $orderInfo = ShopifyStoreOrder::where('id', $orderId)->first();
        $pgsUser = PersonalisedGiftAppUser::where('id', $storeId)->first();
        $actualStoreId = (!empty($pgsUser)) ? $pgsUser->shopify_auth_session_id : '';
        if(!empty($orderInfo)){
            $data['title'] = 'View Shopify Store Order';
            $data['order_info'] = $orderInfo;
            $data['store_id'] = $storeId;
            $data['shop_name'] = (isset($orderInfo->session) && !empty($orderInfo->session)) ? $orderInfo->session->shop: '';
            return view('admin.stores.view-store-order')->with('data', $data);
        }else{
            return redirect('admin/shopify-store-orders/'.$actualStoreId)->with('error', 'Order not found');
        }
    }

    public function updateOrderTrackingInformation($storeId,$orderItemId)
    {
        $orderItemInfo = ShopifyStoreOrderItem::where('id', $orderItemId)->whereNull('shopify_fulfillemnt_id')->whereNull('shopify_fulfillemnt_status')->first();
        if(!empty($orderItemInfo)){
            $data['title'] = 'Update Order Tracking Information';
            $data['order_item_info'] = $orderItemInfo;
            $data['store_id'] = $storeId;
            $data['shop_name'] = (isset($orderItemInfo->shopifyStoreOrder->session) && !empty($orderItemInfo->shopifyStoreOrder->session)) ? $orderItemInfo->shopifyStoreOrder->session->shop: '';
            return view('admin.stores.update-order-tracking-info')->with('data', $data);
        }else{
            return redirect('admin/shopify-store-orders/'.$storeId)->with('error', 'Order not found');
        }
    }

    public function updatePgsOrderTrackings(Request $request)
    {
        $this->validate($request,[
            'tracking_id'=>'required',
            'processed_time'=>'required'
        ]);

        $storeId = $request->store_id;
        $orderId = $request->order_id;

        $orderItem = ShopifyStoreOrderItem::where('is_pgs_order_item', 1)->whereNotNull('is_pgs_store_order_id')->where('pgs_order_status', 'completed')->whereNotNull('shopify_fulfillment_order_id')->whereNotNull('shopify_fulfillment_order_item_id')->whereNull('shopify_fulfillemnt_id')->whereNull('shopify_fulfillemnt_status')->where('id', $request->order_item_id)->first();
        
        if(!empty($orderItem)){

            CustomHelper::createPgsItemShopifyFulfillment($orderItem); 
            return redirect('admin/view-store-order/'.$storeId.'/'.$orderId)->with('success', 'Order tracking information updated successfully');

        }else{
            return redirect()->back()->with("error", 'No item founds for tracking.');
        }
    }

}
