<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Redirect;
use App\Models\User;
use Throwable;
use Mail, URL;
use App\Mail\SendAccountVerifyEmail;


class SettingController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @param mixed $request change password request
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function changePassword(Request $request)
    {
        $request->validate(
            [
                'current-password' => 'required',
                'new-password' => 'required|string|min:8|confirmed|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}$/|confirmed',
            ],
            [
                'new-password.regex' => 'Please create password must be 
                more than 8 characters long, 
                should contain at-least 
                1 Uppercase, 
                1 Lowercase,
                1 Numeric and 
                1 special character.'
            ]
        );

        if (!(Hash::check($request->get('current-password'), Auth::user()->password))) {
            // The passwords matches
            return redirect()->back()
                ->with("error","Your current password does not matches with the password you provided. Please try again.");
        }

        if (strcmp($request->get('current-password'),$request->get('new-password')) == 0) {
            // Current password and new password are same
            return redirect()->back()->with("error","New Password cannot be same as your current password. Please choose a different password.");
        }

        // Change Password
        $user = User::where('id', Auth::user()->id)->first();
        $user->password = $request->get('new-password');
        $user->save();
        return redirect()->back()->with("success", "Password has been changed successfully !");
    }

    /**
     * Update Email
     *
     * @param mixed $request form request
     *
     * @return void
     */
    public function updateEmail(Request $request)
    {    
        $validatedData = $request->validate([
            'email' => 'required', 'string', 'email', 'max:255', 'unique:users',
        ]);

        $user_inserted_email = Auth::user()->email;
        $requested_email = $request->get('email');
        if($user_inserted_email != $requested_email){

            // send email
            $enviornment = env('APP_ENVIRONMENT');
            $encrypted_email = Crypt::encryptString($requested_email);
            $encrypted_user_id = Crypt::encryptString(Auth::user()->id);

            $data['email'] = $requested_email;
            $data['link'] = url('user-verify-email/'.$encrypted_email.'/'.$encrypted_user_id);

            /* if($enviornment == 'production'){
                Mail::to($data['email'])->send(new SendAccountVerifyEmail($data)); //send verify link to email
            } */

            return redirect()->back()->with("email-success","Verification link send on the your submitted email address, Please verify the email.");
        }else{
            return redirect()->back()->with("email-success","Email not changing");
        }
    }
    
}
