<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\User;
use App\Models\PersonalisedGiftAppHowToPageContent;
use App\Models\PersonalisedGiftAppFaqPageContent;
use DB,DataTables,Log,Mail,URL,Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use File;
use Throwable;

class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $data['title'] = 'Dashboard';
        return view('admin.index')->with('data', $data);
    }

    public function settings()
    {
        $userInfo = User::where('id', Auth::user()->id)->first();
        $data['title'] = 'Settings';
        $data['userInfo'] = $userInfo;
        return view('admin.settings')->with('data', $data);
    }

    public function viewHowToPage()
    {
        $contents = PersonalisedGiftAppHowToPageContent::get();
        $userInfo = User::where('id', 1)->first();
        $howToPageTitle = '';
        $howToPageVideoLink = '';
        if(!empty($userInfo)){
            $howToPageTitle = $userInfo->how_to_page_title;
            $howToPageVideoLink = $userInfo->how_to_page_video_link;
        }

        $data['title'] = 'How To Page';
        $data['contents'] = $contents;
        $data['how_to_page_title'] = $howToPageTitle;
        $data['how_to_page_video_link'] = $howToPageVideoLink;
        return view('admin.how-to-page')->with('data', $data);
    }

    public function updateHowToPage(Request $request)
    {
        $how_to_page_title = (!empty($request->how_to_page_title)) ? $request->how_to_page_title : NULL;
        $how_to_page_video_link = (!empty($request->how_to_page_video_link)) ? $request->how_to_page_video_link : NULL;

        User::where('id', 1)->update(['how_to_page_title' => $how_to_page_title, 'how_to_page_video_link' => $how_to_page_video_link]);

        if(!empty($request->updated_page_content_id) && count($request->updated_page_content_id) > 0){
            foreach($request->updated_page_content_id as $update_key => $updated_page){
                if(!empty($request->updated_steps[$update_key])){

                    $update_page_content = PersonalisedGiftAppHowToPageContent::findorfail($updated_page);
                    $update_page_content->step = $request->updated_steps[$update_key];
                    $update_page_content->description = $request->updated_description[$update_key];
                    $update_page_content->save(); 

                }else{
                    PersonalisedGiftAppHowToPageContent::where('id', $updated_page)->delete();
                }
            }
        }

        if($request->steps){
            foreach($request->steps as $key => $step)
            {
                if(!empty($step)){
                    $page_content = new PersonalisedGiftAppHowToPageContent();
                    $page_content->step = $step;
                    $page_content->description = $request->description[$key];
                    $page_content->save(); 
                }      
            }
        }
        return redirect('admin/how-to-page')->with('success', 'The page content successfully updated in the system.');
    }

    public function deleteHowToPageContent(Request $request, $id)
    {
        $page_content = PersonalisedGiftAppHowToPageContent::findorfail($id);
        $page_content->delete();
        return redirect()->back()->with('success', 'The page content data has deleted successfully.');
    }
    
    public function viewFaqPage()
    {
        $faq_contents = PersonalisedGiftAppFaqPageContent::get();
        $userInfo = User::where('id', 1)->first();
        $faqPageTitle = '';
        if(!empty($userInfo)){
            $faqPageTitle = $userInfo->faq_page_title;
        }

        $data['title'] = 'Faq Page';
        $data['faq_contents'] = $faq_contents;
        $data['faq_page_title'] = $faqPageTitle;
        return view('admin.faq-page')->with('data', $data);
    }

    public function updateFaqPage(Request $request)
    {
        $faq_page_title = (!empty($request->faq_page_title)) ? $request->faq_page_title : NULL;

        User::where('id', 1)->update(['faq_page_title' => $faq_page_title]);

        if(!empty($request->updated_faq_content_id) && count($request->updated_faq_content_id) > 0){
            foreach($request->updated_faq_content_id as $update_key => $updated_faq_page){
                if(!empty($request->updated_title[$update_key])){

                    $update_faq_page_content = PersonalisedGiftAppFaqPageContent::findorfail($updated_faq_page);
                    $update_faq_page_content->title = $request->updated_title[$update_key];
                    $update_faq_page_content->description = $request->updated_description[$update_key];
                    $update_faq_page_content->save(); 

                }else{
                    PersonalisedGiftAppFaqPageContent::where('id', $updated_faq_page)->delete();
                }
            }
        }

        if($request->titles){
            foreach($request->titles as $key => $title)
            {
                if(!empty($title)){
                    $faq_page_content = new PersonalisedGiftAppFaqPageContent();
                    $faq_page_content->title = $title;
                    $faq_page_content->description = $request->description[$key];
                    $faq_page_content->save(); 
                }      
            }
        }
        return redirect('admin/faq-page')->with('success', 'The faq page content successfully updated in the system.');
    }

    public function deleteFaqPageContent(Request $request, $id)
    {
        $faq_page_content = PersonalisedGiftAppFaqPageContent::findorfail($id);
        $faq_page_content->delete();
        return redirect()->back()->with('success', 'The faq page content data has deleted successfully.');
    }

}
