import { IncomingMessage as IncomingMessage$1, ServerResponse as ServerResponse$1, OutgoingMessage } from 'http';
import { CookieSerializeOptions } from 'cookie-es';
import * as ufo from 'ufo';

declare class H3Headers implements Headers {
    _headers: Record<string, string>;
    constructor(init?: HeadersInit);
    append(name: string, value: string): void;
    delete(name: string): void;
    get(name: string): string | null;
    has(name: string): boolean;
    set(name: string, value: string): void;
    forEach(callbackfn: (value: string, key: string, parent: Headers) => void): void;
}

declare class H3Response implements Response {
    readonly headers: H3Headers;
    readonly status: number;
    readonly statusText: string;
    readonly redirected: boolean;
    readonly ok: boolean;
    readonly url: string;
    _body: string | ArrayBuffer | Uint8Array;
    readonly body: ReadableStream<Uint8Array> | null;
    readonly type: ResponseType;
    readonly bodyUsed = false;
    constructor(body?: BodyInit | HandlerResponse | null, init?: ResponseInit);
    clone(): H3Response;
    arrayBuffer(): Promise<ArrayBuffer>;
    blob(): Promise<Blob>;
    formData(): Promise<FormData>;
    json<T = any>(): Promise<T>;
    text(): Promise<string>;
}

declare class H3Event implements Pick<FetchEvent, 'respondWith'> {
    '__is_event__': boolean;
    req: IncomingMessage;
    res: ServerResponse;
    event: H3Event;
    context: H3EventContext;
    constructor(req: IncomingMessage$1 | IncomingMessage, res: ServerResponse$1 | ServerResponse);
    respondWith(r: H3Response | PromiseLike<H3Response>): void;
}
declare function isEvent(input: any): input is H3Event;
declare function createEvent(req: IncomingMessage$1, res: ServerResponse$1): H3Event;

declare function defineEventHandler<T = any>(handler: EventHandler<T>): EventHandler<T>;
declare const eventHandler: typeof defineEventHandler;
declare function isEventHandler(input: any): input is EventHandler;
declare function toEventHandler(handler: CompatibilityEventHandler): EventHandler;
interface DynamicEventHandler extends EventHandler {
    set: (handler: EventHandler) => void;
}
declare function dynamicEventHandler(initial?: EventHandler): DynamicEventHandler;
declare function defineLazyEventHandler(factory: LazyEventHandler): EventHandler;
declare const lazyEventHandler: typeof defineLazyEventHandler;

interface CompatibilityRequestProps {
    event: H3Event;
    context: H3EventContext;
    /** Only available with connect and press */
    originalUrl?: string;
}
interface IncomingMessage extends IncomingMessage$1, CompatibilityRequestProps {
    req: H3Event['req'];
    res: H3Event['res'];
}
interface ServerResponse extends ServerResponse$1 {
    event: H3Event;
    res: H3Event['res'];
    req: ServerResponse$1['req'] & CompatibilityRequestProps;
}
declare type Handler<T = any, ReqT = {}> = (req: IncomingMessage & ReqT, res: ServerResponse) => T;
declare type PromisifiedHandler = Handler<Promise<any>>;
declare type Middleware = (req: IncomingMessage, res: ServerResponse, next: (err?: Error) => any) => any;
declare type LazyHandler = () => Handler | Promise<Handler>;
declare type Encoding = false | 'ascii' | 'utf8' | 'utf-8' | 'utf16le' | 'ucs2' | 'ucs-2' | 'base64' | 'latin1' | 'binary' | 'hex';
declare type HTTPMethod = 'GET' | 'HEAD' | 'PATCH' | 'POST' | 'PUT' | 'DELETE' | 'CONNECT' | 'OPTIONS' | 'TRACE';
interface H3EventContext extends Record<string, any> {
}
declare type CompatibilityEvent = H3Event | IncomingMessage;
declare type HandlerResponse<T = any> = T | Promise<T>;
interface EventHandler<T = any> {
    '__is_handler__'?: true;
    (event: H3Event): HandlerResponse<T>;
}
declare type LazyEventHandler = () => EventHandler | Promise<EventHandler>;
declare type CompatibilityEventHandler = EventHandler | Handler | Middleware;

interface Layer {
    route: string;
    match?: Matcher;
    handler: EventHandler;
}
declare type Stack = Layer[];
interface InputLayer {
    route?: string;
    match?: Matcher;
    handler: Handler | LazyHandler | EventHandler | LazyEventHandler;
    lazy?: boolean;
    /** @deprecated */
    handle?: Handler;
    /** @deprecated */
    promisify?: boolean;
}
declare type InputStack = InputLayer[];
declare type Matcher = (url: string, event?: CompatibilityEvent) => boolean;
interface AppUse {
    (route: string | string[], handler: CompatibilityEventHandler | CompatibilityEventHandler[], options?: Partial<InputLayer>): App;
    (handler: CompatibilityEventHandler | CompatibilityEventHandler[], options?: Partial<InputLayer>): App;
    (options: InputLayer): App;
}
declare type NodeHandler = (req: IncomingMessage$1, res: ServerResponse$1) => Promise<void>;
interface App extends NodeHandler {
    stack: Stack;
    handler: EventHandler;
    nodeHandler: NodeHandler;
    use: AppUse;
}
interface AppOptions {
    debug?: boolean;
    onError?: (error: Error, event: CompatibilityEvent) => any;
}
declare function createApp(options?: AppOptions): App;
declare function use(app: App, arg1: string | Handler | InputLayer | InputLayer[], arg2?: Handler | Partial<InputLayer> | Handler[] | Middleware | Middleware[], arg3?: Partial<InputLayer>): App;
declare function createAppEventHandler(stack: Stack, options: AppOptions): EventHandler<void>;

/**
 * H3 Runtime Error
 * @class
 * @extends Error
 * @property {Number} statusCode An Integer indicating the HTTP response status code.
 * @property {String} statusMessage A String representing the HTTP status message
 * @property {String} fatal Indicates if the error is a fatal error.
 * @property {String} unhandled Indicates if the error was unhandled and auto captured.
 * @property {Any} data An extra data that will includes in the response.<br>
 *  This can be used to pass additional information about the error.
 * @property {Boolean} internal Setting this property to <code>true</code> will mark error as an internal error
 */
declare class H3Error extends Error {
    static __h3_error__: boolean;
    statusCode: number;
    fatal: boolean;
    unhandled: boolean;
    statusMessage: string;
    data?: any;
}
/**
 * Creates new `Error` that can be used to handle both internal and runtime errors.
 *
 * @param input {Partial<H3Error>}
 * @return {H3Error} An instance of the H3Error
 */
declare function createError(input: string | Partial<H3Error>): H3Error;
/**
 * Receive an error and return the corresponding response.<br>
 *  H3 internally uses this function to handle unhandled errors.<br>
 *  Note that calling this function will close the connection and no other data will be sent to client afterwards.
 *
 @param event {CompatibilityEvent} H3 event or req passed by h3 handler
 * @param error {H3Error|Error} Raised error
 * @param debug {Boolean} Whether application is in debug mode.<br>
 *  In the debug mode the stack trace of errors will be return in response.
 */
declare function sendError(event: CompatibilityEvent, error: Error | H3Error, debug?: boolean): void;
declare function isError(input: any): input is H3Error;

declare const defineHandler: <T>(handler: Handler<T, {}>) => Handler<T, {}>;
/** @deprecated Use defineHandler */
declare const defineHandle: <T>(handler: Handler<T, {}>) => Handler<T, {}>;
declare const defineMiddleware: (middleware: Middleware) => Middleware;
declare function promisifyHandler(handler: Handler | Middleware): PromisifiedHandler;
/** @deprecated Use defineHandler */
declare const promisifyHandle: typeof promisifyHandler;
declare function callHandler(handler: Middleware, req: IncomingMessage, res: ServerResponse): Promise<unknown>;
declare function defineLazyHandler(handler: LazyHandler, promisify?: boolean): Handler;
/** @deprecated Use defineLazyHandler */
declare const lazyHandle: typeof defineLazyHandler;
declare function useBase(base: string, handler: Handler): Handler;

/**
 * Reads body of the request and returns encoded raw string (default) or `Buffer` if encoding if falsy.
 * @param event {CompatibilityEvent} H3 event or req passed by h3 handler
 * @param encoding {Encoding} encoding="utf-8" - The character encoding to use.
 *
 * @return {String|Buffer} Encoded raw string or raw Buffer of the body
 */
declare function readRawBody(event: CompatibilityEvent, encoding?: Encoding): Encoding extends false ? Buffer : Promise<string | Buffer>;
/** @deprecated Use `h3.readRawBody` */
declare const useRawBody: typeof readRawBody;
/**
 * Reads request body and try to safely parse using [destr](https://github.com/unjs/destr)
 * @param event {CompatibilityEvent} H3 event or req passed by h3 handler
 * @param encoding {Encoding} encoding="utf-8" - The character encoding to use.
 *
 * @return {*} The `Object`, `Array`, `String`, `Number`, `Boolean`, or `null` value corresponding to the request JSON body
 *
 * ```ts
 * const body = await useBody(req)
 * ```
 */
declare function readBody<T = any>(event: CompatibilityEvent): Promise<T>;
/** @deprecated Use `h3.readBody` */
declare const useBody: typeof readBody;

interface CacheConditions {
    modifiedTime?: string | Date;
    maxAge?: number;
    etag?: string;
    cacheControls?: string[];
}
/**
 * Check request caching headers (`If-Modified-Since`) and add caching headers (Last-Modified, Cache-Control)
 * Note: `public` cache control will be added by default
 * @returns `true` when cache headers are matching. When `true` is returned, no reponse should be sent anymore
 */
declare function handleCacheHeaders(event: CompatibilityEvent, opts: CacheConditions): boolean;

declare const MIMES: {
    html: string;
    json: string;
};

/**
 * Parse the request to get HTTP Cookie header string and returning an object of all cookie name-value pairs.
 * @param event {CompatibilityEvent} H3 event or req passed by h3 handler
 * @returns Object of cookie name-value pairs
 * ```ts
 * const cookies = parseCookies(event)
 * ```
 */
declare function parseCookies(event: CompatibilityEvent): Record<string, string>;
/** @deprecated Use `h3.parseCookies` */
declare const useCookies: typeof parseCookies;
/**
 * Get a cookie value by name.
 * @param event {CompatibilityEvent} H3 event or req passed by h3 handler
 * @param name Name of the cookie to get
 * @returns {*} Value of the cookie (String or undefined)
 * ```ts
 * const authorization = useCookie(request, 'Authorization')
 * ```
 */
declare function getCookie(event: CompatibilityEvent, name: string): string | undefined;
/** @deprecated Use `h3.getCookie` */
declare const useCookie: typeof getCookie;
/**
 * Set a cookie value by name.
 * @param event {CompatibilityEvent} H3 event or res passed by h3 handler
 * @param name Name of the cookie to set
 * @param value Value of the cookie to set
 * @param serializeOptions {CookieSerializeOptions} Options for serializing the cookie
 * ```ts
 * setCookie(res, 'Authorization', '1234567')
 * ```
 */
declare function setCookie(event: CompatibilityEvent, name: string, value: string, serializeOptions?: CookieSerializeOptions): void;
/**
 * Set a cookie value by name.
 * @param event {CompatibilityEvent} H3 event or res passed by h3 handler
 * @param name Name of the cookie to delete
 * @param serializeOptions {CookieSerializeOptions} Cookie options
 * ```ts
 * deleteCookie(res, 'SessionId')
 * ```
 */
declare function deleteCookie(event: CompatibilityEvent, name: string, serializeOptions?: CookieSerializeOptions): void;

declare function getQuery(event: CompatibilityEvent): ufo.QueryObject;
/** @deprecated Use `h3.getQuery` */
declare const useQuery: typeof getQuery;
declare function getRouterParams(event: CompatibilityEvent): CompatibilityEvent['context'];
declare function getRouterParam(event: CompatibilityEvent, name: string): CompatibilityEvent['context'][string];
declare function getMethod(event: CompatibilityEvent, defaultMethod?: HTTPMethod): HTTPMethod;
/** @deprecated Use `h3.getMethod` */
declare const useMethod: typeof getMethod;
declare function isMethod(event: CompatibilityEvent, expected: HTTPMethod | HTTPMethod[], allowHead?: boolean): boolean;
declare function assertMethod(event: CompatibilityEvent, expected: HTTPMethod | HTTPMethod[], allowHead?: boolean): void;
declare function getRequestHeaders(event: CompatibilityEvent): CompatibilityEvent['req']['headers'];
declare const getHeaders: typeof getRequestHeaders;
declare function getRequestHeader(event: CompatibilityEvent, name: string): CompatibilityEvent['req']['headers'][string];
declare const getHeader: typeof getRequestHeader;

declare function send(event: CompatibilityEvent, data?: any, type?: string): Promise<void>;
declare function defaultContentType(event: CompatibilityEvent, type?: string): void;
declare function sendRedirect(event: CompatibilityEvent, location: string, code?: number): Promise<void>;
declare function getResponseHeaders(event: CompatibilityEvent): ReturnType<CompatibilityEvent['res']['getHeaders']>;
declare function getResponseHeader(event: CompatibilityEvent, name: string): ReturnType<CompatibilityEvent['res']['getHeader']>;
declare function setResponseHeaders(event: CompatibilityEvent, headers: Record<string, Parameters<OutgoingMessage['setHeader']>[1]>): void;
declare const setHeaders: typeof setResponseHeaders;
declare function setResponseHeader(event: CompatibilityEvent, name: string, value: Parameters<OutgoingMessage['setHeader']>[1]): void;
declare const setHeader: typeof setResponseHeader;
declare function appendResponseHeaders(event: CompatibilityEvent, headers: Record<string, string>): void;
declare const appendHeaders: typeof appendResponseHeaders;
declare function appendResponseHeader(event: CompatibilityEvent, name: string, value: string): void;
declare const appendHeader: typeof appendResponseHeader;
declare function isStream(data: any): any;
declare function sendStream(event: CompatibilityEvent, data: any): Promise<void>;

declare type RouterMethod = Lowercase<HTTPMethod>;
declare type RouterUse = (path: string, handler: CompatibilityEventHandler, method?: RouterMethod | RouterMethod[]) => Router;
declare type AddRouteShortcuts = Record<RouterMethod, RouterUse>;
interface Router extends AddRouteShortcuts {
    add: RouterUse;
    use: RouterUse;
    handler: EventHandler;
}
declare function createRouter(): Router;

export { AddRouteShortcuts, App, AppOptions, AppUse, CacheConditions, CompatibilityEvent, CompatibilityEventHandler, DynamicEventHandler, Encoding, EventHandler, H3Error, H3Event, H3EventContext, H3Headers, H3Response, HTTPMethod, Handler, HandlerResponse, IncomingMessage, InputLayer, InputStack, Layer, LazyEventHandler, LazyHandler, MIMES, Matcher, Middleware, NodeHandler, PromisifiedHandler, Router, RouterMethod, RouterUse, ServerResponse, Stack, appendHeader, appendHeaders, appendResponseHeader, appendResponseHeaders, assertMethod, callHandler, createApp, createAppEventHandler, createError, createEvent, createRouter, defaultContentType, defineEventHandler, defineHandle, defineHandler, defineLazyEventHandler, defineLazyHandler, defineMiddleware, deleteCookie, dynamicEventHandler, eventHandler, getCookie, getHeader, getHeaders, getMethod, getQuery, getRequestHeader, getRequestHeaders, getResponseHeader, getResponseHeaders, getRouterParam, getRouterParams, handleCacheHeaders, isError, isEvent, isEventHandler, isMethod, isStream, lazyEventHandler, lazyHandle, parseCookies, promisifyHandle, promisifyHandler, readBody, readRawBody, send, sendError, sendRedirect, sendStream, setCookie, setHeader, setHeaders, setResponseHeader, setResponseHeaders, toEventHandler, use, useBase, useBody, useCookie, useCookies, useMethod, useQuery, useRawBody };
