"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.build = void 0;
/* eslint-disable no-console */
const configs_1 = require("./configs");
const esbuild_1 = require("esbuild");
function build({ mode }) {
    return __awaiter(this, void 0, void 0, function* () {
        const isDevelopment = mode === 'development';
        const configs = (0, configs_1.getConfigs)();
        const { development: { entries, build = {}, develop = {}, buildDir }, } = configs;
        const { env = {} } = isDevelopment ? develop : build;
        const define = Object.keys(env || {}).reduce((acc, key) => (Object.assign(Object.assign({}, acc), { [`process.env.${key}`]: JSON.stringify(env[key]) })), { 'process.env.NODE_ENV': JSON.stringify(mode) });
        let built = false;
        (0, esbuild_1.build)({
            bundle: true,
            define,
            entryPoints: entries,
            loader: {
                '.esnext': 'ts',
                '.js': 'jsx',
            },
            logLevel: isDevelopment ? 'silent' : 'info',
            legalComments: 'none',
            minify: !isDevelopment,
            outdir: buildDir,
            plugins: getPlugins(),
            target: 'es6',
            resolveExtensions: ['.tsx', '.ts', '.js', '.json', '.esnext', '.mjs', '.ejs'],
            watch: isDevelopment ? { onRebuild } : false,
        })
            .then((result) => {
            if (built) {
                return;
            }
            built = true;
            return logResult(result);
        })
            .catch((_e) => {
            console.error('Error building extension: ', _e);
            if (!isDevelopment)
                process.exit(1);
        });
    });
}
exports.build = build;
function getPlugins() {
    const plugins = [];
    if (graphqlAvailable()) {
        const { default: graphqlLoader } = require('@luckycatfactory/esbuild-graphql-loader');
        plugins.push(graphqlLoader());
    }
    return plugins;
}
function graphqlAvailable() {
    try {
        // eslint-disable-next-line @babel/no-unused-expressions
        require.resolve('graphql') && require.resolve('graphql-tag');
        return true;
        // eslint-disable-next-line no-catch-all/no-catch-all
    }
    catch (_a) {
        return false;
    }
}
function onRebuild(failure, _result) {
    if (failure) {
        console.error(failure.message);
    }
    logResult(failure);
}
function logResult(result) {
    if ((result === null || result === void 0 ? void 0 : result.errors.length) || (result === null || result === void 0 ? void 0 : result.warnings.length)) {
        logErrors(result);
        return;
    }
    console.log(`Build succeeded`);
}
function logErrors(result) {
    const errors = (0, esbuild_1.formatMessagesSync)(result.errors, { kind: 'error' });
    const warnings = (0, esbuild_1.formatMessagesSync)(result.warnings, { kind: 'warning' });
    if (errors.length > 0)
        console.error(errors.join('\n'));
    if (warnings.length > 0)
        console.error(errors.join('\n'));
}
