import { decodeToml } from './toml.js';
import { fileExists, readFile, findPathUp } from './fs.js';
import { joinPath } from './path.js';
export const environmentsFilename = 'shopify.environments.toml';
/**
 * Loads environments from a directory.
 * @param dir - The directory to load environments from.
 * @param opts - Options for loading environments, including:
 * - findUp: whether to search upwards for an environments file.
 * @returns The loaded environments.
 */
export async function loadEnvironmentsFromDirectory(dir, opts) {
    let environmentsFilePath;
    if (opts?.findUp) {
        environmentsFilePath = await findPathUp(environmentsFilename, {
            cwd: dir,
            type: 'file',
        });
    }
    else {
        const allowedEnvironmentsFilePath = joinPath(dir, environmentsFilename);
        if (await fileExists(allowedEnvironmentsFilePath)) {
            environmentsFilePath = allowedEnvironmentsFilePath;
        }
    }
    if (environmentsFilePath) {
        return decodeToml(await readFile(environmentsFilePath));
    }
    else {
        return {};
    }
}
//# sourceMappingURL=environments.js.map