import { GraphQLVariables } from '../../../private/node/api/graphql.js';
import FormData from 'form-data';
import { Response } from 'node-fetch';
/**
 * Executes a GraphQL query against the Oxygen API.
 *
 * @param oxygenAddress - Oxygen address to query.
 * @param query - GraphQL query to execute.
 * @param token - Shopify access token.
 * @param variables - GraphQL variables to pass to the query.
 * @returns The response of the query of generic type <T>.
 */
export declare function oxygenRequest<T>(oxygenAddress: string, query: string, token: string, variables?: GraphQLVariables): Promise<T>;
/**
 * Uploads a deployment file to the Oxygen API.
 *
 * @param oxygenAddress - Oxygen address to upload to.
 * @param token - Shopify access token.
 * @param data - FormData to upload.
 * @returns The response of the query.
 */
export declare function uploadOxygenDeploymentFile(oxygenAddress: string, token: string, data: FormData): Promise<Response>;
