import { Token, TokenItem } from '../../private/node/ui/components/TokenizedText.js';
export type RandomNameFamily = 'business' | 'creative';
/**
 * Generates a random name by combining an adjective and noun.
 *
 * @param family - Theme to use for the random name (business or creative).
 * @returns A random name generated by combining an adjective and noun.
 */
export declare function getRandomName(family?: RandomNameFamily): string;
/**
 * Given a string, it returns it with the first letter capitalized.
 *
 * @param str - String to capitalize.
 * @returns String with the first letter capitalized.
 */
export declare function capitalize(str: string): string;
/**
 * Given a list of items, it returns a pluralized string based on the amount of items.
 *
 * @param items - List of items.
 * @param plural - Supplier used when the list of items has more than one item.
 * @param singular - Supplier used when the list of items has a single item.
 * @param none - Supplier used when the list has no items.
 * @returns The {@link TokenItem} supplied by the {@link plural}, {@link singular}, or {@link none} functions.
 */
export declare function pluralize<T, TToken extends Token = Token, TPluralToken extends TToken = TToken, TSingularToken extends TToken = TToken, TNoneToken extends TToken = TToken>(items: T[], plural: (items: T[]) => TokenItem<TPluralToken>, singular: (item: T) => TokenItem<TSingularToken>, none?: () => TokenItem<TNoneToken>): TokenItem<TPluralToken | TSingularToken | TNoneToken> | string;
/**
 * Try to convert a string to an int, falling back to undefined if unable to.
 *
 * @param maybeInt - String to convert to an int.
 * @returns The int if it was able to convert, otherwise undefined.
 */
export declare function tryParseInt(maybeInt: string | undefined): number | undefined;
/**
 * Transforms a matrix of strings into a single string with the columns aligned.
 *
 * @param lines - Array of rows, where each row is an array of strings (representing columns).
 * @returns A string with the columns aligned.
 */
export declare function linesToColumns(lines: string[][]): string;
/**
 * Given a string, it transforms it to a slug (lowercase, hyphenated, no special chars, trimmed...).
 *
 * @param str - String to slugify.
 * @returns The slugified string.
 */
export declare function slugify(str: string): string;
/**
 * Given a string, it returns it with the special regex characters escaped.
 * More info: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions#escaping.
 *
 * @param str - String to escape.
 * @returns The escaped string.
 */
export declare function escapeRegExp(str: string): string;
/**
 * Transform a string to camelCase.
 *
 * @param input - String to escape.
 * @returns The escaped string.
 */
export declare function camelize(input: string): string;
/**
 * Transform a string to param-case.
 *
 * @param input - String to transform.
 * @returns The transformed string.
 */
export declare function hyphenate(input: string): string;
/**
 * Transform a string to snake_case.
 *
 * @param input - String to transform.
 * @returns The transformed string.
 */
export declare function underscore(input: string): string;
/**
 * Transform a string to CONSTANT_CASE.
 *
 * @param input - String to transform.
 * @returns The transformed string.
 */
export declare function constantize(input: string): string;
