import { TextInput } from './TextInput.js';
import { TokenizedText } from './TokenizedText.js';
import { handleCtrlC } from '../../ui.js';
import useLayout from '../hooks/use-layout.js';
import { messageWithPunctuation } from '../utilities.js';
import React, { useCallback, useState } from 'react';
import { Box, useApp, useInput, Text } from 'ink';
import figures from 'figures';
const TextPrompt = ({ message, onSubmit, validate, defaultValue = '', password = false, }) => {
    if (password && defaultValue) {
        throw new Error("Can't use defaultValue with password");
    }
    const validateAnswer = (value) => {
        if (validate) {
            return validate(value);
        }
        if (value.length === 0)
            return 'Type an answer to the prompt.';
        return undefined;
    };
    const { oneThird } = useLayout();
    const [answer, setAnswer] = useState('');
    const answerOrDefault = answer.length > 0 ? answer : defaultValue;
    const { exit: unmountInk } = useApp();
    const [submitted, setSubmitted] = useState(false);
    const [error, setError] = useState(undefined);
    const shouldShowError = submitted && error;
    const color = shouldShowError ? 'red' : 'cyan';
    const underline = new Array(oneThird - 3).fill('▔');
    useInput(useCallback((input, key) => {
        handleCtrlC(input, key);
        if (key.return) {
            setSubmitted(true);
            const error = validateAnswer(answerOrDefault);
            setError(error);
            if (!error) {
                onSubmit(answerOrDefault);
                unmountInk();
            }
        }
    }, [answerOrDefault, onSubmit]));
    return (React.createElement(Box, { flexDirection: "column", marginBottom: 1, width: oneThird },
        React.createElement(Box, null,
            React.createElement(Box, { marginRight: 2 },
                React.createElement(Text, null, "?")),
            React.createElement(TokenizedText, { item: messageWithPunctuation(message) })),
        submitted && !error ? (React.createElement(Box, null,
            React.createElement(Box, { marginRight: 2 },
                React.createElement(Text, { color: "cyan" }, figures.tick)),
            React.createElement(Box, { flexGrow: 1 },
                React.createElement(Text, { color: "cyan" }, password ? '*'.repeat(answer.length) : answerOrDefault)))) : (React.createElement(Box, { flexDirection: "column" },
            React.createElement(Box, null,
                React.createElement(Box, { marginRight: 2 },
                    React.createElement(Text, { color: color }, `>`)),
                React.createElement(Box, { flexGrow: 1 },
                    React.createElement(TextInput, { value: answer, onChange: (answer) => {
                            setAnswer(answer);
                            setSubmitted(false);
                        }, defaultValue: defaultValue, color: color, password: password }))),
            React.createElement(Box, { marginLeft: 3 },
                React.createElement(Text, { color: color }, underline)),
            shouldShowError ? (React.createElement(Box, { marginLeft: 3 },
                React.createElement(Text, { color: color }, error))) : null))));
};
export { TextPrompt };
//# sourceMappingURL=TextPrompt.js.map