import chalk from 'chalk';
import { Text } from 'ink';
import React from 'react';
import terminalLink from 'terminal-link';
function fallback(text, url) {
    return `${text} ${chalk.dim(`( ${url} )`)}`;
}
/**
 * `Link` displays a clickable link when supported by the terminal.
 */
const Link = ({ url, label }) => {
    return React.createElement(Text, null, terminalLink(label ?? url, url, { fallback: label ? fallback : false }));
};
export { Link };
//# sourceMappingURL=Link.js.map