import { partnersFqdn } from '@shopify/cli-kit/node/context/fqdn';
import { renderInfo } from '@shopify/cli-kit/node/ui';
import { outputContent, outputInfo, outputToken } from '@shopify/cli-kit/node/output';
export async function outputUpdateURLsResult(updated, urls, app) {
    const dashboardURL = await partnersURL(app.organizationId, app.id);
    if (app.newApp) {
        renderInfo({
            headline: `For your convenience, we've given your app a default URL: ${urls.applicationUrl}.`,
            body: [
                "You can update your app's URL anytime in the",
                dashboardURL,
                'But once your app is live, updating its URL will disrupt merchant access.',
            ],
        });
    }
    else if (!updated) {
        renderInfo({
            body: [
                'To make URL updates manually, you can add the following URLs as redirects in your',
                dashboardURL,
                { char: ':' },
                '\n\n',
                { list: { items: urls.redirectUrlWhitelist } },
            ],
        });
    }
}
export function outputExtensionsMessages(app) {
    outputFunctionsMessage(app.extensions.function);
    outputThemeExtensionsMessage(app.extensions.theme);
}
function outputFunctionsMessage(extensions) {
    if (extensions.length === 0)
        return;
    const names = extensions.map((ext) => ext.configuration.name);
    const heading = outputToken.heading(names.join(', '));
    const message = `These extensions need to be deployed to be manually tested.
One testing option is to use a separate app dedicated to staging.`;
    outputInfo(outputContent `${heading}\n${message}\n`);
}
function outputThemeExtensionsMessage(extensions) {
    if (extensions.length === 0)
        return;
    for (const extension of extensions) {
        const message = extension.previewMessage('', '');
        if (message)
            outputInfo(message);
    }
}
async function partnersURL(organizationId, appId) {
    return {
        link: {
            label: 'Partners Dashboard',
            url: `https://${await partnersFqdn()}/${organizationId}/apps/${appId}/edit`,
        },
    };
}
//# sourceMappingURL=output.js.map