import { selectRemoteSourcePrompt } from './prompts.js';
/**
 * Prompt the user to manually match each of the local sources to a remote source.
 * Sources can either be extensions or functions.
 *
 * The user can also select to create a new remote source instead of selecting an existing one.
 * Manual matching will only show sources of the same type as possible matches.
 * At the end of this process, all remote sources must be matched with the local sources to succeed.
 *
 * @param local - The local sources to match
 * @param remote - The remote sources to match
 * @returns The result of the manual matching
 */
export async function manualMatchIds(options, remoteIdField) {
    const identifiers = {};
    let pendingRemote = options.remote;
    let pendingLocal = options.local;
    for (const currentLocal of options.local) {
        const remoteSourcesOfSameType = pendingRemote.filter((remoteSource) => remoteSource.type === currentLocal.graphQLType);
        if (remoteSourcesOfSameType.length === 0)
            continue;
        // eslint-disable-next-line no-await-in-loop
        const selected = await selectRemoteSourcePrompt(currentLocal, remoteSourcesOfSameType, remoteIdField);
        if (!selected)
            continue;
        identifiers[currentLocal.localIdentifier] = selected[remoteIdField];
        pendingRemote = pendingRemote.filter((remote) => remote[remoteIdField] !== selected[remoteIdField]);
        pendingLocal = pendingLocal.filter((local) => local.localIdentifier !== currentLocal.localIdentifier);
    }
    return {
        identifiers,
        toCreate: pendingLocal,
        onlyRemote: pendingRemote,
    };
}
//# sourceMappingURL=id-manual-matching.js.map