import { UIExtensionSpec } from '../../models/extensions/ui.js';
import { FunctionSpec } from '../../models/extensions/functions.js';
import { FanoutHookFunction, HookReturnsPerPlugin } from '@shopify/cli-kit/node/plugins';
export { createUIExtensionSpecification, UIExtensionSpec, CreateExtensionSpecType } from '../../models/extensions/ui.js';
export { createFunctionSpecification, FunctionSpec, CreateFunctionSpecType } from '../../models/extensions/functions.js';
export { fetchProductVariant } from '../../utilities/extensions/fetch-product-variant.js';
export { loadLocalesConfig } from '../../utilities/extensions/locales-configuration.js';
export * from '../../models/extensions/schemas.js';
/**
 * Extension Plugins types.
 *
 * Any plugin that provides extension definitions should implement `defineExtensionSpecs`.
 */
export interface HookReturnPerExtensionPlugin extends HookReturnsPerPlugin {
    extension_specs: {
        options: {
            [key: string]: never;
        };
        pluginReturns: {
            [pluginName: string]: UIExtensionSpec[];
        };
    };
    function_specs: {
        options: {
            [key: string]: never;
        };
        pluginReturns: {
            [pluginName: string]: FunctionSpec[];
        };
    };
}
export type ExtensionSpecsFunction = FanoutHookFunction<'extension_specs', '', HookReturnPerExtensionPlugin>;
export type FunctionSpecsFunction = FanoutHookFunction<'function_specs', '', HookReturnPerExtensionPlugin>;
/**
 * A function for plugins to register new UI extension types.
 *
 * @param specifications - The UI extension specifications to register.
 * @returns A function that returns the list of specifications.
 * @example
 */
export declare const registerUIExtensionSpecifications: <TConfiguration extends {
    description?: string | undefined;
    apiVersion?: string | undefined;
    extensionPoints?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    type: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    name: string;
} = {
    description?: string | undefined;
    apiVersion?: string | undefined;
    extensionPoints?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
    } | undefined;
    categories?: string[] | undefined;
    type: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    name: string;
}>(specifications: UIExtensionSpec<TConfiguration>[]) => ExtensionSpecsFunction;
/**
 * A function for plugins to register new function types.
 *
 * @param specifications - The function specifications to register.
 * @returns A function that returns the list of specifications.
 * @example
 */
export declare const registerFunctionSpecifications: (specifications: FunctionSpec[]) => FunctionSpecsFunction;
